/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.ConsentHeader;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.ProcessingContextHeader;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.ServiceInstanceUpdateHeader;
import com.sun.identity.liberty.ws.soapbinding.UsageDirectiveHeader;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Message {
    public static final int ANONYMOUS = 0;
    public static final int X509_TOKEN = 1;
    public static final int SAML_TOKEN = 2;
    public static final int BEARER_TOKEN = 3;
    public static final String NULL_NULL = "urn:liberty:security:2003-08:null:null";
    public static final String NULL_X509 = "urn:liberty:security:2003-08:null:X509";
    public static final String NULL_SAML = "urn:liberty:security:2003-08:null:SAML";
    public static final String NULL_BEARER = "urn:liberty:security:2004-04:null:Bearer";
    public static final String TLS_NULL = "urn:liberty:security:2003-08:TLS:null";
    public static final String TLS_X509 = "urn:liberty:security:2003-08:TLS:X509";
    public static final String TLS_SAML = "urn:liberty:security:2003-08:TLS:SAML";
    public static final String TLS_BEARER = "urn:liberty:security:2004-04:TLS:Bearer";
    public static final String CLIENT_TLS_NULL = "urn:liberty:security:2003-08:ClientTLS:null";
    public static final String CLIENT_TLS_X509 = "urn:liberty:security:2003-08:ClientTLS:X509";
    public static final String CLIENT_TLS_SAML = "urn:liberty:security:2003-08:ClientTLS:SAML";
    public static final String CLIENT_TLS_BEARER = "urn:liberty:security:2004-04:ClientTLS:Bearer";
    public static final String NULL_X509_WSF11 = "urn:liberty:security:2005-02:null:X509";
    public static final String TLS_X509_WSF11 = "urn:liberty:security:2005-02:TLS:X509";
    public static final String CLIENT_TLS_X509_WSF11 = "urn:liberty:security:2005-02:ClientTLS:X509";
    public static final String NULL_SAML_WSF11 = "urn:liberty:security:2005-02:null:SAML";
    public static final String TLS_SAML_WSF11 = "urn:liberty:security:2005-02:TLS:SAML";
    public static final String CLIENT_TLS_SAML_WSF11 = "urn:liberty:security:2005-02:ClientTLS:SAML";
    public static final String NULL_BEARER_WSF11 = "urn:liberty:security:2005-02:null:Bearer";
    public static final String TLS_BEARER_WSF11 = "urn:liberty:security:2005-02:TLS:Bearer";
    public static final String CLIENT_TLS_BEARER_WSF11 = "urn:liberty:security:2005-02:ClientTLS:Bearer";
    private int securityProfileType = 0;
    private CorrelationHeader correlationHeader = null;
    private ConsentHeader consentHeader = null;
    private List usageDirectiveHeaders = null;
    private ProviderHeader providerHeader = null;
    private ProcessingContextHeader processingContextHeader = null;
    private ServiceInstanceUpdateHeader serviceInstanceUpdateHeader = null;
    private List soapHeaders = null;
    private List soapBodies = null;
    private List securityHeaders = null;
    private List signingIds = null;
    private SOAPFault soapFault = null;
    private String ipAddress = null;
    private String protocol = "http";
    private SecurityAssertion assertion = null;
    private BinarySecurityToken binarySecurityToken = null;
    private X509Certificate certificate = null;
    private X509Certificate messageCertificate = null;
    private Object token = null;
    private String bodyId = null;
    private boolean clientAuthentication = false;
    private String authenticationMechanism = null;
    private Document doc = null;
    private String wsfVersion = "1.1";

    public Message() {
        this.correlationHeader = new CorrelationHeader();
        this.securityProfileType = 0;
    }

    public Message(ProviderHeader providerHeader) throws SOAPBindingException {
        this.correlationHeader = new CorrelationHeader();
        this.providerHeader = providerHeader;
        this.securityProfileType = 0;
    }

    public Message(ProviderHeader providerHeader, SecurityAssertion assertion) throws SOAPBindingException {
        if (assertion == null) {
            throw new SOAPBindingException(Utils.bundle.getString("SAMLAssertionNull"));
        }
        this.assertion = assertion;
        if (assertion.isBearer()) {
            this.securityProfileType = 3;
        } else {
            this.securityProfileType = 2;
            this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(assertion);
        }
        this.correlationHeader = new CorrelationHeader();
        this.providerHeader = providerHeader;
    }

    public Message(ProviderHeader providerHeader, BinarySecurityToken token) throws SOAPBindingException {
        if (token == null) {
            throw new SOAPBindingException(Utils.bundle.getString("binarySecurityTokenNull"));
        }
        this.binarySecurityToken = token;
        this.wsfVersion = this.binarySecurityToken.getWSFVersion();
        this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(this.binarySecurityToken);
        this.correlationHeader = new CorrelationHeader();
        this.providerHeader = providerHeader;
        this.securityProfileType = 1;
    }

    public Message(SOAPFault soapFault) {
        this.soapFault = soapFault;
        this.correlationHeader = new CorrelationHeader();
    }

    public Message(InputStream inputStream) throws SOAPBindingException {
        try {
            this.doc = XMLUtils.toDOMDocument(inputStream, Utils.debug);
            this.parseDocument(this.doc);
        }
        catch (Exception ex) {
            Utils.debug.error("Message:Message", ex);
            throw new SOAPBindingException(ex.getMessage());
        }
    }

    public Message(SOAPMessage soapMessage) throws SOAPBindingException, SOAPFaultException {
        try {
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)bop);
            ByteArrayInputStream bin = new ByteArrayInputStream(bop.toByteArray());
            this.doc = XMLUtils.toDOMDocument(bin, Utils.debug);
            this.parseDocument(this.doc);
        }
        catch (Exception ex) {
            Utils.debug.error("Message:Message", ex);
            throw new SOAPBindingException(ex.getMessage());
        }
    }

    public int getSecurityProfileType() {
        return this.securityProfileType;
    }

    public void setSecurityProfileType(int profileType) {
        this.securityProfileType = profileType;
    }

    public void setBinarySecurityToken(BinarySecurityToken binaryToken) {
        this.binarySecurityToken = binaryToken;
        this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(this.binarySecurityToken);
    }

    public String getAuthenticationMechanism() {
        if (this.authenticationMechanism != null) {
            return this.authenticationMechanism;
        }
        if (this.protocol.equalsIgnoreCase("https")) {
            if (this.certificate == null) {
                switch (this.securityProfileType) {
                    case 1: {
                        this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? TLS_X509_WSF11 : TLS_X509;
                        return this.authenticationMechanism;
                    }
                    case 2: {
                        this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? TLS_SAML_WSF11 : TLS_SAML;
                        return this.authenticationMechanism;
                    }
                    case 3: {
                        this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? TLS_BEARER_WSF11 : TLS_BEARER;
                        return this.authenticationMechanism;
                    }
                }
                this.authenticationMechanism = TLS_NULL;
                return this.authenticationMechanism;
            }
            switch (this.securityProfileType) {
                case 1: {
                    this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? CLIENT_TLS_X509_WSF11 : CLIENT_TLS_X509;
                    return this.authenticationMechanism;
                }
                case 2: {
                    this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? CLIENT_TLS_SAML_WSF11 : CLIENT_TLS_SAML;
                    return this.authenticationMechanism;
                }
                case 3: {
                    this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? CLIENT_TLS_BEARER_WSF11 : CLIENT_TLS_BEARER;
                    return this.authenticationMechanism;
                }
            }
            this.authenticationMechanism = CLIENT_TLS_NULL;
            return this.authenticationMechanism;
        }
        switch (this.securityProfileType) {
            case 1: {
                this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? NULL_X509_WSF11 : NULL_X509;
                return this.authenticationMechanism;
            }
            case 2: {
                this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? NULL_SAML_WSF11 : NULL_SAML;
                return this.authenticationMechanism;
            }
            case 3: {
                this.authenticationMechanism = "1.1".equals(this.wsfVersion) ? NULL_BEARER_WSF11 : NULL_BEARER;
                return this.authenticationMechanism;
            }
        }
        this.authenticationMechanism = NULL_NULL;
        return this.authenticationMechanism;
    }

    public boolean isClientAuthentication() {
        return this.clientAuthentication;
    }

    public CorrelationHeader getCorrelationHeader() {
        return this.correlationHeader;
    }

    public ConsentHeader getConsentHeader() {
        return this.consentHeader;
    }

    public List getUsageDirectiveHeaders() {
        return this.usageDirectiveHeaders;
    }

    public ProviderHeader getProviderHeader() {
        return this.providerHeader;
    }

    public ProcessingContextHeader getProcessingContextHeader() {
        return this.processingContextHeader;
    }

    public ServiceInstanceUpdateHeader getServiceInstanceUpdateHeader() {
        return this.serviceInstanceUpdateHeader;
    }

    public List getOtherSOAPHeaders() {
        return this.soapHeaders;
    }

    public SOAPFault getSOAPFault() {
        return this.soapFault;
    }

    public List getBodies() {
        return this.soapBodies;
    }

    public List getBodies(String namespaceURI, String localName) {
        ArrayList<Element> bodies = new ArrayList<Element>();
        if (this.soapBodies != null && !this.soapBodies.isEmpty()) {
            Iterator iter = this.soapBodies.iterator();
            while (iter.hasNext()) {
                Element bodyE = (Element)iter.next();
                String ln = bodyE.getLocalName();
                String ns = bodyE.getNamespaceURI();
                if ((ns != null || namespaceURI != null) && (ns == null || !ns.equals(namespaceURI)) || !ln.equals(localName)) continue;
                bodies.add(bodyE);
            }
        }
        return this.soapBodies;
    }

    public List getOtherSecurityHeaders() {
        return this.securityHeaders;
    }

    public SecurityAssertion getAssertion() {
        return this.assertion;
    }

    public BinarySecurityToken getBinarySecurityToken() {
        return this.binarySecurityToken;
    }

    public X509Certificate getPeerCertificate() {
        return this.certificate;
    }

    public X509Certificate getMessageCertificate() {
        return this.messageCertificate;
    }

    public Object getToken() {
        return this.token;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public List getSigningIds() {
        String id;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.correlationHeader.getId());
        if (this.consentHeader != null && (id = this.consentHeader.getId()) != null) {
            ids.add(id);
        }
        if (this.usageDirectiveHeaders != null && !this.usageDirectiveHeaders.isEmpty()) {
            Iterator iter = this.usageDirectiveHeaders.iterator();
            while (iter.hasNext()) {
                String id2 = ((UsageDirectiveHeader)iter.next()).getId();
                if (id2 == null) continue;
                ids.add(id2);
            }
        }
        if (this.providerHeader != null && (id = this.providerHeader.getId()) != null) {
            ids.add(id);
        }
        if (this.processingContextHeader != null && (id = this.processingContextHeader.getId()) != null) {
            ids.add(id);
        }
        if (this.serviceInstanceUpdateHeader != null && (id = this.serviceInstanceUpdateHeader.getId()) != null) {
            ids.add(id);
        }
        if (this.signingIds != null && !this.signingIds.isEmpty()) {
            ids.addAll(this.signingIds);
        }
        if (this.bodyId == null) {
            this.bodyId = SAMLUtils.generateID();
        }
        ids.add(this.bodyId);
        return ids;
    }

    public void setCorrelationHeader(CorrelationHeader correlationHeader) {
        if (correlationHeader != null) {
            this.correlationHeader = correlationHeader;
        }
    }

    public void setConsentHeader(ConsentHeader consentHeader) {
        this.consentHeader = consentHeader;
    }

    public void setUsageDirectiveHeaders(List usageDirectiveHeaders) {
        this.usageDirectiveHeaders = usageDirectiveHeaders;
    }

    public void setProviderHeader(ProviderHeader providerHeader) {
        this.providerHeader = providerHeader;
    }

    public void setProcessingContextHeader(ProcessingContextHeader processingContextHeader) {
        this.processingContextHeader = processingContextHeader;
    }

    public void setServiceInstanceUpdateHeader(ServiceInstanceUpdateHeader serviceInstanceUpdateHeader) {
        this.serviceInstanceUpdateHeader = serviceInstanceUpdateHeader;
    }

    public void setOtherSOAPHeaders(List headers, List signingIds) {
        this.soapHeaders = headers;
        this.signingIds = signingIds;
    }

    public void setOtherSOAPHeader(Element header, String signingId) {
        this.soapHeaders = new ArrayList(1);
        this.soapHeaders.add(header);
        if (signingId != null) {
            this.signingIds = new ArrayList(1);
            this.signingIds.add(signingId);
        }
    }

    public void setOtherSecurityHeaders(List headers) {
        this.securityHeaders = headers;
    }

    public void setOtherSecurityHeader(Element header) {
        this.securityHeaders = new ArrayList(1);
        this.securityHeaders.add(header);
    }

    public void setSOAPFault(SOAPFault soapFault) {
        this.soapFault = soapFault;
    }

    public void setSOAPBodies(List bodies) {
        this.soapBodies = bodies;
    }

    public void setSOAPBody(Element body) {
        this.soapBodies = new ArrayList(1);
        this.soapBodies.add(body);
    }

    void setIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    void setProtocol(String protocol) {
        this.protocol = protocol == null ? "http" : protocol;
    }

    void setPeerCertificate(X509Certificate cert) {
        this.certificate = cert;
        this.clientAuthentication = this.certificate != null;
    }

    public void setClientAuthentication(boolean clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    void setToken(Object token) {
        this.token = token;
    }

    public String toString() {
        try {
            return XMLUtils.print(this.toDocument(true).getDocumentElement());
        }
        catch (Exception ex) {
            Utils.debug.error("Message.toString", ex);
            return "";
        }
    }

    public Document toDocument() throws SOAPBindingException {
        return this.toDocument(false);
    }

    public Document toDocument(boolean refresh) throws SOAPBindingException {
        Iterator iter;
        boolean hasSecurityHeaders;
        Iterator iter2;
        if (!refresh && this.doc != null) {
            return this.doc;
        }
        try {
            this.doc = XMLUtils.newDocument();
        }
        catch (Exception ex) {
            Utils.debug.error("Message:toDocument", ex);
            throw new SOAPBindingException(ex.getMessage());
        }
        String wsseNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        String wsuNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        if ("1.0".equals(this.wsfVersion)) {
            wsseNS = "http://schemas.xmlsoap.org/ws/2003/06/secext";
            wsuNS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
        }
        Element envelopeE = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Envelope");
        envelopeE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:S", "http://schemas.xmlsoap.org/soap/envelope/");
        envelopeE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sb", "urn:liberty:sb:2003-08");
        envelopeE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sb-ext", "urn:liberty:sb:2004-04");
        envelopeE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", wsuNS);
        this.doc.appendChild(envelopeE);
        Element headerE = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Header");
        envelopeE.appendChild(headerE);
        if (this.correlationHeader != null) {
            this.correlationHeader.addToParent(headerE);
        }
        if (this.consentHeader != null) {
            this.consentHeader.addToParent(headerE);
        }
        if (this.usageDirectiveHeaders != null && !this.usageDirectiveHeaders.isEmpty()) {
            iter2 = this.usageDirectiveHeaders.iterator();
            while (iter2.hasNext()) {
                ((UsageDirectiveHeader)iter2.next()).addToParent(headerE);
            }
        }
        if (this.providerHeader != null) {
            this.providerHeader.addToParent(headerE);
        }
        if (this.processingContextHeader != null) {
            this.processingContextHeader.addToParent(headerE);
        }
        if (this.serviceInstanceUpdateHeader != null) {
            this.serviceInstanceUpdateHeader.addToParent(headerE);
        }
        if (this.soapHeaders != null && !this.soapHeaders.isEmpty()) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding headers ");
            }
            iter2 = this.soapHeaders.iterator();
            while (iter2.hasNext()) {
                Element soapHeaderE = (Element)iter2.next();
                headerE.appendChild(this.doc.importNode(soapHeaderE, true));
            }
        }
        boolean bl = hasSecurityHeaders = this.securityHeaders != null && !this.securityHeaders.isEmpty();
        if (this.securityProfileType != 0 || hasSecurityHeaders) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding security headers ");
            }
            Element securityE = this.doc.createElementNS(wsseNS, "wsse:Security");
            securityE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", wsseNS);
            headerE.appendChild(securityE);
            if (this.assertion != null) {
                Document assertionDoc = XMLUtils.toDOMDocument(this.assertion.toString(true, true), Utils.debug);
                if (assertionDoc == null) {
                    String msg = Utils.bundle.getString("cannotProcessSAMLAssertion");
                    Utils.debug.error("Message.Message: " + msg);
                    throw new SOAPBindingException(msg);
                }
                Element assertionE = assertionDoc.getDocumentElement();
                securityE.appendChild(this.doc.importNode(assertionE, true));
            } else if (this.binarySecurityToken != null) {
                Document bstDoc = XMLUtils.toDOMDocument(this.binarySecurityToken.toString(), Utils.debug);
                if (bstDoc == null) {
                    String msg = Utils.bundle.getString("cannotProcessBinarySecurityToken");
                    Utils.debug.error("Message.Message: " + msg);
                    throw new SOAPBindingException(msg);
                }
                Element binarySecurityTokenE = bstDoc.getDocumentElement();
                securityE.appendChild(this.doc.importNode(binarySecurityTokenE, true));
            }
            if (hasSecurityHeaders) {
                iter = this.securityHeaders.iterator();
                while (iter.hasNext()) {
                    securityE.appendChild(this.doc.importNode((Node)iter.next(), true));
                }
            }
        }
        Element bodyE = null;
        if (this.soapFault != null) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding soapFault ");
            }
            bodyE = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Body");
            envelopeE.appendChild(bodyE);
            this.soapFault.addToParent(bodyE);
        }
        if (this.soapBodies != null && !this.soapBodies.isEmpty()) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding bodies ");
            }
            if (bodyE == null) {
                bodyE = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Body");
                bodyE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:S", "http://schemas.xmlsoap.org/soap/envelope/");
                envelopeE.appendChild(bodyE);
            }
            iter = this.soapBodies.iterator();
            while (iter.hasNext()) {
                Element soapBodyE = (Element)iter.next();
                bodyE.appendChild(this.doc.importNode(soapBodyE, true));
            }
            if (this.bodyId == null) {
                this.bodyId = SAMLUtils.generateID();
            }
            if ("1.0".equals(this.wsfVersion)) {
                bodyE.setAttributeNS(null, "id", this.bodyId);
            } else {
                bodyE.setAttributeNS(wsuNS, "wsu:Id", this.bodyId);
            }
        }
        return this.doc;
    }

    SOAPMessage toSOAPMessage() throws SOAPBindingException {
        return Utils.DocumentToSOAPMessage(this.toDocument(true));
    }

    private void parseDocument(Document doc) throws SOAPBindingException {
        String ns;
        String localName;
        Node child;
        NodeList nl;
        int length;
        Element envelopeE = doc.getDocumentElement();
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Message.parseDocument: doc = " + XMLUtils.print(envelopeE));
        }
        if ((length = (nl = envelopeE.getChildNodes()).getLength()) == 0) {
            String msg = Utils.bundle.getString("soapEnvelopeMissingChildren");
            Utils.debug.error("Message.parseDocument: " + msg);
            throw new SOAPBindingException(msg);
        }
        Node headerE = null;
        Node bodyE = null;
        for (int i = 0; i < length; ++i) {
            Node child2 = nl.item(i);
            if (child2.getNodeType() != 1) continue;
            Element element = (Element)child2;
            String localName2 = element.getLocalName();
            String namespaceURI = element.getNamespaceURI();
            if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) continue;
            if ("Header".equals(localName2)) {
                headerE = element;
                continue;
            }
            if (!"Body".equals(localName2)) continue;
            bodyE = element;
        }
        Element securityE = null;
        this.soapHeaders = new ArrayList();
        if (headerE != null) {
            nl = headerE.getChildNodes();
            length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                Element element = (Element)child;
                localName = element.getLocalName();
                ns = element.getNamespaceURI();
                if ("urn:liberty:sb:2003-08".equals(ns)) {
                    if ("Correlation".equals(localName)) {
                        this.correlationHeader = new CorrelationHeader(element);
                        continue;
                    }
                    if ("Consent".equals(localName)) {
                        this.consentHeader = new ConsentHeader(element);
                        continue;
                    }
                    if ("UsageDirective".equals(localName)) {
                        if (this.usageDirectiveHeaders == null) {
                            this.usageDirectiveHeaders = new ArrayList();
                        }
                        this.usageDirectiveHeaders.add(new UsageDirectiveHeader(element));
                        continue;
                    }
                    if ("Provider".equals(localName)) {
                        this.providerHeader = new ProviderHeader(element);
                        continue;
                    }
                    if ("ProcessingContext".equals(localName)) {
                        this.processingContextHeader = new ProcessingContextHeader(element);
                        continue;
                    }
                    this.soapHeaders.add(element);
                    continue;
                }
                if ("urn:liberty:sb:2004-04".equals(ns) && "ServiceInstanceUpdate".equals(localName)) {
                    this.serviceInstanceUpdateHeader = new ServiceInstanceUpdateHeader(element);
                    continue;
                }
                if ("http://schemas.xmlsoap.org/ws/2003/06/secext".equals(ns) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(ns)) {
                    if ("Security".equals(localName)) {
                        securityE = element;
                        continue;
                    }
                    this.soapHeaders.add(element);
                    continue;
                }
                this.soapHeaders.add(element);
            }
            this.parseSecurityElement(securityE);
        }
        if (this.soapHeaders.isEmpty()) {
            this.soapHeaders = null;
        }
        if (bodyE != null) {
            nl = bodyE.getChildNodes();
            length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                Element childE = (Element)child;
                localName = childE.getLocalName();
                ns = childE.getNamespaceURI();
                if (this.soapFault == null && "http://schemas.xmlsoap.org/soap/envelope/".equals(ns) && "Fault".equals(localName)) {
                    this.soapFault = new SOAPFault(childE);
                    continue;
                }
                if (this.soapBodies == null) {
                    this.soapBodies = new ArrayList();
                }
                this.soapBodies.add(child);
            }
        }
    }

    private void parseSecurityElement(Element securityE) throws SOAPBindingException {
        List list;
        if (securityE == null) {
            this.securityProfileType = 0;
            return;
        }
        String wsseNS = securityE.getNamespaceURI();
        if (wsseNS == null) {
            this.securityProfileType = 0;
            return;
        }
        String wsuNS = null;
        if (wsseNS.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
            this.wsfVersion = "1.1";
            wsuNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        } else if (wsseNS.equals("http://schemas.xmlsoap.org/ws/2003/06/secext")) {
            this.wsfVersion = "1.0";
            wsuNS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
        } else {
            this.securityProfileType = 0;
            return;
        }
        NodeList nl = securityE.getElementsByTagNameNS(wsseNS, "SecurityTokenReference");
        Element securityTokenRefE = null;
        String uri = null;
        if (nl != null && nl.getLength() > 0 && !(list = XMLUtils.getElementsByTagNameNS1(securityTokenRefE = (Element)nl.item(0), wsseNS, "Reference")).isEmpty()) {
            Element referenceE = (Element)list.get(0);
            uri = XMLUtils.getNodeAttributeValue(referenceE, "URI");
            if (uri == null || uri.length() <= 1 || !uri.startsWith("#")) {
                String msg = Utils.bundle.getString("invalidReferenceURI");
                Utils.debug.error("Message.parseSecurityElement: " + msg);
                throw new SOAPBindingException(msg);
            }
            uri = uri.substring(1);
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.parseSecurityElement: SecurityTokenReference Reference URI = " + uri);
            }
        }
        this.securityProfileType = 0;
        this.securityHeaders = new ArrayList();
        nl = securityE.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String localName = child.getLocalName();
            String ns = child.getNamespaceURI();
            if (this.securityProfileType != 0) {
                this.securityHeaders.add(child);
                continue;
            }
            if ("BinarySecurityToken".equals(localName) && wsseNS.equals(ns)) {
                String id;
                Element binarySecurityTokenE = (Element)child;
                String valuetype = XMLUtils.getNodeAttributeValue(binarySecurityTokenE, "ValueType");
                Utils.debug.message("ValueType: " + valuetype);
                if (valuetype != null && valuetype.endsWith("ServiceSessionContext")) {
                    this.securityHeaders.add(child);
                    continue;
                }
                if (uri != null && !uri.equals(id = XMLUtils.getNodeAttributeValueNS(binarySecurityTokenE, wsuNS, "Id"))) {
                    this.securityHeaders.add(child);
                    continue;
                }
                try {
                    this.binarySecurityToken = new BinarySecurityToken(binarySecurityTokenE);
                    this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(this.binarySecurityToken);
                }
                catch (Exception ex) {
                    String msg = Utils.bundle.getString("cannotProcessBinarySecurityToken");
                    Utils.debug.error("Message.parseSecurityElement: " + msg);
                    throw new SOAPBindingException(msg);
                }
                if (Utils.debug.messageEnabled()) {
                    Utils.debug.message("Message.parseSecurityElement: found binary security token");
                }
                this.securityProfileType = 1;
                continue;
            }
            if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(ns)) {
                String assertionID;
                Element assertionE = (Element)child;
                if (uri != null && !uri.equals(assertionID = XMLUtils.getNodeAttributeValue(assertionE, "AssertionID"))) {
                    this.securityHeaders.add(child);
                    continue;
                }
                try {
                    this.assertion = new SecurityAssertion(assertionE);
                }
                catch (SAMLException ex) {
                    String msg = Utils.bundle.getString("cannotProcessSAMLAssertion");
                    Utils.debug.error("Message.parseSecurityElement: " + msg);
                    throw new SOAPBindingException(msg);
                }
                if (Utils.debug.messageEnabled()) {
                    Utils.debug.message("Message.parseSecurityElement: found security assertion, isBearer = " + this.assertion.isBearer());
                }
                if (this.assertion.isBearer()) {
                    this.securityProfileType = 3;
                    continue;
                }
                this.securityProfileType = 2;
                this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(this.assertion);
                continue;
            }
            this.securityHeaders.add(child);
        }
        if (this.securityHeaders.isEmpty()) {
            this.securityHeaders = null;
        }
    }

    public String getWSFVersion() {
        return this.wsfVersion;
    }

    public void setWSFVersion(String version) {
        this.wsfVersion = version;
    }
}

