/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.interaction;

import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.interaction.InteractionConfig;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.liberty.ws.interaction.JAXBObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryElement;
import com.sun.identity.liberty.ws.interaction.jaxb.InteractionResponseElement;
import com.sun.identity.liberty.ws.interaction.jaxb.ParameterType;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WSPRedirectHandlerServlet
extends HttpServlet {
    private static Debug debug = Debug.getInstance("libInteraction");
    private static ResourceBundle i18n = ResourceBundle.getBundle("libInteraction");
    private static String PARAMETER_PREFIX = "isparam_";
    private static String TRUE_LABEL = "trueLabel";
    private static String FALSE_LABEL = "falseLabel";
    private static String HELP_LABEL = "helpLabel";
    private static String HINT_LABEL = "hintLabel";
    private static String LINK_LABEL = "linkLabel";
    private static String MORE_LINK_LABEL = "moreLinkLabel";
    private static String DEFAULT_TRUE_LABEL = "true";
    private static String DEFAULT_FALSE_LABEL = "false";
    private static String DEFAULT_HELP_LABEL = "help";
    private static String DEFAULT_HINT_LABEL = "hint";
    private static String DEFAULT_LINK_LABEL = "link";
    private static String DEFAULT_MORE_LINK_LABEL = "moreLink";
    private static int CONNECT_TIMEOUT = 5000;
    private static int READ_TIMEOUT = 5000;
    private DOMSource htmlStyleSource = null;
    private DOMSource wmlStyleSource = null;
    private static String WML_CLIENT = "WML";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String htmlStyleSheetLocation = InteractionConfig.getInstance().getHTMLStyleSheetLocation();
        String wmlStyleSheetLocation = InteractionConfig.getInstance().getWMLStyleSheetLocation();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new File(htmlStyleSheetLocation));
            this.htmlStyleSource = new DOMSource(doc);
            db = dbf.newDocumentBuilder();
            doc = db.parse(new File(wmlStyleSheetLocation));
            this.wmlStyleSource = new DOMSource(doc);
        }
        catch (ParserConfigurationException pce) {
            debug.error("WSPRedirectHandlerServlet.init()", pce);
            throw new ServletException((Throwable)pce);
        }
        catch (SAXException se) {
            debug.error("WSPRedirectHandlerServlet.init()", se);
            throw new ServletException((Throwable)se);
        }
        catch (IOException ioe) {
            debug.error("WSPRedirectHandlerServlet.init()", ioe);
            throw new ServletException((Throwable)ioe);
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.init():initialized");
        }
    }

    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        this.handleRequest(httpRequest, httpResponse);
    }

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        this.handleRequest(httpRequest, httpResponse);
    }

    private void handleRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        int j;
        int i;
        String wspRedirectHandler = InteractionConfig.getInstance().getWSPRedirectHandler();
        String lbWspRedirectHandler = InteractionConfig.getInstance().getLbWSPRedirectHandler();
        String queryString = httpRequest.getQueryString();
        String handlerHostId = null;
        if (queryString != null && (i = queryString.indexOf("HandlerHostId")) != -1 && (j = (handlerHostId = queryString.substring(i + "HandlerHostId".length() + 1)).indexOf("&")) != -1) {
            handlerHostId = handlerHostId.substring(0, j);
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.handleRequest():queryString: " + queryString + " : wspRedirectHandler:" + wspRedirectHandler + " : handlerHostId:" + handlerHostId + " : lbWspRedirectHandler:" + lbWspRedirectHandler);
        }
        if (handlerHostId != null) {
            Map trustedRedirectHandlers = InteractionConfig.getInstance().getTrustedWSPRedirectHandlers();
            if (!trustedRedirectHandlers.containsKey(handlerHostId)) {
                this.sendErrorPageUntrustedHost(httpRequest, httpResponse, handlerHostId);
                if (debug.warningEnabled()) {
                    debug.warning("WSPRedirectHandlerServlet.handleRequest():denied attempt to forward to untrusted host id:" + handlerHostId);
                }
                return;
            }
            String localServerId = InteractionConfig.getInstance().getLocalServerId();
            if (!handlerHostId.equals(localServerId)) {
                String handlerHostUrl = (String)trustedRedirectHandlers.get(handlerHostId);
                String forwardToUrl = handlerHostUrl + "?" + queryString;
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirectHandlerServlet.handleRequest():localServerId=" + localServerId + ":handlerHostId=" + handlerHostId + ":forwarding request to " + forwardToUrl);
                }
                this.forwardRequest(forwardToUrl, httpRequest, httpResponse);
                return;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.handleRequest():no need to forward, processing request in the local server");
        }
        String requestURL = this.getRequestURL(httpRequest);
        String messageID = httpRequest.getParameter("TransID");
        String returnToURL = httpRequest.getParameter("ReturnToURL");
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.handleRequest():entering with requestURL=" + requestURL + ":messageID=" + messageID + ":returnToURL=" + returnToURL);
        }
        if (messageID != null) {
            if (returnToURL != null) {
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirecthandlerServlet.handleRequest(): entering with returnToRL=" + returnToURL + " :a new request");
                }
                if (returnToURL.indexOf("ResendMessage=") != -1) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest():invalid Request - illegal parameter:ResendMessage:returnToURL=" + returnToURL);
                    this.showErrorPage(httpRequest, httpResponse, "Invalid Request - illegal parameter:ResendMessage:returnToURL=" + returnToURL);
                    return;
                }
                if (InteractionConfig.getInstance().wspEnforcesHttpsCheck() && returnToURL.indexOf("https") != 0) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest():Invalid Request ReturnToURL not https:returnToURL=" + returnToURL);
                    this.showErrorPage(httpRequest, httpResponse, "Invalid Request ReturnToURL not https:returnToURL=" + returnToURL);
                    return;
                }
                if (InteractionConfig.getInstance().wspEnforcesReturnToHostEqualsRequestHost() && !this.checkReturnToHost(messageID, returnToURL)) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest():Invalid Request ReturnToHost differs from  RequestHost:returnToURL=" + returnToURL + ":requestHost=" + InteractionManager.getInstance().getRequestHost(messageID));
                    this.showErrorPage(httpRequest, httpResponse, "Invalid Request ReturnToHost differs from  RequestHost:returnToURL=" + returnToURL + ":requestHost=" + InteractionManager.getInstance().getRequestHost(messageID));
                    return;
                }
                InteractionManager.getInstance().setReturnToURL(messageID, returnToURL);
                this.sendInteractionRequestPage(messageID, httpRequest, httpResponse);
            } else {
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirecthandlerServlet.handleRequest(): entering without retunrnToRL: response for query");
                }
                if ((returnToURL = InteractionManager.getInstance().getReturnToURL(messageID)) == null) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest(): returnToURL, cacheEntry  not found to redirect, for TransactionID : " + messageID);
                    this.showErrorPage(httpRequest, httpResponse, " returnToURL not found in cache");
                } else {
                    this.sendInteractionResponsePage(messageID, httpRequest, httpResponse, returnToURL);
                }
            }
        } else {
            debug.error("WSPRedirecthandlerServlet.handleRequest():request without messageID:requestURL=" + requestURL);
            this.showErrorPage(httpRequest, httpResponse, "Invalid Request - missing messageID:requestURL=" + requestURL);
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirecthandlerServlet.handleRequest():returning");
        }
    }

    private void sendInteractionRequestPage(String messageID, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        InquiryElement inquiryElement = InteractionManager.getInstance().getInquiryElement(messageID);
        String wspRedirectHandler = InteractionConfig.getInstance().getWSPRedirectHandler();
        String lbWspRedirectHandler = InteractionConfig.getInstance().getLbWSPRedirectHandler();
        String action = null;
        if (lbWspRedirectHandler == null) {
            action = httpRequest.getRequestURL().toString() + "?" + "TransID" + "=" + messageID;
        } else {
            String localServerId = InteractionConfig.getInstance().getLocalServerId();
            action = lbWspRedirectHandler + "?" + "TransID" + "=" + messageID + "&" + "HandlerHostId" + "=" + localServerId;
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.sendInteractionRequestPage():action=" + action);
        }
        DOMSource styleSource = null;
        boolean wmlClient = this.isWMLClient(httpRequest);
        PrintWriter out = null;
        if (!wmlClient) {
            if (debug.messageEnabled()) {
                debug.message("WSPRedirectHandlerServlet.sendInteractionRequestPage():clientType=html");
            }
            styleSource = this.htmlStyleSource;
            httpResponse.setContentType("text/html");
            out = httpResponse.getWriter();
        } else {
            if (debug.messageEnabled()) {
                debug.message("WSPRedirectHandlerServlet.sendInteractionRequestPage():clientType=wml");
            }
            styleSource = this.wmlStyleSource;
            httpResponse.setContentType("text/vnd.wap.wml");
            out = httpResponse.getWriter();
            out.println("<?xml version=\"1.0\"?>");
            out.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\"");
            out.println("    \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.sun.identity.liberty.ws.interaction.jaxb");
            Marshaller marshaller = jaxbContext.createMarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            marshaller.marshal((Object)inquiryElement, (Node)doc);
            doc.getDocumentElement().setAttribute("action", action);
            String trueLabel = DEFAULT_TRUE_LABEL;
            String falseLabel = DEFAULT_FALSE_LABEL;
            String helpLabel = DEFAULT_HELP_LABEL;
            String hintLabel = DEFAULT_HINT_LABEL;
            String linkLabel = DEFAULT_LINK_LABEL;
            String moreLinkLabel = DEFAULT_MORE_LINK_LABEL;
            String language = InteractionManager.getInstance().getLanguage(messageID);
            if (language == null) {
                trueLabel = i18n.getString(TRUE_LABEL);
                falseLabel = i18n.getString(FALSE_LABEL);
                helpLabel = i18n.getString(HELP_LABEL);
                hintLabel = i18n.getString(HINT_LABEL);
                linkLabel = i18n.getString(LINK_LABEL);
                moreLinkLabel = i18n.getString(MORE_LINK_LABEL);
            } else {
                Locale locale = new Locale(language);
                ResourceBundle bundle = ResourceBundle.getBundle("libInteraction", locale);
                trueLabel = bundle.getString(TRUE_LABEL);
                falseLabel = bundle.getString(FALSE_LABEL);
                helpLabel = bundle.getString(HELP_LABEL);
                hintLabel = bundle.getString(HINT_LABEL);
                linkLabel = bundle.getString(LINK_LABEL);
                moreLinkLabel = bundle.getString(MORE_LINK_LABEL);
            }
            Element documentElement = doc.getDocumentElement();
            documentElement.setAttribute(TRUE_LABEL, trueLabel);
            documentElement.setAttribute(FALSE_LABEL, falseLabel);
            documentElement.setAttribute(HELP_LABEL, helpLabel);
            documentElement.setAttribute(HINT_LABEL, hintLabel);
            documentElement.setAttribute(LINK_LABEL, linkLabel);
            documentElement.setAttribute(MORE_LINK_LABEL, moreLinkLabel);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMSource domSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(out);
            Transformer transformer = transformerFactory.newTransformer(styleSource);
            transformer.transform(domSource, streamResult);
            if (LogUtil.isLogEnabled()) {
                String[] objs = new String[]{messageID};
                LogUtil.access(Level.INFO, "IS_Presented_Query_To_User_Agent", objs);
            }
        }
        catch (JAXBException je) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionRequestPage():catching JAXBException =", je);
            this.showErrorPage(httpRequest, httpResponse, "Error creating JAXBObject:" + je.getMessage());
        }
        catch (ParserConfigurationException pce) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionRequestPage():catching ParserConfigurationException =", pce);
            this.showErrorPage(httpRequest, httpResponse, "Error creating interaction request page:" + pce.getMessage());
        }
        catch (TransformerException tce) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionRequestPage():catching TransformerException =", tce);
            this.showErrorPage(httpRequest, httpResponse, "Error creating interaction request page:" + tce.getMessage());
        }
    }

    private void sendInteractionResponsePage(String messageID, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String returnToURL) throws IOException {
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.sendInteractionResponsePage():entering");
        }
        try {
            String[] objs;
            InteractionResponseElement interactionResponseElement = JAXBObjectFactory.getObjectFactory().createInteractionResponseElement();
            List list = interactionResponseElement.getParameter();
            Enumeration parameterNames = httpRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                int index;
                String parameterName = (String)parameterNames.nextElement();
                String parameterValue = httpRequest.getParameter(parameterName);
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirectHandlerServlet.sendInteractionResponsePage():parameterName=" + parameterName + ", parameterValue=" + parameterValue);
                }
                if ((index = parameterName.indexOf(PARAMETER_PREFIX)) == -1) continue;
                ParameterType parameterType = JAXBObjectFactory.getObjectFactory().createParameterType();
                parameterName = parameterName.substring(index + PARAMETER_PREFIX.length());
                parameterType.setName(parameterName);
                parameterType.setValue(parameterValue);
                list.add(parameterType);
            }
            if (LogUtil.isLogEnabled()) {
                objs = new String[]{messageID};
                LogUtil.access(Level.INFO, "IS_Collected_Response_From_User_Agent", objs);
            }
            InteractionManager.getInstance().setInteractionResponseElement(messageID, interactionResponseElement);
            returnToURL = returnToURL.indexOf("?") != -1 ? returnToURL + "&" + "ResendMessage" + "=" + InteractionManager.getInstance().getRequestMessageID(messageID) : returnToURL + "?" + "ResendMessage" + "=" + messageID;
            if (debug.messageEnabled()) {
                debug.message("WSPRedirectHandlerServlet. sendInteractionResponsePage():redirecting user agent to returnToURL=" + returnToURL);
            }
            httpResponse.sendRedirect(returnToURL);
            if (LogUtil.isLogEnabled()) {
                objs = new String[]{messageID};
                LogUtil.access(Level.INFO, "IS_Redirected_User_Agent_Back", objs);
            }
        }
        catch (JAXBException je) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionResponsePage():catching JAXBException =", je);
            this.showErrorPage(httpRequest, httpResponse, "Error createing JAXBObject:" + je.getMessage());
        }
        catch (Exception e) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionResponsePage():catching Exception =", e);
        }
    }

    private String getRequestURL(HttpServletRequest httpRequest) {
        return httpRequest.getRequestURL().append("?").append(httpRequest.getQueryString()).toString();
    }

    private void showErrorPage(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String message) throws IOException {
        boolean wmlClient = this.isWMLClient(httpRequest);
        if (!wmlClient) {
            httpResponse.setContentType("text/plain");
            PrintWriter out = httpResponse.getWriter();
            out.println("<html>");
            out.println("<head><title>WSPRedirectHandler</title></head>");
            out.println("<body>");
            out.println("WSPRedirectHandler - Interaction Error");
            out.println(message);
            out.println("</body>");
            out.println("</html>");
        } else {
            httpResponse.setContentType("text/vnd.wap.wml");
            PrintWriter out = httpResponse.getWriter();
            out.println("<wml>");
            out.println("<card>");
            out.println("<p>");
            out.println("WSPRediretHandler - encountered error");
            out.println("</p>");
            out.println("</card>");
            out.println("</wml>");
        }
    }

    private boolean checkReturnToHost(String messageID, String returnToURL) {
        String returnToHost;
        boolean answer = false;
        String requestHost = InteractionManager.getInstance().getRequestHost(messageID);
        URL url = null;
        if (requestHost != null) {
            try {
                url = new URL(returnToURL);
                returnToHost = url.getHost();
                if (requestHost.equals(returnToHost)) {
                    answer = true;
                }
            }
            catch (MalformedURLException mfe) {
                debug.error("WSPRedirecthandlerServlet.handleRequest():malformed ReturnToURL=" + returnToURL);
            }
        }
        returnToHost = null;
        if (url != null) {
            returnToHost = url.getHost();
            answer = requestHost.equalsIgnoreCase(returnToHost);
        }
        if (!answer && returnToHost.indexOf(requestHost + ".") == 0) {
            answer = true;
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.checkReturnToHost(): returning: :requestHost=" + requestHost + ":returnToHost=" + returnToHost + ":returnValue=" + answer);
        }
        return answer;
    }

    private boolean isWMLClient(HttpServletRequest httpRequest) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardRequest(String forwardToUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.forwardRequest():forwardToUrl:" + forwardToUrl);
        }
        InputStream clientIn = null;
        OutputStream serverOut = null;
        InputStream serverIn = null;
        OutputStream clientOut = null;
        try {
            URL url = new URL(forwardToUrl);
            HttpURLConnection urlConnection = HttpURLConnectionManager.getConnection(url);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(CONNECT_TIMEOUT);
            urlConnection.setReadTimeout(READ_TIMEOUT);
            urlConnection.setInstanceFollowRedirects(false);
            Enumeration enumer = request.getHeaderNames();
            while (enumer.hasMoreElements()) {
                String name = (String)enumer.nextElement();
                String value = request.getHeader(name);
                urlConnection.addRequestProperty(name, value);
            }
            urlConnection.connect();
            clientIn = new BufferedInputStream((InputStream)request.getInputStream());
            serverOut = new BufferedOutputStream(urlConnection.getOutputStream());
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = clientIn.read(buffer)) != -1) {
                serverOut.write(buffer, 0, len);
            }
            serverOut.flush();
            String statusLine = urlConnection.getHeaderField(null);
            if (statusLine != null) {
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirectHandlerServlet.forwardRequest(): status line:" + statusLine);
                }
                int i = statusLine.indexOf(" ");
                int j = -1;
                if (i != -1) {
                    j = statusLine.indexOf(" ", i + 1);
                }
                if (i != -1 && j != -1) {
                    String status = statusLine.substring(i + 1, j);
                    response.setStatus(Integer.valueOf(status).intValue());
                }
            }
            Map<String, List<String>> headersMap = urlConnection.getHeaderFields();
            Set<String> keySet = headersMap.keySet();
            Iterator<String> iter = keySet.iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                String value = urlConnection.getHeaderField(name);
                if (name == null || value == null) continue;
                response.addHeader(name, value);
            }
            serverIn = new BufferedInputStream(urlConnection.getInputStream());
            clientOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            while ((len = serverIn.read(buffer)) != -1) {
                clientOut.write(buffer, 0, len);
            }
        }
        finally {
            block21: {
                try {
                    if (clientIn != null) {
                        clientIn.close();
                    }
                    if (serverIn != null) {
                        serverIn.close();
                    }
                    if (clientOut != null) {
                        clientOut.close();
                    }
                    if (serverOut != null) {
                        serverOut.close();
                    }
                }
                catch (Exception e) {
                    if (!debug.warningEnabled()) break block21;
                    debug.warning("WSPRedirectHandlerServlet.forwardRequest()exception in finally block:", e);
                }
            }
        }
    }

    private void sendErrorPageUntrustedHost(HttpServletRequest request, HttpServletResponse response, String handlerHostUrl) throws IOException {
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.sendErrorPageUntrustedHost()");
        }
        response.setStatus(403);
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Denied attempt to forward to untrusted server</title>");
        out.println("<body>");
        out.println("<h1>" + i18n.getString("denied_attemtpt_to_forward_to_untrusted_server") + "</h1>");
        out.println("</body>\n");
        out.println("</html>\n");
    }
}

