/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.dst.DSTData;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.shared.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTQueryResponse {
    private Status dstStatus = null;
    private String itemIDRef = null;
    private String id = null;
    private Date dateStamp = null;
    private List data = new ArrayList();
    private List extensions = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTQueryResponse() {
    }

    public DSTQueryResponse(List data, String serviceNS) {
        if (data != null) {
            this.data = data;
        }
        this.nameSpaceURI = serviceNS;
    }

    public DSTQueryResponse(Element element) throws DSTException {
        NodeList list;
        if (element == null) {
            DSTUtils.debug.error("DSTQueryResponse(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String elementName = element.getLocalName();
        if (elementName == null || !elementName.equals("QueryResponse")) {
            DSTUtils.debug.error("DSTQueryResponse(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryResponse(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemIDRef = element.getAttribute("itemIDRef");
        String attrib = element.getAttribute("timeStamp");
        if (attrib != null && attrib.length() != 0) {
            try {
                this.dateStamp = DateUtils.stringToDate(attrib);
            }
            catch (ParseException ex) {
                DSTUtils.debug.error("DSTQueryResponse(element): can not parse the date", ex);
            }
        }
        if ((list = element.getChildNodes()) == null || list.getLength() == 0) {
            DSTUtils.debug.error("DSTQueryResponse(element): Response doesnot have child elements.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getLocalName();
            if (nodeName != null && nodeName.equals("Status")) {
                this.dstStatus = DSTUtils.parseStatus((Element)node);
                continue;
            }
            if (nodeName != null && nodeName.equals("Data")) {
                this.data.add(new DSTData((Element)node));
                continue;
            }
            DSTUtils.debug.error("DSTQueryResponse(element): Response does have invalid elements.");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        if (this.dstStatus == null) {
            DSTUtils.debug.error("DSTQueryResponse(element): Response doesnot have Status element.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
    }

    public Status getStatus() {
        return this.dstStatus;
    }

    public void setStatus(Status status) {
        this.dstStatus = status;
    }

    public Date getTimeStamp() {
        return this.dateStamp;
    }

    public void setTimeStamp(Date date) {
        this.dateStamp = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getItemIDRef() {
        return this.itemIDRef;
    }

    public void setItemIDRef(String ref) {
        this.itemIDRef = ref;
    }

    public List getData() {
        return this.data;
    }

    public List getExtension() {
        return this.extensions;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpace) {
        this.nameSpaceURI = nameSpace;
    }

    public void setNameSpacePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        if (this.dstStatus == null) {
            DSTUtils.debug.error("DSTQueryResponse.toString: Status is null");
            return "";
        }
        String tempPrefix = "";
        if (includeNS) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            tempPrefix = this.prefix + ":";
        }
        if (declareNS && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryResponse.toString: Name Space is not defined");
            return "";
        }
        StringBuffer sb = new StringBuffer(500);
        sb.append("<").append(tempPrefix).append("QueryResponse");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemIDRef != null && this.itemIDRef.length() != 0) {
            sb.append(" itemIDRef=\"").append(this.itemIDRef).append("\"");
        }
        if (this.dateStamp != null) {
            sb.append(" timeStamp=\"").append(DateUtils.toUTCDateFormat(this.dateStamp)).append("\"");
        }
        if (declareNS) {
            sb.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        sb.append(">").append("\n").append(this.dstStatus.toString());
        Iterator iter = this.data.iterator();
        while (iter.hasNext()) {
            DSTData dstData = (DSTData)iter.next();
            sb.append(dstData.toString());
        }
        sb.append("</").append(tempPrefix).append("QueryResponse").append(">");
        return sb.toString();
    }
}

