/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Description {
    private String id = null;
    private List mechID = null;
    private List credentialRef = new ArrayList();
    private String soapEndpoint = null;
    private String soapAction = null;
    private QName serviceNameRef = null;
    private String wsdlURI = null;

    public Description() {
    }

    public Description(List securityMechID, List credentialRef, String endPoint) {
        this.mechID = securityMechID;
        this.credentialRef = credentialRef;
        this.soapEndpoint = endPoint;
    }

    public Description(Element elem) throws DiscoveryException {
        String nameSpaceURI;
        if (elem == null) {
            DiscoUtils.debug.message("Description(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = elem.getLocalName();
        if (nodeName == null || !nodeName.equals("Description") || (nameSpaceURI = elem.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("Description(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = elem.getAttribute("id");
        NodeList contentnl = elem.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("Description(Element): invalid namespace for node " + nodeName);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            if (nodeName.equals("SecurityMechID")) {
                String mID = XMLUtils.getElementValue((Element)child);
                if (mID == null || mID.length() == 0) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Description(Element): missing SecurityMechID value.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
                }
                if (this.mechID == null) {
                    this.mechID = new ArrayList();
                }
                this.mechID.add(mID);
                continue;
            }
            if (nodeName.equals("CredentialRef")) {
                String ref = XMLUtils.getElementValue((Element)child);
                if (ref == null || ref.length() == 0) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Description(Element): missing CredentialRef value.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
                }
                if (this.credentialRef == null) {
                    this.credentialRef = new ArrayList();
                }
                this.credentialRef.add(ref);
                continue;
            }
            if (nodeName.equals("Endpoint")) {
                this.parseEndpoint((Element)child);
                continue;
            }
            if (nodeName.equals("SoapAction")) {
                this.parseSoapAction((Element)child);
                continue;
            }
            if (nodeName.equals("WsdlURI")) {
                this.parseWsdlURI((Element)child);
                continue;
            }
            if (nodeName.equals("ServiceNameRef")) {
                this.parseServiceNameRef((Element)child);
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.mechID == null || this.mechID.size() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): missing SecurityMechID element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingSecurityMechID"));
        }
        if (this.soapEndpoint == null && this.wsdlURI == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): missing WsdlRef or BriefSoapHttpDescription.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingWsdlOrBrief"));
        }
    }

    private void parseEndpoint(Element child) throws DiscoveryException {
        if (this.soapEndpoint != null || this.wsdlURI != null || this.serviceNameRef != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more Endpoint.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        this.soapEndpoint = XMLUtils.getElementValue(child);
        if (this.soapEndpoint == null || this.soapEndpoint.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing Endpoint value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
    }

    private void parseSoapAction(Element child) throws DiscoveryException {
        if (this.soapAction != null || this.wsdlURI != null || this.serviceNameRef != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more SoapAction.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        this.soapAction = XMLUtils.getElementValue(child);
        if (this.soapAction == null || this.soapAction.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing SoapAction value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
    }

    private void parseWsdlURI(Element child) throws DiscoveryException {
        if (this.soapEndpoint != null || this.wsdlURI != null || this.soapAction != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more WsdlURI.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        this.wsdlURI = XMLUtils.getElementValue(child);
        if (this.wsdlURI == null || this.wsdlURI.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing WsdlURI value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
    }

    private void parseServiceNameRef(Element child) throws DiscoveryException {
        String namespaceURI;
        if (this.soapEndpoint != null || this.serviceNameRef != null || this.soapAction != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more WsdlURI.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        String eleValue = XMLUtils.getElementValue(child);
        if (eleValue == null || eleValue.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing ServiceNameRef value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
        String localPart = eleValue;
        String prefix = null;
        String attrName = "xmlns";
        if (eleValue.indexOf(":") != -1) {
            StringTokenizer st = new StringTokenizer(localPart, ":");
            if (st.countTokens() != 2) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("Description(Element): wrong ServiceNameRef value.");
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            prefix = st.nextToken();
            attrName = attrName + ":" + prefix;
            localPart = st.nextToken();
        }
        this.serviceNameRef = (namespaceURI = child.getAttribute(attrName)) != null && namespaceURI.length() != 0 ? (prefix != null && prefix.length() != 0 ? new QName(namespaceURI, localPart, prefix) : new QName(namespaceURI, localPart)) : new QName(localPart);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String value) {
        this.soapAction = value;
    }

    public List getSecurityMechID() {
        return this.mechID;
    }

    public void getSecurityMechID(List mechIDs) {
        this.mechID = mechIDs;
    }

    public QName getServiceNameRef() {
        return this.serviceNameRef;
    }

    public void setServiceNameRef(QName nameRef) {
        this.serviceNameRef = nameRef;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String uri) {
        this.wsdlURI = uri;
    }

    public List getCredentialRef() {
        return this.credentialRef;
    }

    public void setCredentialRef(List refs) {
        this.credentialRef = refs;
    }

    public String getEndpoint() {
        return this.soapEndpoint;
    }

    public void setEndpoint(String uri) {
        this.soapEndpoint = uri;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<Description xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.mechID != null) {
            Iterator iter = this.mechID.iterator();
            while (iter.hasNext()) {
                sb.append("<SecurityMechID>").append((String)iter.next()).append("</SecurityMechID>");
            }
        }
        if (this.credentialRef != null) {
            Iterator iter2 = this.credentialRef.iterator();
            while (iter2.hasNext()) {
                sb.append("<CredentialRef>").append((String)iter2.next()).append("</CredentialRef>");
            }
        }
        if (this.soapEndpoint != null) {
            sb.append("<Endpoint>").append(this.soapEndpoint).append("</Endpoint>");
            if (this.soapAction != null) {
                sb.append("<SoapAction>").append(this.soapAction).append("</SoapAction>");
            }
        } else {
            sb.append("<WsdlURI>").append(this.wsdlURI).append("</WsdlURI>");
            sb.append("<ServiceNameRef");
            String prefix = null;
            String namespace = this.serviceNameRef.getNamespaceURI();
            if (namespace != null && namespace.length() != 0) {
                sb.append(" xmlns:");
                prefix = this.serviceNameRef.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = "ns1";
                }
                sb.append(prefix).append("=\"").append(namespace).append("\"");
            }
            sb.append(">");
            if (prefix != null) {
                sb.append(prefix).append(":");
            }
            sb.append(this.serviceNameRef.getLocalPart()).append("</ServiceNameRef>");
        }
        sb.append("</Description>");
        return sb.toString();
    }
}

