/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.remote;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DNUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdCachedServices;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.common.IdCacheBlock;
import com.sun.identity.idm.remote.IdRemoteServicesImpl;
import com.sun.identity.sm.ServiceManager;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;

public class IdRemoteCachedServicesImpl
extends IdRemoteServicesImpl
implements IdCachedServices {
    static final String CACHE_MAX_SIZE_KEY = "com.iplanet.am.sdk.cache.maxSize";
    static final String CACHE_MAX_SIZE = "10000";
    static final int CACHE_MAX_SIZE_INT = 10000;
    private static int maxSize;
    private static IdServices instance;
    private Cache idRepoCache;

    private static void initializeParams() {
        String cacheSize = SystemProperties.get(CACHE_MAX_SIZE_KEY, CACHE_MAX_SIZE);
        try {
            maxSize = Integer.parseInt(cacheSize);
            if (maxSize < 1) {
                maxSize = 10000;
            }
            if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
                IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.intializeParams() Caching size set to: " + maxSize);
            }
        }
        catch (NumberFormatException ne) {
            maxSize = 10000;
            IdRemoteCachedServicesImpl.getDebug().warning("IdRemoteCachedServicesImpl.initializeParams() - invalid value for cache size specified. Setting to default value: " + maxSize);
        }
    }

    private IdRemoteCachedServicesImpl() {
        this.initializeCache();
    }

    private void initializeCache() {
        this.idRepoCache = new Cache(maxSize);
    }

    public int getSize() {
        return this.idRepoCache.size();
    }

    protected static synchronized IdServices getInstance() {
        if (instance == null) {
            IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.getInstance(): Creating new Instance of IdRemoteCachedServicesImpl()");
            instance = new IdRemoteCachedServicesImpl();
        }
        return instance;
    }

    protected static int getMaxSize() {
        return maxSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n<<<<<<< BEGIN SDK CACHE CONTENTS >>>>>>>>");
        if (!this.idRepoCache.isEmpty()) {
            Enumeration cacheKeys = this.idRepoCache.keys();
            while (cacheKeys.hasMoreElements()) {
                String key = (String)cacheKeys.nextElement();
                IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.get(key);
                sb.append("\nSDK Cache Block: ").append(key);
                sb.append(cb.toString());
            }
        } else {
            sb.append("<empty>");
        }
        sb.append("\n<<<<<<< END SDK CACHE CONTENTS >>>>>>>>");
        return sb.toString();
    }

    private void removeCachedAttributes(String affectDNs, Set attrNames) {
        Enumeration cacheKeys = this.idRepoCache.keys();
        while (cacheKeys.hasMoreElements()) {
            IdCacheBlock cb;
            int l2;
            int l1;
            String key = (String)cacheKeys.nextElement();
            if (!key.regionMatches(true, (l1 = key.length()) - (l2 = affectDNs.length()), affectDNs, 0, l2) || (cb = (IdCacheBlock)this.idRepoCache.get(key)) == null) continue;
            if (attrNames != null && !cb.hasExpiredAndUpdated() && cb.isExists()) {
                cb.removeAttributes(attrNames);
                continue;
            }
            cb.clear();
        }
    }

    private void clearCachedEntries(String affectDNs) {
        this.removeCachedAttributes(affectDNs, null);
    }

    public synchronized void clearCache() {
        this.idRepoCache.clear();
        this.initializeCache();
    }

    public void dirtyCache(String dn, int eventType, boolean cosType, boolean aciChange, Set attrNames) {
        String originalDN = dn;
        dn = DNUtils.normalizeDN(dn);
        String cachedID = this.getCacheId(dn);
        switch (eventType) {
            case 1: {
                IdCacheBlock cb = this.getFromCache(dn);
                if (cb != null) {
                    cb.setExists(true);
                }
                if (!cosType) break;
                this.removeCachedAttributes(cachedID, attrNames);
                break;
            }
            case 2: {
                IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.remove(cachedID);
                if (cb != null) {
                    cb.clear();
                }
                if (!cosType) break;
                this.removeCachedAttributes(cachedID, attrNames);
                break;
            }
            case 8: {
                IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.remove(cachedID);
                if (cb != null) {
                    cb.clear();
                }
                if (!cosType) break;
                this.removeCachedAttributes(cachedID, attrNames);
                break;
            }
            case 4: {
                IdCacheBlock cb = this.getFromCache(dn);
                if (cb != null) {
                    cb.clear();
                }
                if (cosType) {
                    this.removeCachedAttributes(cachedID, attrNames);
                    break;
                }
                if (!aciChange) break;
                this.clearCachedEntries(cachedID);
            }
        }
        if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
            IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.dirtyCache(): Cache dirtied because of Event Notification. Parameters - eventType: " + eventType + ", cosType: " + cosType + ", aciChange: " + aciChange + ", fullDN: " + originalDN + "; rfcDN =" + dn + "; cachedID=" + cachedID);
        }
    }

    private void updateCache(SSOToken token, String dn, Map stringAttributes, Map byteAttributes) throws IdRepoException, SSOException {
        String key = dn;
        IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.get(key);
        if (cb != null && !cb.hasExpiredAndUpdated() && cb.isExists()) {
            AMIdentity tokenId = IdUtils.getIdentity(token);
            String pDN = tokenId.getUniversalId();
            cb.replaceAttributes(pDN, stringAttributes, byteAttributes);
        }
    }

    private void dirtyCache(String dn) {
        String key = DNUtils.normalizeDN(dn);
        IdCacheBlock cb = this.getFromCache(key);
        if (cb != null) {
            cb.clear();
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames, String amOrgName, String amsdkDN, boolean isStringValues) throws IdRepoException, SSOException {
        AMHashMap attributes;
        IdCacheBlock cb;
        if (attrNames == null || attrNames.isEmpty()) {
            return this.getAttributes(token, type, name, amOrgName, amsdkDN);
        }
        AMIdentity id = new AMIdentity(token, name, type, amOrgName, amsdkDN);
        String dn = id.getUniversalId().toLowerCase();
        AMIdentity tokenId = IdUtils.getIdentity(token);
        String principalDN = tokenId.getUniversalId();
        if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
            IdRemoteCachedServicesImpl.getDebug().message("In IdRemoteCachedServicesImpl.getAttributes(SSOToken type, name, attrNames, amOrgName, amsdkDN) (" + principalDN + ", " + dn + ", " + attrNames + " ," + amOrgName + " , " + amsdkDN + " method.");
        }
        if ((cb = (IdCacheBlock)this.idRepoCache.get(dn)) == null) {
            if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
                IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.getAttributes(): NO entry found in Cachefor key = " + dn + ". Getting all these attributes from DS: " + attrNames);
            }
            attributes = (AMHashMap)super.getAttributes(token, type, name, attrNames, amOrgName, amsdkDN, isStringValues);
            Set missAttrNames = attributes.getMissingAndEmptyKeys(attrNames);
            cb = new IdCacheBlock(dn, true);
            cb.putAttributes(principalDN, attributes, missAttrNames, false, !isStringValues);
            this.idRepoCache.put(dn, cb);
        } else {
            attributes = (AMHashMap)cb.getAttributes(principalDN, attrNames, !isStringValues);
            Set missAttrNames = attributes.getMissingAndEmptyKeys(attrNames);
            if (!missAttrNames.isEmpty()) {
                if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
                    IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.getAttributes(): Trying to gett these missing attributes from DS: " + missAttrNames);
                }
                AMHashMap dsAttributes = (AMHashMap)super.getAttributes(token, type, name, attrNames, amOrgName, amsdkDN, isStringValues);
                attributes.putAll(dsAttributes);
                Set newMissAttrNames = dsAttributes.getMissingAndEmptyKeys(missAttrNames);
                cb.putAttributes(principalDN, dsAttributes, newMissAttrNames, false, !isStringValues);
            } else if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
                IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.getAttributes(): found all attributes in Cache.");
            }
        }
        return attributes;
    }

    public Map getAttributes(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        AMHashMap attributes;
        AMIdentity id = new AMIdentity(token, name, type, amOrgName, amsdkDN);
        String dn = id.getUniversalId().toLowerCase();
        AMIdentity tokenId = IdUtils.getIdentity(token);
        String principalDN = tokenId.getUniversalId();
        IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.get(dn);
        if (cb != null && cb.hasCompleteSet(principalDN)) {
            if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
                IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.getAttributes(): found all attributes in Cache.");
            }
            attributes = (AMHashMap)cb.getAttributes(principalDN, false);
        } else {
            if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
                IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.getAttributes(): complete attribute set NOT found in cache. Getting from DS.");
            }
            attributes = (AMHashMap)super.getAttributes(token, type, name, amOrgName, amsdkDN);
            if (cb == null) {
                cb = new IdCacheBlock(dn, true);
                this.idRepoCache.put(dn, cb);
            }
            cb.putAttributes(principalDN, attributes, null, true, false);
            if (IdRemoteCachedServicesImpl.getDebug().messageEnabled()) {
                IdRemoteCachedServicesImpl.getDebug().message("IdRemoteCachedServicesImpl.getAttributes(): attributes NOT found in cache. Fetched from DS.");
            }
        }
        return attributes;
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN, boolean active) throws SSOException, IdRepoException {
        super.setActiveStatus(token, type, name, amOrgName, amsdkDN, active);
        AMIdentity id = new AMIdentity(token, name, type, amOrgName, amsdkDN);
        String dn = IdUtils.getUniversalId(id).toLowerCase();
        this.dirtyCache(dn);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        super.setAttributes(token, type, name, attributes, isAdd, amOrgName, amsdkDN, isString);
        AMIdentity id = new AMIdentity(token, name, type, amOrgName, amsdkDN);
        String dn = id.getUniversalId();
        if (type.equals(IdType.USER)) {
            if (isString) {
                this.updateCache(token, dn, attributes, null);
            } else {
                this.updateCache(token, dn, null, attributes);
            }
        } else {
            this.dirtyCache(dn);
        }
    }

    public void delete(SSOToken token, IdType type, String name, String orgName, String amsdkDN) throws IdRepoException, SSOException {
        super.delete(token, type, name, orgName, amsdkDN);
        AMIdentity id = new AMIdentity(token, name, type, orgName, amsdkDN);
        String dn = id.getUniversalId().toLowerCase();
        this.idRepoCache.remove(dn);
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames, String orgName, String amsdkDN) throws IdRepoException, SSOException {
        super.removeAttributes(token, type, name, attrNames, orgName, amsdkDN);
        AMIdentity id = new AMIdentity(token, name, type, orgName, amsdkDN);
        String dn = id.getUniversalId();
        IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.get(dn);
        if (cb != null && !cb.hasExpiredAndUpdated() && cb.isExists()) {
            cb.removeAttributes(attrNames);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IdSearchResults search(SSOToken token, IdType type, String pattern, IdSearchControl ctrl, String orgName) throws IdRepoException, SSOException {
        IdSearchResults answer = new IdSearchResults(type, orgName);
        if (pattern.indexOf(42) != -1) return super.search(token, type, pattern, ctrl, orgName);
        if (!ServiceManager.isRealmEnabled()) return super.search(token, type, pattern, ctrl, orgName);
        AMIdentity uvid = new AMIdentity(token, pattern, type, orgName, null);
        String universalID = uvid.getUniversalId().toLowerCase();
        IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.get(universalID);
        if (cb == null) return super.search(token, type, pattern, ctrl, orgName);
        if (cb.hasExpiredAndUpdated()) return super.search(token, type, pattern, ctrl, orgName);
        if (!cb.isExists()) return super.search(token, type, pattern, ctrl, orgName);
        if (ctrl.getSearchModifierMap() != null) return super.search(token, type, pattern, ctrl, orgName);
        try {
            Map attributes;
            if (ctrl.isGetAllReturnAttributesEnabled()) {
                attributes = this.getAttributes(token, type, pattern, orgName, null);
            } else {
                Set attrNames = ctrl.getReturnAttributes();
                attributes = this.getAttributes(token, type, pattern, attrNames, orgName, null, true);
            }
            AMIdentity id = new AMIdentity(token, pattern, type, orgName, null);
            answer.addResult(id, attributes);
            return answer;
        }
        catch (IdRepoException ide) {
            if (ide.getErrorCode().equals("220")) return answer;
            throw ide;
        }
    }

    public Set getFullyQualifiedNames(SSOToken token, IdType type, String name, String orgName) throws IdRepoException, SSOException {
        AMIdentity id = new AMIdentity(token, name, type, orgName, null);
        String dn = id.getUniversalId().toLowerCase();
        Set answer = null;
        IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.get(dn);
        if (cb != null) {
            answer = cb.getFullyQualifiedNames();
        }
        if (answer == null) {
            answer = super.getFullyQualifiedNames(token, type, name, orgName);
            if (cb != null) {
                cb.setFullyQualifiedNames(answer);
            }
        }
        return answer;
    }

    private IdCacheBlock getFromCache(String dn) {
        int ind;
        IdCacheBlock cb = (IdCacheBlock)this.idRepoCache.get(dn);
        if (cb == null && (ind = dn.toLowerCase().indexOf(",amsdkdn=")) > -1) {
            String tmp = dn.substring(0, ind);
            cb = (IdCacheBlock)this.idRepoCache.get(tmp);
        }
        return cb;
    }

    private String getCacheId(String dn) {
        String cachedId = dn;
        int ind = dn.toLowerCase().indexOf(",amsdkdn=");
        if (ind > -1) {
            cachedId = dn.substring(0, ind);
        }
        return cachedId;
    }

    static {
        IdRemoteCachedServicesImpl.initializeParams();
    }
}

