/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.DNUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public final class IdUtils {
    private static Debug debug = AMIdentityRepository.debug;
    private static Map mapSupportedTypes = new CaseInsensitiveHashMap(10);
    public static Set supportedTypes = new HashSet();
    private static Map mapTypesToServiceNames = new CaseInsensitiveHashMap();
    protected static Map typesCanBeMemberOf = new CaseInsensitiveHashMap();
    protected static Map typesCanHaveMembers = new CaseInsensitiveHashMap();
    protected static Map typesCanAddMembers = new CaseInsensitiveHashMap();
    private static Map orgIdentifierToOrgName = new CaseInsensitiveHashMap();
    private static String notificationId;
    private static ServiceConfigManager serviceConfigManager;
    private static String USER_NAMING_ATTR;
    private static String ORG_NAMING_ATTR;
    private static String ROOT_SUFFIX;
    private static String SERVICES_SUFFIX;
    private static Set specialUsers;

    protected static void initialize() {
        block14: {
            String installTime;
            SSOToken adminToken;
            if (ServiceManager.isConfigMigratedTo70()) {
                try {
                    adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    serviceConfigManager = new ServiceConfigManager(adminToken, "sunIdentityRepositoryService", "1.0");
                    ServiceConfig ss = serviceConfigManager.getGlobalConfig(null);
                    Set typeSchemaNames = ss.getSubConfigNames("*", "SupportedIdentities");
                    if (typeSchemaNames == null || typeSchemaNames.isEmpty()) {
                        IdUtils.loadDefaultTypes();
                    }
                    Iterator it = typeSchemaNames.iterator();
                    while (it.hasNext()) {
                        Set memberSet;
                        String typeSchema = (String)it.next();
                        IdType idType = new IdType(typeSchema);
                        supportedTypes.add(idType);
                        mapSupportedTypes.put(idType.getName(), idType);
                        ServiceConfig tsc = ss.getSubConfig(typeSchema);
                        Map attributes = tsc.getAttributes();
                        Set serviceNameSet = (Set)attributes.get("servicename");
                        Set canBeMembersOf = (Set)attributes.get("canBeMemberOf");
                        Set canHaveMembers = (Set)attributes.get("canHaveMembers");
                        Set canAddMembers = (Set)attributes.get("canAddMembers");
                        if (serviceNameSet != null && !serviceNameSet.isEmpty()) {
                            mapTypesToServiceNames.put(typeSchema, (String)serviceNameSet.iterator().next());
                        }
                        if (canBeMembersOf != null && !canBeMembersOf.isEmpty()) {
                            Set memberOfSet = IdUtils.getMemberSet(canBeMembersOf);
                            typesCanBeMemberOf.put(typeSchema, memberOfSet);
                        }
                        if (canHaveMembers != null && !canHaveMembers.isEmpty()) {
                            memberSet = IdUtils.getMemberSet(canHaveMembers);
                            typesCanHaveMembers.put(typeSchema, memberSet);
                        }
                        if (canAddMembers == null || canAddMembers.isEmpty()) continue;
                        memberSet = IdUtils.getMemberSet(canAddMembers);
                        typesCanAddMembers.put(typeSchema, memberSet);
                    }
                }
                catch (SMSException e) {
                    installTime = SystemProperties.get("installTime", "false");
                    if (!installTime.equals("true")) {
                        debug.error("IdUtils.initialize: Loading default types.", e);
                    }
                    IdUtils.loadDefaultTypes();
                }
                catch (SSOException ssoe) {
                    debug.error("dUtils.initialize: Loading default types", ssoe);
                    IdUtils.loadDefaultTypes();
                }
            } else {
                IdUtils.loadDefaultTypes();
            }
            if (notificationId == null) {
                try {
                    adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    OrganizationConfigManager rootOrg = new OrganizationConfigManager(adminToken, "/");
                    notificationId = rootOrg.addListener(new IdUtilsListener());
                }
                catch (SMSException e) {
                    installTime = SystemProperties.get("installTime", "false");
                    if (installTime.equals("true")) break block14;
                    debug.error("IdUtils.initialize: Register notification", e);
                }
            }
        }
    }

    public static AMIdentity getIdentity(SSOToken token) throws IdRepoException, SSOException {
        AMIdentity identity;
        String principal = token.getProperty("sun.am.UniversalIdentifier");
        if (principal == null) {
            principal = token.getPrincipal().getName();
            if (principal == null || !DN.isDN(principal)) {
                Object[] args = new Object[]{principal};
                throw new IdRepoException("amIdRepo", "215", args);
            }
            identity = IdUtils.getIdentity(token, principal);
        } else {
            identity = IdUtils.getIdentity(token, principal);
        }
        return identity;
    }

    public static String getUniversalId(AMIdentity id) {
        return id.getUniversalId();
    }

    public static AMIdentity getIdentity(SSOToken token, String univId) throws IdRepoException {
        return IdUtils.getIdentity(token, univId, null);
    }

    public static AMIdentity getIdentity(SSOToken token, String amsdkdn, String realm) throws IdRepoException {
        block24: {
            if (amsdkdn == null || !DN.isDN(amsdkdn)) {
                Object[] args = new Object[]{amsdkdn};
                throw new IdRepoException("amIdRepo", "215", args);
            }
            if (amsdkdn.toLowerCase().startsWith("id=")) {
                try {
                    return new AMIdentity(token, amsdkdn);
                }
                catch (IdRepoException ide) {
                    if (!debug.messageEnabled()) break block24;
                    debug.message("IdUtils:getIdentity(token, " + amsdkdn + ") got exception: " + ide.getMessage() + "\n\tContinuing with AMSDK DN check");
                }
            }
        }
        IdUtils.initializeSpecialUsers();
        if (specialUsers.contains(DNUtils.normalizeDN(amsdkdn))) {
            return new AMIdentity(token, LDAPDN.explodeDN(amsdkdn, true)[0], IdType.USER, ROOT_SUFFIX, amsdkdn);
        }
        try {
            if (realm != null && !OrgConfigViaAMSDK.isAMSDKConfigured(realm) || !ServiceManager.isAMSDKConfigured()) {
                return null;
            }
        }
        catch (SMSException smse) {
            // empty catch block
        }
        IdUtils.initializeForGetIdentity();
        String name = null;
        IdType type = null;
        try {
            IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
            try {
                if (amsdkdn.startsWith(USER_NAMING_ATTR)) {
                    dsServices.getAttributes(token, amsdkdn, 1);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            int sdkType = dsServices.getObjectType(token, amsdkdn);
            type = IdUtils.getType(AMStoreConnection.getObjectName(sdkType));
            name = "ContainerDefaultTemplateRole";
            if (!type.equals(IdType.REALM)) {
                name = LDAPDN.explodeDN(amsdkdn, true)[0];
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("IdUtils.getIdentity: Unable to resolve AMSDK DN: " + amsdkdn, ame);
            }
            return null;
        }
        catch (SSOException ssoe) {
            if (debug.messageEnabled()) {
                debug.message("IdUtils.getIdentity: Unable to resolve AMSDK DN. Got SSOException", ssoe);
            }
            return null;
        }
        String srealm = ROOT_SUFFIX;
        if (!amsdkdn.equals(ROOT_SUFFIX) && !amsdkdn.equals(SERVICES_SUFFIX)) {
            int index = amsdkdn.indexOf(ORG_NAMING_ATTR);
            if (index == 0) {
                srealm = OrgConfigViaAMSDK.getRealmForAMSDK(amsdkdn, realm);
            } else if (index > 0) {
                srealm = OrgConfigViaAMSDK.getRealmForAMSDK(amsdkdn.substring(index), realm);
            }
            if (debug.messageEnabled()) {
                debug.message("IdUtils.getIdentity:: amsdkdn=" + amsdkdn + " maps to realm=" + srealm);
            }
        } else if (amsdkdn.equals(SERVICES_SUFFIX)) {
            amsdkdn = ROOT_SUFFIX;
        }
        return new AMIdentity(token, name, type, srealm, amsdkdn);
    }

    public static String getServiceName(IdType type) {
        return (String)mapTypesToServiceNames.get(type.getName());
    }

    public static IdType getType(String type) throws IdRepoException {
        if (type.equalsIgnoreCase("managedrole")) {
            type = "role";
        } else if (type.equalsIgnoreCase("organization") || type.equalsIgnoreCase("organizationalunit")) {
            type = "realm";
        }
        IdType returnType = (IdType)mapSupportedTypes.get(type);
        if (returnType == null) {
            Object[] args = new Object[]{type};
            throw new IdRepoException("amIdRepo", "217", args);
        }
        return returnType;
    }

    public static String getDN(AMIdentity id) {
        if (id.getDN() != null) {
            return id.getDN();
        }
        return id.getUniversalId();
    }

    public static String getOrganization(SSOToken token, String orgIdentifier) throws IdRepoException, SSOException {
        String id = null;
        id = (String)orgIdentifierToOrgName.get(orgIdentifier);
        if (id != null) {
            return id;
        }
        if (debug.messageEnabled()) {
            debug.message("IdUtils:getOrganization Input orgname: " + orgIdentifier);
        }
        if (orgIdentifier == null || orgIdentifier.length() == 0 || orgIdentifier.equals("/")) {
            id = DNMapper.orgNameToDN("/");
        } else if (orgIdentifier.startsWith("/")) {
            id = DNMapper.orgNameToDN(orgIdentifier);
        } else if (DN.isDN(orgIdentifier)) {
            id = orgIdentifier;
        } else {
            if (ServiceManager.isCoexistenceMode()) {
                if (debug.messageEnabled()) {
                    debug.message("IdUtils.getOrganization: getting from AMSDK");
                }
                try {
                    AMStoreConnection amsc = new AMStoreConnection(token);
                    id = amsc.getOrganizationDN(orgIdentifier, null);
                }
                catch (AMException ame) {
                    if (debug.messageEnabled()) {
                        debug.message("IdUtils.getOrganization Exception in getting org name from AMSDK", ame);
                    }
                    throw IdUtils.convertAMException(ame);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("IdUtils.getOrganization: getting from SMS realms");
            }
            try {
                ServiceManager sm = new ServiceManager(token);
                OrganizationConfigManager ocm = sm.getOrganizationConfigManager("/");
                Set subOrgNames = ocm.getSubOrganizationNames(orgIdentifier, true);
                if (subOrgNames != null && !subOrgNames.isEmpty()) {
                    int count = subOrgNames.size();
                    if (count == 1) {
                        id = DNMapper.orgNameToDN((String)subOrgNames.iterator().next());
                    } else {
                        Iterator items = subOrgNames.iterator();
                        block4: while (items.hasNext()) {
                            String subRealmName = (String)items.next();
                            StringTokenizer st = new StringTokenizer(subRealmName, "/");
                            while (st.hasMoreTokens()) {
                                if (!st.nextToken().equalsIgnoreCase(orgIdentifier)) continue;
                                id = DNMapper.orgNameToDN(subRealmName);
                                continue block4;
                            }
                        }
                    }
                }
                if (id == null) {
                    HashSet<String> vals = new HashSet<String>();
                    vals.add(orgIdentifier);
                    Set orgAliases = sm.searchOrganizationNames("sunIdentityRepositoryService", "sunOrganizationAliases", vals);
                    if (orgAliases == null || orgAliases.isEmpty()) {
                        if (debug.messageEnabled()) {
                            debug.message("IdUtils.getOrganization Unable to find Org name for: " + orgIdentifier);
                        }
                        Object[] args = new Object[]{orgIdentifier};
                        throw new IdRepoException("amIdRepo", "401", args);
                    }
                    String tmpS = (String)orgAliases.iterator().next();
                    id = DNMapper.orgNameToDN(tmpS);
                }
            }
            catch (SMSException smse) {
                if (debug.messageEnabled()) {
                    debug.message("IdUtils.getOrganization Exception in getting org name from SMS", smse);
                }
                Object[] args = new Object[]{orgIdentifier};
                throw new IdRepoException("amIdRepo", "401", args);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("IdUtils: Returning base DN: " + id);
        }
        orgIdentifierToOrgName.put(orgIdentifier, id);
        return id;
    }

    protected static void clearOrganizationNamesCache() {
        orgIdentifierToOrgName = new CaseInsensitiveHashMap();
        if (debug.messageEnabled()) {
            debug.message("IdUtils.clearOrganizationNamesCache called");
        }
    }

    public static boolean isOrganizationActive(SSOToken token, String org) throws IdRepoException, SSOException {
        boolean isActive = true;
        if (!ServiceManager.isCoexistenceMode()) {
            try {
                OrganizationConfigManager ocm = new OrganizationConfigManager(token, org);
                if (ocm == null) {
                    Object[] args = new Object[]{org};
                    throw new IdRepoException("amIdRepo", "401", args);
                }
                Map attributes = ocm.getAttributes("sunIdentityRepositoryService");
                Set vals = (Set)attributes.get("sunOrganizationStatus");
                if (vals == null || vals.isEmpty()) {
                    isActive = true;
                }
                String stringActive = (String)vals.iterator().next();
                isActive = stringActive.equalsIgnoreCase("Active");
            }
            catch (SMSException smse) {
                Object[] args = new Object[]{org};
                throw new IdRepoException("amIdRepo", "401", args);
            }
        } else {
            try {
                AMStoreConnection amsc = new AMStoreConnection(token);
                AMOrganization orgObj = amsc.getOrganization(org);
                isActive = orgObj.isActivated();
            }
            catch (AMException ame) {
                throw IdUtils.convertAMException(ame);
            }
        }
        return isActive;
    }

    private static AMIdentity getIdentityFromAMSDKDN(SSOToken token, String amsdkdn, String realm) throws AMException, SSOException, IdRepoException {
        IDirectoryServices dsServices;
        block10: {
            dsServices = AMDirectoryAccessFactory.getDirectoryServices();
            try {
                if (USER_NAMING_ATTR == null) {
                    try {
                        USER_NAMING_ATTR = AMStoreConnection.getNamingAttribute(1).toLowerCase() + "=";
                    }
                    catch (AMException ame) {
                        if (debug.warningEnabled()) {
                            debug.warning("IdUtils: unable to get naming attribute for user. Using \"uid\"");
                        }
                        USER_NAMING_ATTR = "uid=";
                    }
                }
                if (amsdkdn.startsWith(USER_NAMING_ATTR)) {
                    dsServices.getAttributes(token, amsdkdn, 1);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block10;
                debug.message("IdUtils.getIdentityFromAMSDKDN Unable to get attributes for dn: " + amsdkdn);
            }
        }
        int sdkType = dsServices.getObjectType(token, amsdkdn);
        IdType type = IdUtils.getType(AMStoreConnection.getObjectName(sdkType));
        String name = "ContainerDefaultTemplateRole";
        if (!type.equals(IdType.REALM)) {
            name = LDAPDN.explodeDN(amsdkdn, true)[0];
        }
        if (ServiceManager.isCoexistenceMode()) {
            realm = dsServices.getOrganizationDN(token, amsdkdn);
        }
        if (debug.messageEnabled()) {
            debug.message("IdUtils.getIdentityFromAMSDK: Name: " + name + " Type: " + type + " Realm: " + realm + " dn: " + amsdkdn);
        }
        return new AMIdentity(token, name, type, realm, amsdkdn);
    }

    private static void initializeForGetIdentity() {
        if (ROOT_SUFFIX == null) {
            ROOT_SUFFIX = SMSEntry.getRootSuffix();
            StringBuffer sb = new StringBuffer(100);
            sb.append("ou=services").append(",").append(ROOT_SUFFIX);
            SERVICES_SUFFIX = DNUtils.normalizeDN(sb.toString());
        }
        if (ORG_NAMING_ATTR == null || USER_NAMING_ATTR == null) {
            try {
                ORG_NAMING_ATTR = AMStoreConnection.getNamingAttribute(2).toLowerCase() + "=";
                USER_NAMING_ATTR = AMStoreConnection.getNamingAttribute(1).toLowerCase() + "=";
            }
            catch (AMException ame) {
                if (debug.warningEnabled()) {
                    debug.warning("IdUtils: unable to get naming attribute for org/user. Using \"o\"/\"uid\"");
                }
                ORG_NAMING_ATTR = "o=";
                USER_NAMING_ATTR = "uid=";
            }
        }
    }

    private static void initializeSpecialUsers() {
        if (specialUsers.isEmpty()) {
            String susers = SystemProperties.get("com.sun.identity.authentication.special.users", "");
            StringTokenizer st = new StringTokenizer(susers, "|");
            while (st.hasMoreTokens()) {
                specialUsers.add(DNUtils.normalizeDN(st.nextToken()));
            }
            susers = SystemProperties.get("com.sun.identity.authentication.super.user", "");
            specialUsers.add(DNUtils.normalizeDN(susers));
        }
    }

    public static IdRepoException convertAMException(AMException ame) {
        Object[] args = ame.getMessageArgs();
        String eCode = ame.getErrorCode();
        IdRepoException ide = null;
        ide = args == null ? new IdRepoException("amProfile", eCode, null) : new IdRepoException("amProfile", ame.getErrorCode(), args);
        ide.setLDAPErrorCode(ame.getLDAPErrorCode());
        return ide;
    }

    private static boolean supportedType(String typeName) {
        return mapSupportedTypes.get(typeName) != null;
    }

    private static void loadDefaultTypes() {
        supportedTypes.add(IdType.REALM);
        supportedTypes.add(IdType.AGENT);
        supportedTypes.add(IdType.USER);
        supportedTypes.add(IdType.ROLE);
        supportedTypes.add(IdType.GROUP);
        supportedTypes.add(IdType.FILTEREDROLE);
        mapSupportedTypes.put(IdType.REALM.getName(), IdType.REALM);
        mapSupportedTypes.put(IdType.USER.getName(), IdType.USER);
        mapSupportedTypes.put(IdType.ROLE.getName(), IdType.ROLE);
        mapSupportedTypes.put(IdType.FILTEREDROLE.getName(), IdType.FILTEREDROLE);
        mapSupportedTypes.put(IdType.AGENT.getName(), IdType.AGENT);
        mapSupportedTypes.put(IdType.GROUP.getName(), IdType.GROUP);
        HashSet<IdType> memberSet = new HashSet<IdType>();
        memberSet.add(IdType.ROLE);
        memberSet.add(IdType.GROUP);
        memberSet.add(IdType.FILTEREDROLE);
        typesCanBeMemberOf.put(IdType.USER.getName(), memberSet);
        HashSet<IdType> memberShipSet = new HashSet<IdType>();
        memberShipSet.add(IdType.USER);
        typesCanHaveMembers.put(IdType.ROLE.getName(), memberShipSet);
        typesCanHaveMembers.put(IdType.GROUP.getName(), memberShipSet);
        typesCanHaveMembers.put(IdType.FILTEREDROLE.getName(), memberShipSet);
        typesCanAddMembers.put(IdType.GROUP.getName(), memberShipSet);
        typesCanAddMembers.put(IdType.ROLE.getName(), memberShipSet);
    }

    private static Set getMemberSet(Set members) {
        HashSet<IdType> memberSet = new HashSet<IdType>(members.size() * 2);
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            String currType = (String)iter.next();
            memberSet.add(new IdType(currType));
        }
        return memberSet;
    }

    public static String getIdentityName(String uuid, String orgName) throws IdRepoException {
        String username = uuid;
        if (uuid != null && uuid.toLowerCase().startsWith("id=")) {
            AMIdentity id = new AMIdentity(null, uuid);
            username = id.getName();
            String realm = DNUtils.normalizeDN(id.getRealm());
            if (!DNUtils.normalizeDN(orgName).equals(realm)) {
                Object[] args = new Object[]{uuid, orgName};
                throw new IdRepoException("amIdRepo", "403", args);
            }
        }
        return username;
    }

    static {
        specialUsers = new HashSet();
        IdUtils.initialize();
    }

    static class IdUtilsListener
    implements ServiceListener {
        IdUtilsListener() {
        }

        public void schemaChanged(String serviceName, String version) {
            if (serviceName.equalsIgnoreCase("sunIdentityRepositoryService")) {
                IdUtils.initialize();
            }
        }

        public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
            if (serviceName.equalsIgnoreCase("sunIdentityRepositoryService")) {
                IdUtils.initialize();
            }
        }

        public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
            if (serviceName.equalsIgnoreCase("sunIdentityRepositoryService") && orgName.equalsIgnoreCase(ServiceManager.getBaseDN())) {
                IdUtils.initialize();
            }
        }
    }
}

