/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.meta;

import com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.shared.debug.Debug;
import java.util.Hashtable;

public class IDFFMetaCache {
    private static Debug debug = IDFFMetaUtils.debug;
    private static Hashtable entityDescriptorCache = new Hashtable();
    private static Hashtable entityConfigCache = new Hashtable();
    private static Hashtable metaAliasEntityCache = new Hashtable();
    private static Hashtable metaAliasRoleCache = new Hashtable();
    private static Hashtable entitySuccinctIDCache = new Hashtable();

    private IDFFMetaCache() {
    }

    public static EntityDescriptorElement getEntityDescriptor(String realm, String entityID) {
        String classMethod = "IDFFMetaCache:getEntityDescriptor";
        String cacheKey = IDFFMetaCache.buildCacheKey(realm, entityID);
        EntityDescriptorElement entityDescriptor = (EntityDescriptorElement)entityDescriptorCache.get(cacheKey);
        if (debug.messageEnabled()) {
            if (entityDescriptor != null) {
                debug.message(classMethod + " Entity Descriptor found for : " + cacheKey);
            } else {
                debug.message(classMethod + "EntityDescriptor not found for :" + cacheKey);
            }
        }
        return entityDescriptor;
    }

    public static void setEntityDescriptor(String realm, String entityID, EntityDescriptorElement entityDescriptor) {
        String cacheKey = IDFFMetaCache.buildCacheKey(realm, entityID);
        if (entityDescriptor != null) {
            entityDescriptorCache.put(cacheKey, entityDescriptor);
        } else {
            entityDescriptorCache.remove(cacheKey);
            entityConfigCache.remove(cacheKey);
        }
    }

    public static EntityConfigElement getEntityConfig(String realm, String entityID) {
        String classMethod = "IDFFMetaCache:getEntityConfig";
        String cacheKey = IDFFMetaCache.buildCacheKey(realm, entityID);
        EntityConfigElement entityConfig = (EntityConfigElement)entityConfigCache.get(cacheKey);
        if (debug.messageEnabled()) {
            if (entityConfig != null) {
                debug.message(classMethod + "Entity Config found for " + cacheKey);
            } else {
                debug.message(classMethod + "Entity Config not found for " + cacheKey);
            }
        }
        return entityConfig;
    }

    public static void setEntityConfig(String realm, String entityID, EntityConfigElement entityConfig) {
        String cacheKey = IDFFMetaCache.buildCacheKey(realm, entityID);
        if (entityConfig != null) {
            entityConfigCache.put(cacheKey, entityConfig);
        } else {
            entityConfigCache.remove(cacheKey);
        }
    }

    public static String getEntityByMetaAlias(String metaAlias) {
        return (String)metaAliasEntityCache.get(metaAlias);
    }

    public static void setMetaAliasEntityMapping(String metaAlias, String entityID) {
        metaAliasEntityCache.put(metaAlias, entityID);
    }

    public static String getRoleByMetaAlias(String metaAlias) {
        return (String)metaAliasRoleCache.get(metaAlias);
    }

    public static void setMetaAliasRoleMapping(String metaAlias, String role) {
        metaAliasRoleCache.put(metaAlias, role);
    }

    public static String getEntityBySuccinctID(String succinctId) {
        return (String)entitySuccinctIDCache.get(succinctId);
    }

    public static void setEntitySuccinctIDMapping(String succinctId, String entityId) {
        entitySuccinctIDCache.put(succinctId, entityId);
    }

    public static synchronized void clearCache() {
        entityDescriptorCache.clear();
        entityConfigCache.clear();
        metaAliasEntityCache.clear();
        metaAliasRoleCache.clear();
        entitySuccinctIDCache.clear();
    }

    private static String buildCacheKey(String realm, String entityId) {
        return realm + "//" + entityId;
    }
}

