/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import java.util.LinkedList;

public class ReaderWriterLock {
    private int currentReaders;
    private int queuedReaders;
    private int currentWriters;
    private final LinkedList writerLocks = new LinkedList();

    public synchronized void readRequest() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
        } else {
            ++this.queuedReaders;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean readRequestImmediate() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
            return true;
        }
        return false;
    }

    public synchronized void readDone() {
        if (--this.currentReaders == 0) {
            this.notify_writers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequest() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            ReaderWriterLock readerWriterLock = this;
            synchronized (readerWriterLock) {
                boolean goAheadWithWrite;
                boolean bl = goAheadWithWrite = this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0;
                if (goAheadWithWrite) {
                    ++this.currentWriters;
                    return;
                }
                this.writerLocks.addLast(lock);
            }
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean writeRequestImmediate() {
        if (this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0) {
            ++this.currentWriters;
            return true;
        }
        return false;
    }

    public synchronized void writeDone() {
        --this.currentWriters;
        if (this.queuedReaders > 0) {
            this.notify_readers();
        } else {
            this.notify_writers();
        }
    }

    private void notify_readers() {
        this.currentReaders += this.queuedReaders;
        this.queuedReaders = 0;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_writers() {
        if (this.writerLocks.size() > 0) {
            Object oldest = this.writerLocks.removeFirst();
            ++this.currentWriters;
            Object e = oldest;
            synchronized (e) {
                oldest.notify();
            }
        }
    }
}

