/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.common.FallBackManager;
import com.sun.identity.common.LDAPConnPoolUtils;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;

public class LDAPConnectionPool {
    private static ArrayList hostArrList = new ArrayList();
    private static Debug debug;
    private static HashSet retryErrorCodes;
    private static final String LDAP_CONNECTION_ERROR_CODES = "com.iplanet.am.ldap.connection.ldap.error.codes.retries";
    private String name;
    private int minSize;
    private int maxSize;
    private String host;
    private int port;
    private String authdn;
    private String authpw;
    private HashMap connOptions;
    private LDAPConnection ldc = null;
    private LDAPConnection[] pool;
    private long idleTime;
    private boolean defunct;
    private CleanupTask cleaner;
    private int busyConnectionCount;
    private int currentConnectionCount;
    private int waitCount;
    private boolean reinitInProgress;
    private HashSet deprecatedPool;
    private HashSet backupPool;
    private HashSet currentPool;
    static FallBackManager fMgr;

    public LDAPConnectionPool(String name, int min, int max, String host, int port, String authdn, String authpw) throws LDAPException {
        this(name, min, max, host, port, authdn, authpw, null, null);
    }

    public LDAPConnectionPool(String name, int min, int max, String host, int port) throws LDAPException {
        this(name, min, max, host, port, "", "");
    }

    public LDAPConnectionPool(String name, int min, int max, String host, int port, String authdn, String authpw, HashMap connOptions) throws LDAPException {
        this(name, min, max, host, port, authdn, authpw, null, connOptions);
    }

    public LDAPConnectionPool(String name, String host, int port) throws LDAPException {
        this(name, 10, 20, host, port, "", "", null);
    }

    public LDAPConnectionPool(String name, int min, int max, LDAPConnection ldc) throws LDAPException {
        this(name, min, max, ldc.getHost(), ldc.getPort(), ldc.getAuthenticationDN(), ldc.getAuthenticationPassword(), ldc, null);
    }

    public LDAPConnectionPool(String name, int min, int max, String host, int port, String authdn, String authpw, LDAPConnection ldc, HashMap connOptions) throws LDAPException {
        this(name, min, max, host, port, authdn, authpw, ldc, LDAPConnectionPool.getIdleTime(name), connOptions);
    }

    private static final int getIdleTime(String poolName) {
        String idleStr = SystemProperties.get("com.sun.am.ldap.connnection.idle.seconds");
        int idleTimeInSecs = 0;
        if (idleStr != null && idleStr.length() > 0) {
            try {
                idleTimeInSecs = Integer.parseInt(idleStr);
            }
            catch (NumberFormatException nex) {
                debug.error("LDAPConnection pool: " + poolName + ": Cannot parse idle time: " + idleStr + " Connection reaping is disabled.");
            }
        }
        return idleTimeInSecs;
    }

    private LDAPConnectionPool(String name, int min, int max, String host, int port, String authdn, String authpw, LDAPConnection ldc, int idleTimeInSecs, HashMap connOptions) throws LDAPException {
        this.name = name;
        this.minSize = min;
        this.maxSize = max;
        if (connOptions != null) {
            this.createHostList(host);
        } else {
            this.host = host;
            this.port = port;
        }
        this.authdn = authdn;
        this.authpw = authpw;
        this.ldc = ldc;
        this.idleTime = idleTimeInSecs * 1000;
        this.defunct = false;
        this.reinitInProgress = false;
        this.createPool();
        if (debug.messageEnabled()) {
            debug.message("LDAPConnection pool: " + name + ": successfully created: Min:" + this.minSize + " Max:" + this.maxSize + " Idle time:" + idleTimeInSecs);
        }
        this.createIdleCleanupThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.cleaner != null) {
            this.cleaner.cancel();
        }
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            if (!this.defunct) {
                this.defunct = true;
                for (int i = 0; i < this.currentConnectionCount - this.busyConnectionCount; ++i) {
                    if (this.pool[i] == null || !this.pool[i].isConnected()) continue;
                    try {
                        this.backupPool.remove(this.pool[i]);
                        this.currentPool.remove(this.pool[i]);
                        this.pool[i].disconnect();
                        continue;
                    }
                    catch (LDAPException e) {
                        debug.error("LDAPConnection pool:" + this.name + ":Error during disconnect.", e);
                    }
                }
                this.busyConnectionCount = 0;
                this.currentConnectionCount = 0;
                this.pool = null;
            }
            if (this.ldc != null && this.ldc.isConnected()) {
                try {
                    this.ldc.disconnect();
                }
                catch (LDAPException e) {
                    debug.error("LDAPConnection pool:" + this.name + ":Error during disconnect.", e);
                }
            }
            this.notifyAll();
        }
    }

    public LDAPConnection getConnection() {
        return this.getConnection(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnection(int timeout) {
        LDAPConnection con = null;
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            try {
                if (this.busyConnectionCount == this.maxSize || this.waitCount > 0) {
                    ++this.waitCount;
                    if (timeout > 0) {
                        this.wait(timeout);
                    } else {
                        this.wait();
                    }
                    --this.waitCount;
                }
                if (!this.defunct) {
                    con = this.getConnFromPool();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return con;
    }

    protected LDAPConnection getConnFromPool() {
        LDAPConnection con = null;
        if (this.currentConnectionCount == this.busyConnectionCount && this.currentConnectionCount < this.maxSize) {
            try {
                con = this.createConnection(LDAPConnPoolUtils.connectionPoolsStatus);
                this.backupPool.add(con);
                ++this.currentConnectionCount;
                ++this.busyConnectionCount;
            }
            catch (Exception ex) {
                debug.error("LDAPConnection pool:" + this.name + ":Error while adding a connection.", ex);
            }
        } else if (this.currentConnectionCount > this.busyConnectionCount) {
            con = this.pool[this.currentConnectionCount - this.busyConnectionCount - 1];
            this.pool[this.currentConnectionCount - this.busyConnectionCount - 1] = null;
            ++this.busyConnectionCount;
            this.currentPool.remove(con);
            if (this.cleaner != null && this.currentConnectionCount - this.busyConnectionCount >= this.minSize) {
                this.cleaner.removeElement(null);
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(LDAPConnection ld) {
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            if (this.defunct) {
                if (ld != null && (this.backupPool.remove(ld) || this.deprecatedPool.remove(ld)) && ld.isConnected()) {
                    try {
                        ld.disconnect();
                    }
                    catch (LDAPException ex) {
                        debug.error("LDAPConnection pool:" + this.name + ":Error during disconnect.", ex);
                    }
                }
            } else if (ld != null) {
                if (this.reinitInProgress && this.deprecatedPool.remove(ld)) {
                    try {
                        ld.disconnect();
                    }
                    catch (LDAPException ex) {
                        debug.error("LDAPConnection pool:" + this.name + ":Error during disconnect.", ex);
                    }
                    if (this.deprecatedPool.isEmpty()) {
                        this.reinitInProgress = false;
                    }
                    return;
                }
                if (this.backupPool.contains(ld) && this.currentPool.add(ld)) {
                    --this.busyConnectionCount;
                    this.pool[this.currentConnectionCount - this.busyConnectionCount - 1] = ld;
                    if (this.cleaner != null && this.currentConnectionCount - this.busyConnectionCount > this.minSize) {
                        this.cleaner.addElement(null);
                    }
                    if (this.waitCount > 0) {
                        this.notify();
                    }
                }
            }
        }
    }

    public void close(LDAPConnection ld, int errCode) {
        if (debug.messageEnabled()) {
            debug.message("LDAPConnectionPool:close(): errCode " + errCode);
        }
        if (retryErrorCodes.contains(Integer.toString(errCode))) {
            this.failOver(ld);
            if (LDAPConnPoolUtils.connectionPoolsStatus != null && !LDAPConnPoolUtils.connectionPoolsStatus.isEmpty()) {
                if (fMgr == null) {
                    fMgr = new FallBackManager();
                }
                if (fMgr.scheduledExecutionTime() == -1L) {
                    SystemTimer.getTimer().schedule((TaskRunnable)fMgr, new Date(System.currentTimeMillis() / 1000L * 1000L));
                }
            }
        }
        this.close(ld);
    }

    private void createPool() throws LDAPException {
        if (this.minSize <= 0) {
            throw new LDAPException("LDAPConnection pool:" + this.name + ":ConnectionPoolSize invalid");
        }
        if (this.maxSize < this.minSize) {
            debug.error("LDAPConnection pool:" + this.name + ":ConnectionPoolMax is invalid, set to " + this.minSize);
            this.maxSize = this.minSize;
        }
        if (debug.messageEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("");
            buf.append("New Connection pool name =" + this.name);
            buf.append(" LDAP host =").append(this.host);
            buf.append(" Port =").append(this.port);
            buf.append(" Min =").append(this.minSize);
            buf.append(" Max =").append(this.maxSize);
            debug.message("LDAPConnectionPool:createPool(): buf.toString()" + buf.toString());
        }
        this.pool = new LDAPConnection[this.maxSize];
        this.backupPool = new HashSet();
        this.currentPool = new HashSet();
        for (int i = 0; i < this.minSize; ++i) {
            this.pool[i] = this.createConnection(LDAPConnPoolUtils.connectionPoolsStatus);
            this.backupPool.add(this.pool[i]);
            this.currentPool.add(this.pool[i]);
        }
        this.currentConnectionCount = this.minSize;
        this.busyConnectionCount = 0;
        this.waitCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPConnection createConnection(HashMap aConnectionPoolsStatus) throws LDAPException {
        LDAPConnection newConn;
        block18: {
            newConn = this.ldc != null ? (LDAPConnection)this.ldc.clone() : new LDAPConnection();
            String key = this.name + ":" + this.host + ":" + this.port + ":" + this.authdn;
            try {
                if (newConn.isConnected()) {
                    newConn.reconnect();
                    if (debug.messageEnabled()) {
                        debug.message("LDAPConnectionPool: createConnection(): with template primary host: " + this.host + "primary port: " + this.port);
                    }
                    break block18;
                }
                try {
                    newConn.connect(3, this.host, this.port, this.authdn, this.authpw);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPConnectionPool: createConnection():No template primary host: " + this.host + "primary port: " + this.port);
                    }
                }
                catch (LDAPException connEx) {
                    if (connEx.getLDAPResultCode() == 2) {
                        newConn.connect(2, this.host, this.port, this.authdn, this.authpw);
                        if (debug.messageEnabled()) {
                            debug.message("LDAPConnectionPool: createConnection():No template primary host: " + this.host + "primary port: with v2 " + this.port);
                        }
                        break block18;
                    }
                    if (aConnectionPoolsStatus != null) {
                        HashMap hashMap = aConnectionPoolsStatus;
                        synchronized (hashMap) {
                            aConnectionPoolsStatus.put(key, this);
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("LDAPConnectionPool: createConnection():primary host" + this.host + "primary port-" + this.port + " :is down." + "Failover to the secondary server.");
                    }
                    this.close(this.ldc, connEx.getLDAPResultCode());
                }
            }
            catch (LDAPException le) {
                debug.error("LDAPConnection pool:createConnection():Error while Creating pool.", le);
                if (aConnectionPoolsStatus != null) {
                    HashMap hashMap = aConnectionPoolsStatus;
                    synchronized (hashMap) {
                        aConnectionPoolsStatus.put(key, this);
                    }
                }
                throw le;
            }
        }
        return newConn;
    }

    private void createIdleCleanupThread() {
        if (this.idleTime > 0L) {
            this.cleaner = new CleanupTask(this, this, this.idleTime / 2L, this.idleTime);
            SystemTimerPool.getTimerPool().schedule((TaskRunnable)this.cleaner, new Date((System.currentTimeMillis() + this.idleTime) / 1000L * 1000L));
            if (debug.messageEnabled()) {
                debug.message("LDAPConnection pool: " + this.name + ": Cleanup task created successfully.");
            }
        }
    }

    private void createHostList(String hostNameFromConfig) {
        StringTokenizer st = new StringTokenizer(hostNameFromConfig);
        while (st.hasMoreElements()) {
            String str = st.nextToken();
            if (str == null || str.length() == 0) continue;
            if (debug.messageEnabled()) {
                debug.message("LDAPConnectionPool:createHostList():host name:" + str);
            }
            hostArrList.add(str);
        }
        String hpName = (String)hostArrList.get(0);
        StringTokenizer stn = new StringTokenizer(hpName, ":");
        this.host = stn.nextToken();
        this.port = Integer.valueOf(stn.nextToken());
    }

    public synchronized void reinitialize(LDAPConnection ld) throws LDAPException {
        if (!this.reinitInProgress) {
            this.reinitInProgress = true;
        }
        if (this.cleaner != null) {
            this.cleaner.cancel();
        }
        for (int i = 0; i < this.currentConnectionCount - this.busyConnectionCount; ++i) {
            if (this.pool[i] == null || !this.pool[i].isConnected()) continue;
            this.currentPool.remove(this.pool[i]);
            this.backupPool.remove(this.pool[i]);
            this.pool[i].disconnect();
        }
        if (this.deprecatedPool == null) {
            this.deprecatedPool = this.backupPool;
        } else {
            this.deprecatedPool.addAll(this.backupPool);
        }
        this.host = ld.getHost();
        this.port = ld.getPort();
        this.authdn = ld.getAuthenticationDN();
        this.authpw = ld.getAuthenticationPassword();
        this.ldc = (LDAPConnection)ld.clone();
        if (debug.messageEnabled()) {
            debug.message("LDAPConnection pool: " + this.name + ": reinitializing connection pool: Host:" + this.host + " Port:" + this.port + "Auth DN:" + this.authdn);
        }
        this.createPool();
        this.createIdleCleanupThread();
        if (debug.messageEnabled()) {
            debug.message("LDAPConnection pool: " + this.name + ": reinitialized successfully.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseCurrentConnection() {
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            try {
                LDAPConnection con = this.pool[this.currentConnectionCount - this.busyConnectionCount - 1];
                this.currentPool.remove(con);
                this.backupPool.remove(con);
                con.disconnect();
            }
            catch (LDAPException e) {
                debug.error("LDAPConnection pool:" + this.name + ":Error during disconnect.", e);
            }
            this.pool[this.currentConnectionCount - this.busyConnectionCount - 1] = null;
            --this.currentConnectionCount;
        }
    }

    public void fallBack(LDAPConnection con) {
        if (!this.isPrimaryUP()) {
            LDAPConnection newConn = new LDAPConnection();
            int sze = hostArrList.size();
            for (int i = 0; i < sze; ++i) {
                String hpName = (String)hostArrList.get(i);
                StringTokenizer stn = new StringTokenizer(hpName, ":");
                String upHost = stn.nextToken();
                String upPort = stn.nextToken();
                if (upHost == null || upHost.length() == 0 || upPort == null || upPort.length() == 0 || con.getHost() == null || !con.getHost().equalsIgnoreCase(upHost)) continue;
                newConn = this.failoverAndfallback(upHost, upPort, newConn, "fallback");
                break;
            }
            this.reinit(newConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failOver(LDAPConnection ld) {
        LDAPConnection newConn = new LDAPConnection();
        String downKey = this.name + ":" + ld.getHost() + ":" + ld.getPort() + ":" + this.authdn;
        if (LDAPConnPoolUtils.connectionPoolsStatus != null) {
            HashMap hashMap = LDAPConnPoolUtils.connectionPoolsStatus;
            synchronized (hashMap) {
                LDAPConnPoolUtils.connectionPoolsStatus.put(downKey, this);
            }
        }
        int size = hostArrList.size();
        for (int i = 0; i < size; ++i) {
            String hpName = (String)hostArrList.get(i);
            StringTokenizer stn = new StringTokenizer(hpName, ":");
            String upHost = stn.nextToken();
            String upPort = stn.nextToken();
            if (upHost != null && upHost.length() != 0 && upPort != null && upPort.length() != 0 && ld.getHost() != null && !ld.getHost().equalsIgnoreCase(upHost)) {
                newConn = this.failoverAndfallback(upHost, upPort, newConn, "failover");
                break;
            }
            if (upHost == null || upHost.length() == 0 || upPort == null || upPort.length() == 0 || ld.getHost() == null) continue;
            int thisPort = Integer.valueOf(upPort);
            if (!ld.getHost().equalsIgnoreCase(upHost) || ld.getPort() == thisPort) continue;
            newConn = this.failoverAndfallback(upHost, upPort, newConn, "failover");
            break;
        }
        this.reinit(newConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPConnection failoverAndfallback(String upHost, String upPort, LDAPConnection newConn, String caller) {
        if (debug.messageEnabled()) {
            debug.message("In LDAPConnectionPool:failoverAndfallback()");
        }
        int intPort = Integer.valueOf(upPort);
        String upKey = this.name + ":" + upHost + ":" + upPort + ":" + this.authdn;
        try {
            newConn.connect(3, upHost, intPort, this.authdn, this.authpw);
            if (LDAPConnPoolUtils.connectionPoolsStatus != null) {
                HashMap hashMap = LDAPConnPoolUtils.connectionPoolsStatus;
                synchronized (hashMap) {
                    if (LDAPConnPoolUtils.connectionPoolsStatus.containsKey(upKey)) {
                        LDAPConnPoolUtils.connectionPoolsStatus.remove(upKey);
                    }
                }
            }
            if (debug.messageEnabled()) {
                if (caller.equalsIgnoreCase("fallback")) {
                    debug.message("LDAPConnectionPool.failoverAndfallback()fall back successfully to primary host- " + upHost + " primary port: " + upPort);
                } else {
                    debug.message("LDAPConnectionPool.failoverAndfallback()fail over success to secondary host- " + upHost + " secondary port: " + upPort);
                }
            }
            return newConn;
        }
        catch (LDAPException connEx) {
            block27: {
                if (connEx.getLDAPResultCode() == 2) {
                    try {
                        newConn.connect(2, upHost, intPort, this.authdn, this.authpw);
                    }
                    catch (LDAPException conn2Ex) {
                        if (!debug.messageEnabled()) break block27;
                        if (caller.equalsIgnoreCase("fallback")) {
                            debug.message("LDAPConnectionPool.failoverAndfallback():fallback failed.");
                            break block27;
                        }
                        if (LDAPConnPoolUtils.connectionPoolsStatus != null) {
                            HashMap hashMap = LDAPConnPoolUtils.connectionPoolsStatus;
                            synchronized (hashMap) {
                                LDAPConnPoolUtils.connectionPoolsStatus.put(upKey, this);
                            }
                        }
                        debug.message("LDAPConnectionPool.failoverAndfallback():primary host-" + upHost + " primary port-" + upPort + " :is down. Failover to the" + " secondary server. in catch1 ");
                    }
                } else if (debug.messageEnabled()) {
                    if (caller.equalsIgnoreCase("fallback")) {
                        debug.message("LDAPConnectionPool.failoverAndfallback():continue fallback to next server");
                    } else {
                        if (LDAPConnPoolUtils.connectionPoolsStatus != null) {
                            HashMap hashMap = LDAPConnPoolUtils.connectionPoolsStatus;
                            synchronized (hashMap) {
                                LDAPConnPoolUtils.connectionPoolsStatus.put(upKey, this);
                            }
                        }
                        debug.message("LDAPConnectionPool. failoverAndfallback():primary host-" + upHost + "primary port-" + upPort + " :is down. Failover to the" + " secondary server. in else");
                    }
                }
            }
            return newConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPrimaryUP() {
        boolean retVal = false;
        String hpName = (String)hostArrList.get(0);
        StringTokenizer stn = new StringTokenizer(hpName, ":");
        String upHost = stn.nextToken();
        String upPort = stn.nextToken();
        if (upHost != null && upHost.length() != 0 && upPort != null && upPort.length() != 0) {
            String upKey = this.name + ":" + upHost + ":" + upPort + ":" + this.authdn;
            if (LDAPConnPoolUtils.connectionPoolsStatus != null) {
                HashMap hashMap = LDAPConnPoolUtils.connectionPoolsStatus;
                synchronized (hashMap) {
                    if (!LDAPConnPoolUtils.connectionPoolsStatus.containsKey(upKey)) {
                        retVal = true;
                    }
                }
            }
        }
        return retVal;
    }

    private void reinit(LDAPConnection newConn) {
        try {
            this.reinitialize(newConn);
            if (this.connOptions != null && !this.connOptions.isEmpty()) {
                Iterator itr = this.connOptions.keySet().iterator();
                while (itr.hasNext()) {
                    String optName = (String)itr.next();
                    if (optName.equalsIgnoreCase("maxbacklog")) {
                        newConn.setOption(30, this.connOptions.get(optName));
                    }
                    if (optName.equalsIgnoreCase("referrals")) {
                        newConn.setOption(8, this.connOptions.get(optName));
                    }
                    if (!optName.equalsIgnoreCase("searchconstraints")) continue;
                    newConn.setSearchConstraints((LDAPSearchConstraints)this.connOptions.get(optName));
                }
            }
            if (newConn != null && newConn.isConnected()) {
                newConn.disconnect();
            }
        }
        catch (LDAPException lde) {
            debug.error("LDAPConnectionPool:reinit():Error while reinitializing connection from pool.", lde);
        }
    }

    static /* synthetic */ void access$000(LDAPConnectionPool x0) {
        x0.decreaseCurrentConnection();
    }

    static {
        retryErrorCodes = new HashSet();
        debug = Debug.getInstance("LDAPConnectionPool");
        String retryErrs = SystemProperties.get(LDAP_CONNECTION_ERROR_CODES);
        if (retryErrs != null) {
            StringTokenizer stz = new StringTokenizer(retryErrs, ",");
            while (stz.hasMoreTokens()) {
                retryErrorCodes.add(stz.nextToken().trim());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPConnectionPool: retry error codes = " + retryErrorCodes);
        }
    }
}

