/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.comm.share.RequestSetParser;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NotificationSetParser {
    Document document;

    public NotificationSetParser(Document xmlDoc) {
        this.document = xmlDoc;
    }

    public NotificationSetParser(String xmlString) {
        this.document = XMLUtils.toDOMDocument(xmlString, RequestSetParser.debug);
    }

    public NotificationSet parseXML() {
        if (this.document == null) {
            return null;
        }
        Element notifSetElem = this.document.getDocumentElement();
        NotificationSet notificationSet = new NotificationSet();
        this.setNotificationSetAttributes(notifSetElem, notificationSet);
        NodeList notifs = notifSetElem.getElementsByTagName("Notification");
        if (notifs == null) {
            return notificationSet;
        }
        int nodeLen = notifs.getLength();
        for (int i = 0; i < nodeLen; ++i) {
            notificationSet.addNotification(this.parseNotificationElement((Element)notifs.item(i)));
        }
        return notificationSet;
    }

    public void setNotificationSetAttributes(Element elem, NotificationSet notifSet) {
        String temp = elem.getAttribute("vers");
        if (temp != null) {
            notifSet.setNotificationSetVersion(temp);
        }
        if ((temp = elem.getAttribute("svcid")) != null) {
            notifSet.setServiceID(temp);
        }
        if ((temp = elem.getAttribute("notid")) != null) {
            notifSet.setNotificationSetID(temp);
        }
    }

    private Notification parseNotificationElement(Element elem) {
        Notification notif = new Notification();
        String temp = elem.getAttribute("dtdid");
        if (temp != null) {
            notif.setDtdID(temp);
        }
        Node text = null;
        NodeList nlist = elem.getChildNodes();
        int nodeLen = nlist.getLength();
        for (int i = 0; i < nodeLen; ++i) {
            Node n = nlist.item(i);
            if (n.getNodeType() != 4) continue;
            text = n;
            break;
        }
        if (text != null) {
            notif.setContent(text.getNodeValue());
        }
        return notif;
    }
}

