/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.AVAValueConverter;
import java.io.CharConversionException;
import java.io.IOException;
import sun.io.CharToByteConverter;

public class PrintableConverter
implements AVAValueConverter {
    public DerValue getValue(String valueString) throws IOException {
        return this.getValue(valueString, null);
    }

    public DerValue getValue(String valueString, byte[] encodingOrder) throws IOException {
        byte[] bbuf = new byte[valueString.length()];
        try {
            CharToByteConverter printable = ASN1CharStrConvMap.getDefault().getCBC((byte)19);
            if (printable == null) {
                throw new IOException("No CharToByteConverter for printable");
            }
            printable.convert(valueString.toCharArray(), 0, valueString.length(), bbuf, 0, bbuf.length);
        }
        catch (CharConversionException e) {
            throw new IllegalArgumentException("Invalid Printable String AVA Value");
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot instantiate CharToByteConverter");
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot load CharToByteConverter");
        }
        return new DerValue(19, bbuf);
    }

    public DerValue getValue(byte[] berStream) throws IOException {
        DerValue value = new DerValue(berStream);
        if (value.tag != 19) {
            throw new IOException("Invalid Printable String AVA Value");
        }
        return value;
    }

    public String getAsString(DerValue avaValue) throws IOException {
        return avaValue.getPrintableString();
    }
}

