/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.ByteToCharIA5String;
import com.iplanet.security.util.ByteToCharPrintable;
import com.iplanet.security.util.ByteToCharUniversalString;
import com.iplanet.security.util.CharToByteIA5String;
import com.iplanet.security.util.CharToBytePrintable;
import com.iplanet.security.util.CharToByteUniversalString;
import com.iplanet.security.util.latin1BCC;
import com.iplanet.security.util.latin1CBC;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.io.ByteToCharConverter;
import sun.io.ByteToCharUTF8;
import sun.io.ByteToCharUnicodeBig;
import sun.io.CharToByteConverter;
import sun.io.CharToByteUTF8;
import sun.io.CharToByteUnicodeBig;

public class ASN1CharStrConvMap {
    private Hashtable tag2CBC = new Hashtable();
    private Hashtable tag2BCC = new Hashtable();
    private static ASN1CharStrConvMap defaultMap = new ASN1CharStrConvMap();

    public CharToByteConverter getCBC(byte tag) throws IllegalAccessException, InstantiationException {
        Byte tagObj = new Byte(tag);
        CharToByteConverter cbc = null;
        Class cbcClass = (Class)this.tag2CBC.get(tagObj);
        if (cbcClass == null) {
            return null;
        }
        cbc = (CharToByteConverter)cbcClass.newInstance();
        cbc.setSubstitutionMode(false);
        return cbc;
    }

    public ByteToCharConverter getBCC(byte tag) throws IllegalAccessException, InstantiationException {
        Byte tagObj = new Byte(tag);
        ByteToCharConverter bcc = null;
        Class bccClass = (Class)this.tag2BCC.get(tagObj);
        if (bccClass == null) {
            return null;
        }
        bcc = (ByteToCharConverter)bccClass.newInstance();
        bcc.setSubstitutionMode(false);
        return bcc;
    }

    public void addEntry(byte tag, Class cbc, Class bcc) {
        Byte tagByte = new Byte(tag);
        Class current_cbc = (Class)this.tag2CBC.get(tagByte);
        Class current_bcc = (Class)this.tag2BCC.get(tagByte);
        if (current_cbc != null || current_bcc != null) {
            if (current_cbc != cbc || current_bcc != bcc) {
                throw new IllegalArgumentException("a DER tag to converter entry already exists.");
            }
            return;
        }
        if (!CharToByteConverter.class.isAssignableFrom(cbc) || !ByteToCharConverter.class.isAssignableFrom(bcc)) {
            throw new IllegalArgumentException("arguments not a CharToByteConverter or ByteToCharConverter");
        }
        this.tag2CBC.put(tagByte, cbc);
        this.tag2BCC.put(tagByte, bcc);
    }

    public Enumeration getTags() {
        return this.tag2CBC.keys();
    }

    public static ASN1CharStrConvMap getDefault() {
        return defaultMap;
    }

    public static void setDefault(ASN1CharStrConvMap newDefault) {
        if (newDefault == null) {
            throw new IllegalArgumentException("Cannot set a null default Der Tag Converter map");
        }
        defaultMap = newDefault;
    }

    static {
        defaultMap.addEntry((byte)19, CharToBytePrintable.class, ByteToCharPrintable.class);
        defaultMap.addEntry((byte)26, CharToBytePrintable.class, ByteToCharPrintable.class);
        defaultMap.addEntry((byte)22, CharToByteIA5String.class, ByteToCharIA5String.class);
        defaultMap.addEntry((byte)30, CharToByteUnicodeBig.class, ByteToCharUnicodeBig.class);
        defaultMap.addEntry((byte)28, CharToByteUniversalString.class, ByteToCharUniversalString.class);
        defaultMap.addEntry((byte)20, latin1CBC.class, latin1BCC.class);
        defaultMap.addEntry((byte)12, CharToByteUTF8.class, ByteToCharUTF8.class);
    }
}

