/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.dpro.session.share.SessionRequestParser;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.UnsupportedEncodingException;

public class SessionRequest {
    public static final int GetSession = 0;
    public static final int GetValidSessions = 1;
    public static final int DestroySession = 2;
    public static final int Logout = 3;
    public static final int AddSessionListener = 4;
    public static final int AddSessionListenerOnAllSessions = 5;
    public static final int SetProperty = 6;
    public static final int GetSessionCount = 7;
    static final String QUOTE = "\"";
    static final String NL = "\n";
    static final String AMPERSAND = "&amp;";
    static final String LESSTHAN = "&lt;";
    static final String GREATERTHAN = "&gt;";
    static final String APOSTROPHE = "&apos;";
    static final String QUOTATION = "&quot;";
    private String requestVersion = "1.0";
    private String requestID = null;
    private boolean resetFlag;
    private int methodID;
    private String sessionID = null;
    private String requester = null;
    private String destroySessionID = null;
    private String notificationURL = null;
    private String propertyName = null;
    private String propertyValue = null;
    private String pattern = null;
    private String uuid = null;
    private static int requestCount = 0;

    public SessionRequest(int method, String sid, boolean reset) {
        this.methodID = method;
        this.sessionID = sid;
        this.resetFlag = reset;
        this.requestID = new Integer(requestCount++).toString();
    }

    SessionRequest() {
    }

    public static SessionRequest parseXML(String xml) {
        SessionRequestParser parser = new SessionRequestParser(xml);
        return parser.parseXML();
    }

    void setRequestVersion(String version) {
        this.requestVersion = version;
    }

    public String getRequestVersion() {
        return this.requestVersion;
    }

    void setRequestID(String id) {
        this.requestID = id;
    }

    public String getRequestID() {
        return this.requestID;
    }

    void setMethodID(int id) {
        this.methodID = id;
    }

    public int getMethodID() {
        return this.methodID;
    }

    void setSessionID(String id) {
        this.sessionID = id;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public String getRequester() {
        return this.requester;
    }

    void setResetFlag(boolean reset) {
        this.resetFlag = reset;
    }

    public boolean getResetFlag() {
        return this.resetFlag;
    }

    public void setDestroySessionID(String id) {
        this.destroySessionID = id;
    }

    public String getDestroySessionID() {
        return this.destroySessionID;
    }

    public void setNotificationURL(String url) {
        this.notificationURL = url;
    }

    public String getNotificationURL() {
        return this.notificationURL;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyValue(String value) {
        this.propertyValue = value;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPattern(String value) {
        String data = value;
        if (value == null) {
            this.pattern = null;
            return;
        }
        data = this.replaceIllegalChar(data, '&', AMPERSAND);
        data = this.replaceIllegalChar(data, '\'', APOSTROPHE);
        data = this.replaceIllegalChar(data, '\"', QUOTATION);
        data = this.replaceIllegalChar(data, '<', LESSTHAN);
        this.pattern = data = this.replaceIllegalChar(data, '>', GREATERTHAN);
    }

    public String getPattern() {
        String data = this.pattern;
        if (data == null) {
            return null;
        }
        data = this.replaceEntityRef(data, AMPERSAND, '&');
        data = this.replaceEntityRef(data, APOSTROPHE, '\'');
        data = this.replaceEntityRef(data, QUOTATION, '\"');
        data = this.replaceEntityRef(data, LESSTHAN, '<');
        data = this.replaceEntityRef(data, GREATERTHAN, '>');
        return data;
    }

    public void setUUID(String id) {
        this.uuid = id;
    }

    public String getUUID() {
        return this.uuid;
    }

    private String replaceIllegalChar(String data, char ch, String replacement) {
        int idx = 0;
        StringBuffer buffer = new StringBuffer(data.length() * 4);
        while (data != null && (idx = data.indexOf(ch)) != -1) {
            buffer.append(data.substring(0, idx));
            buffer.append(replacement);
            data = data.substring(idx + 1);
        }
        if (data != null && data.length() > 0) {
            buffer.append(data);
        }
        return buffer.toString();
    }

    private String replaceEntityRef(String data, String ref, char ch) {
        int idx = 0;
        StringBuffer buffer = new StringBuffer(data.length());
        while ((idx = data.indexOf(ref)) != -1) {
            buffer.append(data.substring(0, idx));
            buffer.append(ch);
            data = data.substring(idx + ref.length());
        }
        if (data != null && data.length() > 0) {
            buffer.append(data);
        }
        return buffer.toString();
    }

    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<SessionRequest vers=\"" + this.requestVersion + QUOTE + " reqid=" + QUOTE + this.requestID + QUOTE);
        if (this.requester != null) {
            try {
                String data = Base64.encode(this.requester.getBytes("UTF8"));
                xml.append(" requester=\"" + data + QUOTE);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        xml.append(">\n");
        switch (this.methodID) {
            case 0: {
                xml.append("<GetSession reset=");
                if (this.resetFlag) {
                    xml.append("\"true\">\n");
                } else {
                    xml.append("\"false\">\n");
                }
                xml.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                xml.append("</GetSession>\n");
                break;
            }
            case 1: {
                xml.append("<GetValidSessions>\n");
                xml.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                if (this.pattern != null) {
                    xml.append("<Pattern>" + this.pattern + "</Pattern>" + NL);
                }
                xml.append("</GetValidSessions>\n");
                break;
            }
            case 2: {
                if (this.destroySessionID == null) {
                    return null;
                }
                xml.append("<DestroySession>\n");
                xml.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                xml.append("<DestroySessionID>" + this.destroySessionID + "</DestroySessionID>" + NL);
                xml.append("</DestroySession>\n");
                break;
            }
            case 3: {
                xml.append("<Logout>\n");
                xml.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                xml.append("</Logout>\n");
                break;
            }
            case 4: {
                if (this.notificationURL == null) {
                    return null;
                }
                xml.append("<AddSessionListener>\n");
                xml.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                xml.append("<URL>" + this.notificationURL + "</URL>" + NL);
                xml.append("</AddSessionListener>\n");
                break;
            }
            case 5: {
                if (this.notificationURL == null) {
                    return null;
                }
                xml.append("<AddSessionListenerOnAllSessions>\n");
                xml.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                xml.append("<URL>" + this.notificationURL + "</URL>" + NL);
                xml.append("</AddSessionListenerOnAllSessions>\n");
                break;
            }
            case 6: {
                if (this.propertyName == null || this.propertyValue == null) {
                    return null;
                }
                xml.append("<SetProperty>\n");
                xml.append("<SessionID>" + this.sessionID + "</SessionID>" + NL);
                xml.append("<Property name=").append(QUOTE).append(XMLUtils.escapeSpecialCharacters(this.propertyName)).append(QUOTE).append(" value=").append(QUOTE).append(XMLUtils.escapeSpecialCharacters(this.propertyValue)).append(QUOTE).append(">").append("</Property>\n");
                xml.append("</SetProperty>\n");
                break;
            }
            case 7: {
                xml.append("<GetSessionCount>").append(NL);
                xml.append("<SessionID>").append(this.sessionID).append("</SessionID>").append(NL);
                xml.append("<UUID>").append(this.uuid).append("</UUID>").append(NL);
                xml.append("</GetSessionCount>").append(NL);
                break;
            }
            default: {
                return null;
            }
        }
        xml.append("</SessionRequest>");
        return xml.toString();
    }
}

