/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMTemplateImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.SearchControl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMRoleImpl
extends AMObjectImpl
implements AMRole {
    static String roleTypeAN = "iplanet-am-role-type";
    static String roleDNsAN = "nsroledn";
    private static final Integer POLICY_TEMPLATE_INTEGER = new Integer(300);

    public AMRoleImpl(SSOToken ssoToken, String DN2) {
        super(ssoToken, DN2, 6);
    }

    AMRoleImpl(SSOToken ssoToken, String DN2, int type) {
        super(ssoToken, DN2, type);
    }

    public int getRoleType() throws AMException, SSOException {
        return this.getIntegerAttribute(roleTypeAN);
    }

    public void setRoleType(int roleType) throws AMException, SSOException {
        this.setIntegerAttribute(roleTypeAN, roleType);
        this.store();
    }

    public void addUsers(Set users) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.dsServices.modifyMemberShip(this.token, users, this.entryDN, 6, 1);
    }

    public void removeUsers(Set users) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.dsServices.modifyMemberShip(this.token, users, this.entryDN, 6, 2);
    }

    public long getNumberOfUsers() throws AMException, SSOException {
        return this.getUserDNs().size();
    }

    public Set getUserDNs() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return this.dsServices.getMembers(this.token, this.entryDN, this.profileType);
    }

    public Set searchUsers(String wildcard, int level) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, level);
    }

    public AMSearchResults searchUsers(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, searchControl);
    }

    public Set searchUsers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        if (level != 1 && level != 2) {
            throw new AMException(AMSDKBundle.getString("123", this.locale), "123");
        }
        if (wildcard == null || wildcard.length() == 0) {
            throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        }
        String userFilter = "(&(" + AMNamingAttrManager.getNamingAttr(1) + "=" + wildcard + ")" + this.getSearchFilter(1) + "(" + roleDNsAN + "=" + this.entryDN + "))";
        String filter = null;
        if (avPairs == null) {
            filter = userFilter;
        } else if (avPairs.size() == 0) {
            filter = userFilter;
        } else {
            StringBuffer filterSB = new StringBuffer();
            filterSB.append("(&").append(userFilter).append("(|");
            Iterator iter = avPairs.keySet().iterator();
            while (iter.hasNext()) {
                String attributeName = (String)iter.next();
                Iterator iter2 = ((Set)avPairs.get(attributeName)).iterator();
                while (iter2.hasNext()) {
                    String attributeValue = (String)iter2.next();
                    filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
                }
            }
            filterSB.append("))");
            filter = filterSB.toString();
        }
        return this.dsServices.search(this.token, this.getOrganizationDN(), filter, level);
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        int level = searchControl.getSearchScope();
        if (level != 1 && level != 2) {
            throw new AMException(AMSDKBundle.getString("123", this.locale), "123");
        }
        if (wildcard == null || wildcard.length() == 0) {
            throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        }
        String userFilter = "(&(" + AMNamingAttrManager.getNamingAttr(1) + "=" + wildcard + ")" + this.getSearchFilter(1) + "(" + roleDNsAN + "=" + this.entryDN + "))";
        String filter = null;
        if (avPairs == null) {
            filter = userFilter;
        } else if (avPairs.size() == 0) {
            filter = userFilter;
        } else {
            StringBuffer filterSB = new StringBuffer();
            filterSB.append("(&").append(userFilter).append("(|");
            Iterator iter = avPairs.keySet().iterator();
            while (iter.hasNext()) {
                String attributeName = (String)iter.next();
                Iterator iter2 = ((Set)avPairs.get(attributeName)).iterator();
                while (iter2.hasNext()) {
                    String attributeValue = (String)iter2.next();
                    filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
                }
            }
            filterSB.append("))");
            filter = filterSB.toString();
        }
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.getOrganizationDN(), filter, sc, returnAttrs);
    }

    public AMSearchResults searchUsers(AMSearchControl searchControl, String avFilter) throws AMException, SSOException {
        int level = searchControl.getSearchScope();
        if (level != 1 && level != 2) {
            throw new AMException(AMSDKBundle.getString("123", this.locale), "123");
        }
        String filter = "(&" + this.getSearchFilter(1) + "(" + roleDNsAN + "=" + this.entryDN + ")" + avFilter + ")";
        if (debug.messageEnabled()) {
            debug.message("AMRoleImpl.searchUsers: " + filter);
        }
        searchControl.setSearchScope(2);
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.getOrganizationDN(), filter, sc, returnAttrs);
    }

    public Set getTemplates(Map templateReqs) throws AMException, SSOException {
        return this.getTemplates(templateReqs, false);
    }

    private Set getTemplates(Map templateReqs, boolean policyOnly) throws AMException, SSOException {
        Set set;
        SSOTokenManager.getInstance().validateToken(this.token);
        if (debug.messageEnabled()) {
            debug.message("AMRoleImpl.getTemplate: Map = [" + templateReqs + "] DN=" + this.entryDN);
        }
        if ((set = this.dsServices.search(this.token, this.getParentDN(), "(&(objectclass=costemplate)(cn=\"" + this.entryDN + "\"))", 2)) == null || set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        boolean getAll = false;
        if (templateReqs == null || templateReqs.isEmpty()) {
            getAll = true;
        }
        HashSet<AMTemplateImpl> retSet = new HashSet<AMTemplateImpl>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DN dn = new DN((String)it.next());
            if (debug.messageEnabled()) {
                debug.message("AMRoleImpl.getTemplate: DN=" + dn);
            }
            String serviceName = ((RDN)dn.getParent().getRDNs().get(0)).getValues()[0];
            int templateType = 301;
            if (getAll) {
                if (!policyOnly) {
                    retSet.add(new AMTemplateImpl(this.token, dn.toRFCString(), serviceName, templateType));
                    continue;
                }
                if (templateType != 300) continue;
                retSet.add(new AMTemplateImpl(this.token, dn.toRFCString(), serviceName, templateType));
                continue;
            }
            Integer type = (Integer)templateReqs.get(serviceName);
            if (type == null || type != 303 && type != templateType) continue;
            retSet.add(new AMTemplateImpl(this.token, dn.toRFCString(), serviceName, templateType));
        }
        return retSet;
    }

    public Set getPolicyTemplates(Set serviceNames) throws AMException, SSOException {
        if (serviceNames == null || serviceNames.isEmpty()) {
            return this.getTemplates(null, true);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Iterator it = serviceNames.iterator();
        while (it.hasNext()) {
            map.put((String)it.next(), POLICY_TEMPLATE_INTEGER);
        }
        return this.getTemplates(map, false);
    }

    public Set getAssignedPolicyDNs() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        throw new UnsupportedOperationException();
    }
}

