/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroupImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDynamicGroupImpl;
import com.iplanet.am.sdk.AMEntityImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRoleImpl;
import com.iplanet.am.sdk.AMGroupContainerImpl;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainerImpl;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStaticGroupImpl;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class AMOrganizationalUnitImpl
extends AMObjectImpl
implements AMOrganizationalUnit {
    public AMOrganizationalUnitImpl(SSOToken ssoToken, String DN2) {
        super(ssoToken, DN2, 3);
    }

    public Set createOrganizations(Set organizations) throws AMException, SSOException {
        Iterator iter = organizations.iterator();
        HashSet<AMOrganizationImpl> orgs = new HashSet<AMOrganizationImpl>();
        while (iter.hasNext()) {
            String orgDN = AMNamingAttrManager.getNamingAttr(2) + "=" + (String)iter.next() + "," + this.entryDN;
            AMOrganizationImpl orgImpl = new AMOrganizationImpl(this.token, orgDN);
            orgImpl.create();
            orgs.add(orgImpl);
        }
        return orgs;
    }

    public Set createOrganizations(Map organizationsMap) throws AMException, SSOException {
        Iterator iter = organizationsMap.keySet().iterator();
        HashSet<AMOrganizationImpl> orgs = new HashSet<AMOrganizationImpl>();
        while (iter.hasNext()) {
            String orgName = (String)iter.next();
            String orgDN = AMNamingAttrManager.getNamingAttr(2) + "=" + orgName + "," + this.entryDN;
            Map attributes = (Map)organizationsMap.get(orgName);
            AMOrganizationImpl orgImpl = new AMOrganizationImpl(this.token, orgDN);
            orgImpl.setAttributes(attributes);
            orgImpl.create();
            orgs.add(orgImpl);
        }
        return orgs;
    }

    public void deleteOrganizations(Set organizationDNs) throws AMException, SSOException {
        Iterator iter = organizationDNs.iterator();
        while (iter.hasNext()) {
            String organizationDN = (String)iter.next();
            AMOrganizationImpl org = new AMOrganizationImpl(this.token, organizationDN);
            org.delete();
        }
    }

    public AMOrganization getOrganization(String dn) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return new AMOrganizationImpl(this.token, dn);
    }

    public Set getOrganizations(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(2));
    }

    public long getNumberOfOrganizations(int level) throws AMException, SSOException {
        return this.getOrganizations(level).size();
    }

    public Set searchOrganizations(String wildcard, int level) throws AMException, SSOException {
        return this.searchOrganizations(wildcard, null, level);
    }

    public AMSearchResults searchOrganizations(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchOrganizations(wildcard, null, searchControl);
    }

    public Set searchOrganizations(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(2), this.getSearchFilter(2), wildcard, avPairs, level);
    }

    public AMSearchResults searchOrganizations(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(2), this.getSearchFilter(2), wildcard, avPairs, searchControl);
    }

    public Set createSubOrganizationalUnits(Set subOrganizationalUnits) throws AMException, SSOException {
        Iterator iter = subOrganizationalUnits.iterator();
        HashSet<AMOrganizationalUnitImpl> subOrgUnits = new HashSet<AMOrganizationalUnitImpl>();
        while (iter.hasNext()) {
            String subOrgUnitDN = AMNamingAttrManager.getNamingAttr(3) + "=" + (String)iter.next() + "," + this.entryDN;
            AMOrganizationalUnitImpl subOrgUnitImpl = new AMOrganizationalUnitImpl(this.token, subOrgUnitDN);
            subOrgUnitImpl.create();
            subOrgUnits.add(subOrgUnitImpl);
        }
        return subOrgUnits;
    }

    public Set createSubOrganizationalUnits(Map subOrganizationalUnitsMap) throws AMException, SSOException {
        Iterator iter = subOrganizationalUnitsMap.keySet().iterator();
        HashSet<AMOrganizationalUnitImpl> subOrgUnits = new HashSet<AMOrganizationalUnitImpl>();
        while (iter.hasNext()) {
            String subOrgUnitName = (String)iter.next();
            String subOrgUnitDN = AMNamingAttrManager.getNamingAttr(3) + "=" + subOrgUnitName + "," + this.entryDN;
            Map attributes = (Map)subOrganizationalUnitsMap.get(subOrgUnitName);
            AMOrganizationalUnitImpl subOrgUnitImpl = new AMOrganizationalUnitImpl(this.token, subOrgUnitDN);
            subOrgUnitImpl.setAttributes(attributes);
            subOrgUnitImpl.create();
            subOrgUnits.add(subOrgUnitImpl);
        }
        return subOrgUnits;
    }

    public void deleteSubOrganizationalUnits(Set subOrganizationalUnitDNs) throws AMException, SSOException {
        Iterator iter = subOrganizationalUnitDNs.iterator();
        while (iter.hasNext()) {
            String subOrganizationalUnitDN = (String)iter.next();
            AMOrganizationalUnitImpl subOrgUnit = new AMOrganizationalUnitImpl(this.token, subOrganizationalUnitDN);
            subOrgUnit.delete();
        }
    }

    public AMOrganizationalUnit getSubOrganizationalUnit(String dn) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return new AMOrganizationalUnitImpl(this.token, dn);
    }

    public Set getSubOrganizationalUnits(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(3));
    }

    public long getNumberOfSubOrganizationalUnits(int level) throws AMException, SSOException {
        return this.getSubOrganizationalUnits(level).size();
    }

    public Set searchSubOrganizationalUnits(String wildcard, int level) throws AMException, SSOException {
        return this.searchSubOrganizationalUnits(wildcard, null, level);
    }

    public AMSearchResults searchSubOrganizationalUnits(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchSubOrganizationalUnits(wildcard, null, searchControl);
    }

    public Set searchSubOrganizationalUnits(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(3), this.getSearchFilter(3), wildcard, avPairs, level);
    }

    public AMSearchResults searchSubOrganizationalUnits(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(3), this.getSearchFilter(3), wildcard, avPairs, searchControl);
    }

    public Set createRoles(Set roleNames) throws AMException, SSOException {
        Iterator iter = roleNames.iterator();
        HashSet<AMRoleImpl> roles = new HashSet<AMRoleImpl>();
        while (iter.hasNext()) {
            String roleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + (String)iter.next() + "," + this.entryDN;
            AMRoleImpl roleImpl = new AMRoleImpl(this.token, roleDN);
            roleImpl.create();
            roles.add(roleImpl);
        }
        return roles;
    }

    public Set createRoles(Map roles) throws AMException, SSOException {
        Iterator iter = roles.keySet().iterator();
        HashSet<AMRoleImpl> result = new HashSet<AMRoleImpl>();
        while (iter.hasNext()) {
            String roleName = (String)iter.next();
            String roleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + roleName + "," + this.entryDN;
            Map attributes = (Map)roles.get(roleName);
            AMRoleImpl roleImpl = new AMRoleImpl(this.token, roleDN);
            Set aciSet = null;
            if (!attributes.isEmpty()) {
                aciSet = (Set)attributes.remove("iplanet-am-role-aci-list");
            }
            if (aciSet != null) {
                Iterator iter2 = aciSet.iterator();
                HashSet<String> newAciSet = new HashSet<String>();
                while (iter2.hasNext()) {
                    String acis = (String)iter2.next();
                    StringTokenizer stz = new StringTokenizer(acis, "##");
                    while (stz.hasMoreTokens()) {
                        newAciSet.add(stz.nextToken());
                    }
                }
                attributes.put("iplanet-am-role-aci-list", this.replaceAciListMacros(newAciSet, roleDN, this.entryDN, null, null));
            }
            roleImpl.setAttributes(attributes);
            roleImpl.create();
            result.add(roleImpl);
        }
        return result;
    }

    public void deleteRoles(Set roleDNs) throws AMException, SSOException {
        Iterator iter = roleDNs.iterator();
        while (iter.hasNext()) {
            String roleDN = (String)iter.next();
            AMRoleImpl role = new AMRoleImpl(this.token, roleDN);
            role.delete();
        }
    }

    public Set getRoles(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(6));
    }

    public long getNumberOfRoles(int level) throws AMException, SSOException {
        return this.getRoles(level).size();
    }

    public Set searchRoles(String wildcard, int level) throws AMException, SSOException {
        return this.searchRoles(wildcard, null, level);
    }

    public AMSearchResults searchRoles(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchRoles(wildcard, null, searchControl);
    }

    public Set searchRoles(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(6), this.getSearchFilter(6), wildcard, avPairs, level);
    }

    public AMSearchResults searchRoles(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(6), this.getSearchFilter(6), wildcard, avPairs, searchControl);
    }

    public Set createFilteredRoles(Set roleNames) throws AMException, SSOException {
        Iterator iter = roleNames.iterator();
        HashSet<AMFilteredRoleImpl> roles = new HashSet<AMFilteredRoleImpl>();
        while (iter.hasNext()) {
            String roleName = (String)iter.next();
            String roleDN = AMNamingAttrManager.getNamingAttr(8) + "=" + roleName + "," + this.entryDN;
            AMFilteredRoleImpl roleImpl = new AMFilteredRoleImpl(this.token, roleDN);
            roleImpl.create();
            roles.add(roleImpl);
        }
        return roles;
    }

    public Set createFilteredRoles(Map roles) throws AMException, SSOException {
        Iterator iter = roles.keySet().iterator();
        HashSet<AMFilteredRoleImpl> result = new HashSet<AMFilteredRoleImpl>();
        while (iter.hasNext()) {
            Set aciSet;
            String roleName = (String)iter.next();
            String roleDN = AMNamingAttrManager.getNamingAttr(8) + "=" + roleName + "," + this.entryDN;
            Map attributes = (Map)roles.get(roleName);
            AMFilteredRoleImpl roleImpl = new AMFilteredRoleImpl(this.token, roleDN);
            if (!attributes.isEmpty() && (aciSet = (Set)attributes.remove("iplanet-am-role-aci-list")) != null && !aciSet.isEmpty()) {
                Iterator iter2 = aciSet.iterator();
                HashSet<String> newAciSet = new HashSet<String>();
                while (iter2.hasNext()) {
                    String acis = (String)iter2.next();
                    StringTokenizer stz = new StringTokenizer(acis, "##");
                    while (stz.hasMoreTokens()) {
                        newAciSet.add(stz.nextToken());
                    }
                }
                attributes.put("iplanet-am-role-aci-list", this.replaceAciListMacros(newAciSet, roleDN, this.entryDN, null, null));
            }
            roleImpl.setAttributes(attributes);
            roleImpl.create();
            result.add(roleImpl);
        }
        return result;
    }

    public void deleteFilteredRoles(Set roleDNs) throws AMException, SSOException {
        Iterator iter = roleDNs.iterator();
        while (iter.hasNext()) {
            String roleDN = (String)iter.next();
            AMFilteredRoleImpl role = new AMFilteredRoleImpl(this.token, roleDN);
            role.delete();
        }
    }

    public Set getFilteredRoles(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(8));
    }

    public long getNumberOfFilteredRoles(int level) throws AMException, SSOException {
        return this.getFilteredRoles(level).size();
    }

    public Set searchFilteredRoles(String wildcard, int level) throws AMException, SSOException {
        return this.searchFilteredRoles(wildcard, null, level);
    }

    public AMSearchResults searchFilteredRoles(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchFilteredRoles(wildcard, null, searchControl);
    }

    public Set searchFilteredRoles(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(8), this.getSearchFilter(8), wildcard, avPairs, level);
    }

    public AMSearchResults searchFilteredRoles(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(8), this.getSearchFilter(8), wildcard, avPairs, searchControl);
    }

    public Set searchAllRoles(String wildcard, int level) throws AMException, SSOException {
        return this.searchAllRoles(wildcard, null, level);
    }

    public AMSearchResults searchAllRoles(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchAllRoles(wildcard, null, searchControl);
    }

    public Set searchAllRoles(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        int[] objectTypes = new int[]{6, 8};
        return this.searchObjects(objectTypes, wildcard, avPairs, level);
    }

    public AMSearchResults searchAllRoles(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        int[] objectTypes = new int[]{6, 8};
        return this.searchObjects(objectTypes, wildcard, avPairs, searchControl);
    }

    public Set createAssignableDynamicGroups(Set assignableDynamicGroupNames) throws AMException, SSOException {
        Iterator iter = assignableDynamicGroupNames.iterator();
        HashSet<AMAssignableDynamicGroupImpl> assignableDynamicGroups = new HashSet<AMAssignableDynamicGroupImpl>();
        while (iter.hasNext()) {
            String assignableDynamicGroupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMAssignableDynamicGroupImpl assignableDynamicGroupImpl = new AMAssignableDynamicGroupImpl(this.token, assignableDynamicGroupDN);
            assignableDynamicGroupImpl.create();
            assignableDynamicGroups.add(assignableDynamicGroupImpl);
        }
        return assignableDynamicGroups;
    }

    public void deleteAssignableDynamicGroups(Set assignableDynamicGroupDNs) throws AMException, SSOException {
        Iterator iter = assignableDynamicGroupDNs.iterator();
        while (iter.hasNext()) {
            String assignableDynamicGroupDN = (String)iter.next();
            AMAssignableDynamicGroupImpl assignableDynamicGroup = new AMAssignableDynamicGroupImpl(this.token, assignableDynamicGroupDN);
            assignableDynamicGroup.delete();
        }
    }

    public Set getAssignableDynamicGroups(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(12));
    }

    public long getNumberOfAssignableDynamicGroups(int level) throws AMException, SSOException {
        return this.getAssignableDynamicGroups(level).size();
    }

    public Set searchAssignableDynamicGroups(String wildcard, int level) throws AMException, SSOException {
        return this.searchAssignableDynamicGroups(wildcard, null, level);
    }

    public AMSearchResults searchAssignableDynamicGroups(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchAssignableDynamicGroups(wildcard, null, searchControl);
    }

    public Set searchAssignableDynamicGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12), wildcard, avPairs, level);
    }

    public AMSearchResults searchAssignableDynamicGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12), wildcard, avPairs, searchControl);
    }

    public Set createDynamicGroups(Map dynamicGroups) throws AMException, SSOException {
        Iterator iter = dynamicGroups.keySet().iterator();
        HashSet<AMDynamicGroupImpl> groups = new HashSet<AMDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)dynamicGroups.get(groupName);
            AMDynamicGroupImpl groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public void deleteDynamicGroups(Set dynamicGroupDNs) throws AMException, SSOException {
        Iterator iter = dynamicGroupDNs.iterator();
        while (iter.hasNext()) {
            String dynamicGroupDN = (String)iter.next();
            AMDynamicGroupImpl dynamicGroup = new AMDynamicGroupImpl(this.token, dynamicGroupDN);
            dynamicGroup.delete();
        }
    }

    public Set getDynamicGroups(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(11));
    }

    public long getNumberOfDynamicGroups(int level) throws AMException, SSOException {
        return this.getDynamicGroups(level).size();
    }

    public Set searchDynamicGroups(String wildcard, int level) throws AMException, SSOException {
        return this.searchDynamicGroups(wildcard, null, level);
    }

    public AMSearchResults searchDynamicGroups(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchDynamicGroups(wildcard, null, searchControl);
    }

    public Set searchDynamicGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11), wildcard, avPairs, level);
    }

    public AMSearchResults searchDynamicGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11), wildcard, avPairs, searchControl);
    }

    public Set createStaticGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMStaticGroupImpl> groups = new HashSet<AMStaticGroupImpl>();
        while (iter.hasNext()) {
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMStaticGroupImpl groupImpl = new AMStaticGroupImpl(this.token, groupDN);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public void deleteStaticGroups(Set groupDNs) throws AMException, SSOException {
        Iterator iter = groupDNs.iterator();
        while (iter.hasNext()) {
            String groupDN = (String)iter.next();
            AMStaticGroupImpl group = new AMStaticGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public Set getStaticGroups(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(9));
    }

    public long getNumberOfStaticGroups(int level) throws AMException, SSOException {
        return this.getStaticGroups(level).size();
    }

    public Set searchStaticGroups(String wildcard, int level) throws AMException, SSOException {
        return this.searchStaticGroups(wildcard, null, level);
    }

    public AMSearchResults searchStaticGroups(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchStaticGroups(wildcard, null, searchControl);
    }

    public Set searchStaticGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9), wildcard, avPairs, level);
    }

    public AMSearchResults searchStaticGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9), wildcard, avPairs, searchControl);
    }

    public Set searchGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, level);
    }

    public AMSearchResults searchGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, searchControl);
    }

    public Set createPeopleContainers(Set peopleContainerNames) throws AMException, SSOException {
        Iterator iter = peopleContainerNames.iterator();
        HashSet<AMPeopleContainerImpl> peopleContainers = new HashSet<AMPeopleContainerImpl>();
        while (iter.hasNext()) {
            String peopleContainerDN = AMNamingAttrManager.getNamingAttr(5) + "=" + (String)iter.next() + "," + this.entryDN;
            AMPeopleContainerImpl peopleContainerImpl = new AMPeopleContainerImpl(this.token, peopleContainerDN);
            peopleContainerImpl.create();
            peopleContainers.add(peopleContainerImpl);
        }
        return peopleContainers;
    }

    public Set createPeopleContainers(Map peopleContainersMap) throws AMException, SSOException {
        Iterator iter = peopleContainersMap.keySet().iterator();
        HashSet<AMPeopleContainerImpl> peopleContainers = new HashSet<AMPeopleContainerImpl>();
        while (iter.hasNext()) {
            String peopleContainerName = (String)iter.next();
            String peopleContainerDN = AMNamingAttrManager.getNamingAttr(5) + "=" + peopleContainerName + "," + this.entryDN;
            Map attributes = (Map)peopleContainersMap.get(peopleContainerName);
            AMPeopleContainerImpl peopleContainerImpl = new AMPeopleContainerImpl(this.token, peopleContainerDN);
            peopleContainerImpl.setAttributes(attributes);
            peopleContainerImpl.create();
            peopleContainers.add(peopleContainerImpl);
        }
        return peopleContainers;
    }

    public void deletePeopleContainers(Set peopleContainerDNs) throws AMException, SSOException {
        Iterator iter = peopleContainerDNs.iterator();
        while (iter.hasNext()) {
            String peopleContainerDN = (String)iter.next();
            AMPeopleContainerImpl peopleContainer = new AMPeopleContainerImpl(this.token, peopleContainerDN);
            peopleContainer.delete();
        }
    }

    public Set getPeopleContainers(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(5));
    }

    public long getNumberOfPeopleContainers(int level) throws AMException, SSOException {
        return this.getPeopleContainers(level).size();
    }

    public Set searchPeopleContainers(String wildcard, int level) throws AMException, SSOException {
        return this.searchPeopleContainers(wildcard, null, level);
    }

    public AMSearchResults searchPeopleContainers(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchPeopleContainers(wildcard, null, searchControl);
    }

    public Set searchPeopleContainers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(5), this.getSearchFilter(5), wildcard, avPairs, level);
    }

    public AMSearchResults searchPeopleContainers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(5), this.getSearchFilter(5), wildcard, avPairs, searchControl);
    }

    public Set createGroupContainers(Set groupContainerNames) throws AMException, SSOException {
        Iterator iter = groupContainerNames.iterator();
        HashSet<AMGroupContainerImpl> groupContainers = new HashSet<AMGroupContainerImpl>();
        while (iter.hasNext()) {
            String groupContainerDN = AMNamingAttrManager.getNamingAttr(4) + "=" + (String)iter.next() + "," + this.entryDN;
            AMGroupContainerImpl groupContainerImpl = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainerImpl.create();
            groupContainers.add(groupContainerImpl);
        }
        return groupContainers;
    }

    public Set createGroupContainers(Map groupContainersMap) throws AMException, SSOException {
        Iterator iter = groupContainersMap.keySet().iterator();
        HashSet<AMGroupContainerImpl> groupContainers = new HashSet<AMGroupContainerImpl>();
        while (iter.hasNext()) {
            String groupContainerName = (String)iter.next();
            String groupContainerDN = AMNamingAttrManager.getNamingAttr(4) + "=" + groupContainerName + "," + this.entryDN;
            Map attributes = (Map)groupContainersMap.get(groupContainerName);
            AMGroupContainerImpl groupContainerImpl = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainerImpl.setAttributes(attributes);
            groupContainerImpl.create();
            groupContainers.add(groupContainerImpl);
        }
        return groupContainers;
    }

    public void deleteGroupContainers(Set groupContainerDNs) throws AMException, SSOException {
        Iterator iter = groupContainerDNs.iterator();
        while (iter.hasNext()) {
            String groupContainerDN = (String)iter.next();
            AMGroupContainerImpl groupContainer = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainer.delete();
        }
    }

    public Set getGroupContainers(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(4));
    }

    public long getNumberOfGroupContainers(int level) throws AMException, SSOException {
        return this.getGroupContainers(level).size();
    }

    public Set searchGroupContainers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), wildcard, avPairs, level);
    }

    public AMSearchResults searchGroupContainers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), wildcard, avPairs, searchControl);
    }

    public Set createUsers(Set userNames) throws AMException, SSOException {
        HashSet<AMUserImpl> usersSet = new HashSet<AMUserImpl>();
        Set serviceNames = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
        }
        Iterator iter = userNames.iterator();
        while (iter.hasNext()) {
            String userDN = AMNamingAttrManager.getNamingAttr(1) + "=" + (String)iter.next() + "," + this.entryDN;
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            if (objectClasses != null && !objectClasses.isEmpty()) {
                user.setAttribute("objectclass", objectClasses);
            }
            user.create();
            usersSet.add(user);
        }
        return usersSet;
    }

    public Set createUsers(Map usersMap) throws AMException, SSOException {
        HashSet<AMUserImpl> usersSet = new HashSet<AMUserImpl>();
        Set serviceNames = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
        }
        Iterator iter = usersMap.keySet().iterator();
        while (iter.hasNext()) {
            String userName = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(1) + "=" + userName + "," + this.entryDN;
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            Map userMap = (Map)usersMap.get(userName);
            user.setAttributes(userMap);
            if (objectClasses != null && !objectClasses.isEmpty()) {
                Set existingOC = (Set)userMap.get("objectclass");
                if (existingOC != null && !existingOC.isEmpty()) {
                    objectClasses.addAll(existingOC);
                }
                user.setAttribute("objectclass", objectClasses);
            }
            user.create();
            usersSet.add(user);
        }
        return usersSet;
    }

    public void deleteUsers(Set users) throws AMException, SSOException {
        Iterator iter = users.iterator();
        while (iter.hasNext()) {
            String userDN = (String)iter.next();
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            user.delete();
        }
    }

    public Set getUserDNs() throws AMException, SSOException {
        return this.search(1, this.getSearchFilter(1));
    }

    public long getNumberOfUsers(int level) throws AMException, SSOException {
        return this.getUsers(level).size();
    }

    public Set searchUsers(String wildcard, int level) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, level);
    }

    public AMSearchResults searchUsers(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, searchControl);
    }

    public Set searchUsers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, avPairs, level);
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, avPairs, searchControl);
    }

    public AMSearchResults searchUsers(String wildcard, AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, searchControl, avfilter);
    }

    public AMSearchResults searchUsers(AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        return this.searchObjects(this.getSearchFilter(1), searchControl, avfilter);
    }

    public long getNumberOfServices() throws AMException, SSOException {
        return this.getRegisteredServiceNames().size();
    }

    public Set getRegisteredServiceNames() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return this.dsServices.getRegisteredServiceNames(this.token, this.entryDN);
    }

    public void registerService(String serviceName, boolean createTemplate, boolean activate) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMOrganizationalUnitImpl.registerService(" + serviceName + ", " + createTemplate + ", " + activate + ")");
        }
        this.dsServices.registerService(this.token, this.entryDN, serviceName);
        HashSet<String> serviceStatus = this.getAttribute("sunRegisteredServiceName");
        if (!((Object)serviceStatus).equals(Collections.EMPTY_SET)) {
            Iterator iter = serviceStatus.iterator();
            while (iter.hasNext()) {
                String status = (String)iter.next();
                if (!status.equalsIgnoreCase(serviceName)) continue;
                Object[] args = new Object[]{serviceName};
                throw new AMException(AMSDKBundle.getString("464", args, this.locale), "464", args);
            }
        } else {
            serviceStatus = new HashSet<String>();
        }
        serviceStatus.add(serviceName);
        this.setAttribute("sunRegisteredServiceName", serviceStatus);
        try {
            this.store();
        }
        catch (AMException le) {
            try {
                Set objectClass = this.getAttribute("objectclass");
                if (debug.messageEnabled()) {
                    debug.message("object class=" + objectClass);
                }
                if (objectClass.contains("iplanet-am-managed-org-unit")) {
                    throw le;
                }
                objectClass.add("iplanet-am-managed-org-unit");
                this.setAttribute("objectclass", objectClass);
                this.setAttribute("sunRegisteredServiceName", serviceStatus);
                this.store();
            }
            catch (Exception e) {
                if (debug.messageEnabled()) {
                    debug.message("error adding objectclass", e);
                }
                throw le;
            }
        }
        if (createTemplate) {
            try {
                if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.POLICY)) {
                    this.createTemplate(300, serviceName, null);
                }
                if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.DYNAMIC)) {
                    this.createTemplate(301, serviceName, null);
                }
            }
            catch (SMSException smsex) {
                throw new AMException(AMSDKBundle.getString("451", this.locale), "451");
            }
        }
    }

    public void unregisterService(String serviceName) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMOrganizationalUnitImpl.unregisterService(" + serviceName + ")");
        }
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.isRegisteredForSubOrgs(serviceName)) {
            Object[] args = new Object[]{serviceName};
            throw new AMException(AMSDKBundle.getString("445", args, this.locale), "445", args);
        }
        try {
            if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.DYNAMIC)) {
                this.dsServices.unRegisterService(this.token, this.entryDN, this.profileType, serviceName, 301);
            }
            if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.ORGANIZATION) && this.orgTemplateExists(serviceName)) {
                AMTemplate template = this.getTemplate(serviceName, 302);
                template.delete();
            }
            Set serviceStatus = this.getAttribute("sunRegisteredServiceName");
            Iterator iter = serviceStatus.iterator();
            while (iter.hasNext()) {
                String status = (String)iter.next();
                if (!status.equalsIgnoreCase(serviceName)) continue;
                serviceStatus.remove(status);
                this.setAttribute("sunRegisteredServiceName", serviceStatus);
                this.store();
                return;
            }
            Object[] args = new Object[]{serviceName};
            throw new AMException(AMSDKBundle.getString("463", args, this.locale), "463", args);
        }
        catch (SMSException smsex) {
            Object[] args = new Object[]{serviceName};
            throw new AMException(AMSDKBundle.getString("913", args, this.locale), "913", args);
        }
    }

    public Set getUsers(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(1));
    }

    public void unassignAllPolicies(String serviceName, Set policyDNs) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public void modifyAllPolicyTemplates(String serviceName, Set policyDNs) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public boolean deleteAllNamedPolicyTemplates(String policyDN) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public Set getAssignedPolicyDNs() throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public boolean isPolicyAssigned(String policyDN, String serviceName) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public boolean orgTemplateExists(String serviceName) throws AMException, SSOException {
        ServiceConfig sc = AMServiceUtils.getOrgConfig(this.token, this.entryDN, serviceName);
        return sc != null;
    }

    public void assignService(String serviceName, Map attrMap) throws AMException, SSOException {
    }

    protected Set getOrgTypeAttributes(String serviceName, String attrName) throws SSOException {
        Set attrValues = null;
        try {
            AMTemplate amTemplate = this.getTemplate(serviceName, 302);
            attrValues = amTemplate.getAttribute(attrName);
            if (debug.messageEnabled()) {
                debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org template " + serviceName + " : " + attrName + "\n" + this.entryDN + " : " + attrValues);
            }
        }
        catch (AMException ame) {
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(this.token, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                attrValues = (Set)defaultValues.get(attrName);
                if (debug.messageEnabled()) {
                    debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org defaults " + serviceName + " : " + attrName + "\n" + this.entryDN + " : " + attrValues);
                }
            }
            catch (Exception se) {
                debug.warning("AMOrganizationImpl.getOrgTypeAttributes(): Error encountered in retrieving default org attrs for", se);
            }
        }
        return attrValues;
    }

    private boolean isRegisteredForSubOrgs(String serviceName) throws SSOException {
        HashMap avPair = new HashMap();
        HashSet<String> value = new HashSet<String>();
        value.add(serviceName);
        avPair.put("sunRegisteredServiceName", value);
        Set subOrgs = null;
        try {
            subOrgs = this.searchSubOrganizationalUnits("*", avPair, 2);
        }
        catch (AMException ae) {
            // empty catch block
        }
        return subOrgs != null && !subOrgs.isEmpty() && subOrgs.size() > 1;
    }

    public Set createEntities(String stype, Set entities) throws AMException, SSOException {
        if (stype.equalsIgnoreCase("user")) {
            Set uSet = this.createUsers(entities);
            HashSet<AMEntityImpl> resultSet = new HashSet<AMEntityImpl>();
            Iterator it = uSet.iterator();
            while (it.hasNext()) {
                AMUser u = (AMUser)it.next();
                AMEntityImpl e = new AMEntityImpl(this.token, u.getDN());
                resultSet.add(e);
            }
            return resultSet;
        }
        String type = (String)AMCommonUtils.supportedTypes.get(stype.toLowerCase());
        if (type == null) {
            throw new AMException(AMSDKBundle.getString("117", this.locale), "117");
        }
        HashSet<AMEntityImpl> resultSet = new HashSet<AMEntityImpl>();
        int createType = Integer.parseInt(type);
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            String rDN = (String)it.next();
            String userDN = AMNamingAttrManager.getNamingAttr(createType) + "=" + rDN + "," + this.entryDN;
            AMEntityImpl user = new AMEntityImpl(this.token, userDN);
            user.create(stype);
            resultSet.add(user);
        }
        return resultSet;
    }

    public void deleteEntities(Set resources) throws AMException, SSOException {
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            String rDN = (String)iter.next();
            AMEntityImpl resource = new AMEntityImpl(this.token, rDN);
            resource.delete();
        }
    }

    public Set searchEntities(String wildcard, int level, String eSearchTemplate, Map avPairs) throws AMException, SSOException {
        if (eSearchTemplate == null) {
            eSearchTemplate = "BasicEntitySearch";
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, eSearchTemplate), wildcard, avPairs, level);
    }

    public AMSearchResults searchEntities(String wildcard, Map avPairs, String eSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        if (eSearchTemplate == null) {
            eSearchTemplate = "BasicEntitySearch";
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, eSearchTemplate), wildcard, avPairs, searchControl);
    }

    public Set createEntities(String stype, Map entities) throws AMException, SSOException {
        if (stype.equalsIgnoreCase("user")) {
            Set uSet = this.createUsers(entities);
            HashSet<AMEntityImpl> resultSet = new HashSet<AMEntityImpl>();
            Iterator it = uSet.iterator();
            while (it.hasNext()) {
                AMUser u = (AMUser)it.next();
                AMEntityImpl e = new AMEntityImpl(this.token, u.getDN());
                resultSet.add(e);
            }
            return resultSet;
        }
        String type = (String)AMCommonUtils.supportedTypes.get(stype.toLowerCase());
        if (type == null) {
            throw new AMException(AMSDKBundle.getString("117", this.locale), "117");
        }
        int createType = Integer.parseInt(type);
        HashSet<AMEntityImpl> entitySet = new HashSet<AMEntityImpl>();
        Iterator iter = entities.keySet().iterator();
        while (iter.hasNext()) {
            String userName = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(createType) + "=" + userName + "," + this.entryDN;
            AMEntityImpl user = new AMEntityImpl(this.token, userDN);
            Map userMap = (Map)entities.get(userName);
            user.setAttributes(userMap);
            user.create(stype);
            entitySet.add(user);
        }
        return entitySet;
    }

    public AMSearchResults searchEntities(String wildcard, AMSearchControl searchControl, String avfilter, String eSearchTemplate) throws AMException, SSOException {
        if (eSearchTemplate == null) {
            eSearchTemplate = "BasicEntitySearch";
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, eSearchTemplate), wildcard, searchControl, avfilter);
    }

    public Set getSupportedTypes() throws AMException, SSOException {
        return this.getAttribute("sunIdentityServerSupportedTypes");
    }

    public void setSupportedTypes(Set sTypes) throws AMException, SSOException {
        this.setAttribute("sunIdentityServerSupportedTypes", sTypes);
        this.store();
    }
}

