/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroupImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDynamicGroupImpl;
import com.iplanet.am.sdk.AMEntityImpl;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRoleImpl;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainerImpl;
import com.iplanet.am.sdk.AMGroupImpl;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMOrganizationalUnitImpl;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMPeopleContainerImpl;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStaticGroupImpl;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class AMOrganizationImpl
extends AMObjectImpl
implements AMOrganization {
    static String statusAN = "inetDomainStatus";

    public AMOrganizationImpl(SSOToken ssoToken, String DN2) {
        super(ssoToken, DN2, 2);
    }

    public Set createSubOrganizations(Set subOrganizations) throws AMException, SSOException {
        Iterator iter = subOrganizations.iterator();
        HashSet<AMOrganizationImpl> subOrgs = new HashSet<AMOrganizationImpl>();
        while (iter.hasNext()) {
            StringBuffer subOrgDNSB = new StringBuffer();
            subOrgDNSB.append(AMNamingAttrManager.getNamingAttr(2)).append("=").append((String)iter.next()).append(",").append(this.entryDN);
            AMOrganizationImpl subOrgImpl = new AMOrganizationImpl(this.token, subOrgDNSB.toString());
            subOrgImpl.create();
            subOrgs.add(subOrgImpl);
        }
        return subOrgs;
    }

    public Set createSubOrganizations(Map subOrganizationsMap) throws AMException, SSOException {
        Iterator iter = subOrganizationsMap.keySet().iterator();
        HashSet<AMOrganizationImpl> subOrgs = new HashSet<AMOrganizationImpl>();
        while (iter.hasNext()) {
            String subOrgName = (String)iter.next();
            StringBuffer subOrgDNSB = new StringBuffer();
            subOrgDNSB.append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(subOrgName).append(",").append(this.entryDN);
            Map attributes = (Map)subOrganizationsMap.get(subOrgName);
            AMOrganizationImpl subOrgImpl = new AMOrganizationImpl(this.token, subOrgDNSB.toString());
            subOrgImpl.setAttributes(attributes);
            subOrgImpl.create();
            subOrgs.add(subOrgImpl);
        }
        return subOrgs;
    }

    public String createOrganization(String orgName, String domainName, Map attrMap, Map serviceNamesAndAttrs) throws AMException, SSOException {
        String subOrgName = orgName;
        StringBuffer subOrgDNSB = new StringBuffer();
        subOrgDNSB.append(AMNamingAttrManager.getNamingAttr(2));
        subOrgDNSB.append("=").append(subOrgName).append(",");
        subOrgDNSB.append(this.entryDN);
        AMOrganizationImpl subOrgImpl = new AMOrganizationImpl(this.token, subOrgDNSB.toString());
        HashSet<String> domSet = new HashSet<String>();
        domSet.add(domainName);
        if (attrMap == null) {
            attrMap = new HashMap();
        }
        attrMap.put("sunPreferredDomain", domSet);
        subOrgImpl.setAttributes(attrMap);
        if (serviceNamesAndAttrs != null && !serviceNamesAndAttrs.isEmpty()) {
            Set sNames = serviceNamesAndAttrs.keySet();
            subOrgImpl.setAttribute("sunRegisteredServiceName", sNames);
            subOrgImpl.assignServices(serviceNamesAndAttrs, false);
        }
        subOrgImpl.create();
        return subOrgImpl.getDN();
    }

    public void deleteSubOrganizations(Set subOrganizationDNs) throws AMException, SSOException {
        Iterator iter = subOrganizationDNs.iterator();
        while (iter.hasNext()) {
            String subOrganizationDN = (String)iter.next();
            AMOrganizationImpl org = new AMOrganizationImpl(this.token, subOrganizationDN);
            org.delete();
        }
    }

    public AMOrganization getSubOrganization(String dn) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return new AMOrganizationImpl(this.token, dn);
    }

    public Set getSubOrganizations(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(2));
    }

    public long getNumberOfSubOrganizations(int level) throws AMException, SSOException {
        return this.getSubOrganizations(level).size();
    }

    public Set searchSubOrganizations(String wildcard, int level) throws AMException, SSOException {
        return this.searchSubOrganizations(wildcard, null, level);
    }

    public AMSearchResults searchSubOrganizations(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchSubOrganizations(wildcard, null, searchControl);
    }

    public Set searchSubOrganizations(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(2), this.getSearchFilter(2), wildcard, avPairs, level);
    }

    public AMSearchResults searchSubOrganizations(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(2), this.getSearchFilter(2), wildcard, avPairs, searchControl);
    }

    public Set createOrganizationalUnits(Set organizationalUnits) throws AMException, SSOException {
        Iterator iter = organizationalUnits.iterator();
        HashSet<AMOrganizationalUnitImpl> orgUnits = new HashSet<AMOrganizationalUnitImpl>();
        while (iter.hasNext()) {
            String orgUnitDN = AMNamingAttrManager.getNamingAttr(3) + "=" + (String)iter.next() + "," + this.entryDN;
            AMOrganizationalUnitImpl orgUnitImpl = new AMOrganizationalUnitImpl(this.token, orgUnitDN);
            orgUnitImpl.create();
            orgUnits.add(orgUnitImpl);
        }
        return orgUnits;
    }

    public Set createOrganizationalUnits(Map organizationalUnitsMap) throws AMException, SSOException {
        Iterator iter = organizationalUnitsMap.keySet().iterator();
        HashSet<AMOrganizationalUnitImpl> orgUnits = new HashSet<AMOrganizationalUnitImpl>();
        while (iter.hasNext()) {
            String orgUnitName = (String)iter.next();
            String orgUnitDN = AMNamingAttrManager.getNamingAttr(3) + "=" + orgUnitName + "," + this.entryDN;
            Map attributes = (Map)organizationalUnitsMap.get(orgUnitName);
            AMOrganizationalUnitImpl orgUnitImpl = new AMOrganizationalUnitImpl(this.token, orgUnitDN);
            orgUnitImpl.setAttributes(attributes);
            orgUnitImpl.create();
            orgUnits.add(orgUnitImpl);
        }
        return orgUnits;
    }

    public void deleteOrganizationalUnits(Set organizationalUnitDNs) throws AMException, SSOException {
        Iterator iter = organizationalUnitDNs.iterator();
        while (iter.hasNext()) {
            String organizationalUnitDN = (String)iter.next();
            AMOrganizationalUnitImpl orgUnit = new AMOrganizationalUnitImpl(this.token, organizationalUnitDN);
            orgUnit.delete();
        }
    }

    public AMOrganizationalUnit getOrganizationalUnit(String dn) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return new AMOrganizationalUnitImpl(this.token, dn);
    }

    public Set getOrganizationalUnits(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(3));
    }

    public long getNumberOfOrganizationalUnits(int level) throws AMException, SSOException {
        return this.getOrganizationalUnits(level).size();
    }

    public Set searchOrganizationalUnits(String wildcard, int level) throws AMException, SSOException {
        return this.searchOrganizationalUnits(wildcard, null, level);
    }

    public AMSearchResults searchOrganizationalUnits(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchOrganizationalUnits(wildcard, null, searchControl);
    }

    public Set searchOrganizationalUnits(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(3), this.getSearchFilter(3), wildcard, avPairs, level);
    }

    public AMSearchResults searchOrganizationalUnits(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(3), this.getSearchFilter(3), wildcard, avPairs, searchControl);
    }

    public Set createRoles(Set roleNames) throws AMException, SSOException {
        Iterator iter = roleNames.iterator();
        HashSet<AMRoleImpl> roles = new HashSet<AMRoleImpl>();
        while (iter.hasNext()) {
            StringBuffer roleDNSB = new StringBuffer();
            roleDNSB.append(AMNamingAttrManager.getNamingAttr(6)).append("=").append((String)iter.next()).append(",").append(this.entryDN);
            AMRoleImpl roleImpl = new AMRoleImpl(this.token, roleDNSB.toString());
            roleImpl.create();
            roles.add(roleImpl);
        }
        return roles;
    }

    public Set createRoles(Map roles) throws AMException, SSOException {
        Iterator iter = roles.keySet().iterator();
        HashSet<AMRoleImpl> result = new HashSet<AMRoleImpl>();
        while (iter.hasNext()) {
            String roleName = (String)iter.next();
            String roleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + roleName + "," + this.entryDN;
            Map attributes = (Map)roles.get(roleName);
            AMRoleImpl roleImpl = new AMRoleImpl(this.token, roleDN);
            Set aciSet = new HashSet();
            if (!attributes.isEmpty()) {
                aciSet = (Set)attributes.remove("iplanet-am-role-aci-list");
            }
            if (aciSet != null && !aciSet.isEmpty()) {
                Iterator iter2 = aciSet.iterator();
                HashSet<String> newAciSet = new HashSet<String>();
                while (iter2.hasNext()) {
                    String acis = (String)iter2.next();
                    StringTokenizer stz = new StringTokenizer(acis, "##");
                    while (stz.hasMoreTokens()) {
                        newAciSet.add(stz.nextToken());
                    }
                }
                attributes.put("iplanet-am-role-aci-list", this.replaceAciListMacros(newAciSet, roleDN, this.entryDN, null, null));
            }
            roleImpl.setAttributes(attributes);
            roleImpl.create();
            result.add(roleImpl);
        }
        return result;
    }

    public void deleteRoles(Set roleDNs) throws AMException, SSOException {
        Iterator iter = roleDNs.iterator();
        while (iter.hasNext()) {
            String roleDN = (String)iter.next();
            AMRoleImpl role = new AMRoleImpl(this.token, roleDN);
            role.delete();
        }
    }

    public Set getRoles(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(6));
    }

    public long getNumberOfRoles(int level) throws AMException, SSOException {
        return this.getRoles(level).size();
    }

    public Set searchRoles(String wildcard, int level) throws AMException, SSOException {
        return this.searchRoles(wildcard, null, level);
    }

    public AMSearchResults searchRoles(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchRoles(wildcard, null, searchControl);
    }

    public Set searchRoles(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(6), this.getSearchFilter(6), wildcard, avPairs, level);
    }

    public AMSearchResults searchRoles(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(6), this.getSearchFilter(6), wildcard, avPairs, searchControl);
    }

    public Set createFilteredRoles(Set roleNames) throws AMException, SSOException {
        Iterator iter = roleNames.iterator();
        HashSet<AMFilteredRoleImpl> roles = new HashSet<AMFilteredRoleImpl>();
        while (iter.hasNext()) {
            String roleName = (String)iter.next();
            String roleDN = AMNamingAttrManager.getNamingAttr(8) + "=" + roleName + "," + this.entryDN;
            AMFilteredRoleImpl roleImpl = new AMFilteredRoleImpl(this.token, roleDN);
            roleImpl.create();
            roles.add(roleImpl);
        }
        return roles;
    }

    public Set createFilteredRoles(Map roles) throws AMException, SSOException {
        Iterator iter = roles.keySet().iterator();
        HashSet<AMFilteredRoleImpl> result = new HashSet<AMFilteredRoleImpl>();
        while (iter.hasNext()) {
            Set aciSet;
            String roleName = (String)iter.next();
            String roleDN = AMNamingAttrManager.getNamingAttr(8) + "=" + roleName + "," + this.entryDN;
            Map attributes = (Map)roles.get(roleName);
            AMFilteredRoleImpl roleImpl = new AMFilteredRoleImpl(this.token, roleDN);
            if (!attributes.isEmpty() && (aciSet = (Set)attributes.remove("iplanet-am-role-aci-list")) != null && !aciSet.isEmpty()) {
                Iterator iter2 = aciSet.iterator();
                HashSet<String> newAciSet = new HashSet<String>();
                while (iter2.hasNext()) {
                    String acis = (String)iter2.next();
                    StringTokenizer stz = new StringTokenizer(acis, "##");
                    while (stz.hasMoreTokens()) {
                        newAciSet.add(stz.nextToken());
                    }
                }
                attributes.put("iplanet-am-role-aci-list", this.replaceAciListMacros(newAciSet, roleDN, this.entryDN, null, null));
            }
            roleImpl.setAttributes(attributes);
            roleImpl.create();
            result.add(roleImpl);
        }
        return result;
    }

    public void deleteFilteredRoles(Set roleDNs) throws AMException, SSOException {
        Iterator iter = roleDNs.iterator();
        while (iter.hasNext()) {
            String roleDN = (String)iter.next();
            AMFilteredRoleImpl role = new AMFilteredRoleImpl(this.token, roleDN);
            role.delete();
        }
    }

    public Set getFilteredRoles(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(8));
    }

    public long getNumberOfFilteredRoles(int level) throws AMException, SSOException {
        return this.getFilteredRoles(level).size();
    }

    public Set searchFilteredRoles(String wildcard, int level) throws AMException, SSOException {
        return this.searchFilteredRoles(wildcard, null, level);
    }

    public AMSearchResults searchFilteredRoles(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchFilteredRoles(wildcard, null, searchControl);
    }

    public Set searchFilteredRoles(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(8), this.getSearchFilter(8), wildcard, avPairs, level);
    }

    public AMSearchResults searchFilteredRoles(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(8), this.getSearchFilter(8), wildcard, avPairs, searchControl);
    }

    public Set searchAllRoles(String wildcard, int level) throws AMException, SSOException {
        return this.searchAllRoles(wildcard, null, level);
    }

    public AMSearchResults searchAllRoles(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchAllRoles(wildcard, null, searchControl);
    }

    public Set searchAllRoles(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        int[] objectTypes = new int[]{6, 8};
        return this.searchObjects(objectTypes, wildcard, avPairs, level);
    }

    public AMSearchResults searchAllRoles(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        int[] objectTypes = new int[]{6, 8};
        return this.searchObjects(objectTypes, wildcard, avPairs, searchControl);
    }

    public Set createAssignableDynamicGroups(Set assignableDynamicGroupNames) throws AMException, SSOException {
        Iterator iter = assignableDynamicGroupNames.iterator();
        HashSet<AMAssignableDynamicGroupImpl> assignableDynamicGroups = new HashSet<AMAssignableDynamicGroupImpl>();
        while (iter.hasNext()) {
            String assignableDynamicGroupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMAssignableDynamicGroupImpl assignableDynamicGroupImpl = new AMAssignableDynamicGroupImpl(this.token, assignableDynamicGroupDN);
            assignableDynamicGroupImpl.create();
            assignableDynamicGroups.add(assignableDynamicGroupImpl);
        }
        return assignableDynamicGroups;
    }

    public AMGroup createAssignableDynamicGroup(String name, Map attributes, Map serviceNameAndAttrs) throws AMException, SSOException {
        return this.createGroup(name, attributes, serviceNameAndAttrs, 12);
    }

    public void deleteAssignableDynamicGroups(Set assignableDynamicGroupDNs) throws AMException, SSOException {
        Iterator iter = assignableDynamicGroupDNs.iterator();
        while (iter.hasNext()) {
            String assignableDynamicGroupDN = (String)iter.next();
            AMAssignableDynamicGroupImpl assignableDynamicGroup = new AMAssignableDynamicGroupImpl(this.token, assignableDynamicGroupDN);
            assignableDynamicGroup.delete();
        }
    }

    public Set getAssignableDynamicGroups(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(12));
    }

    public long getNumberOfAssignableDynamicGroups(int level) throws AMException, SSOException {
        return this.getAssignableDynamicGroups(level).size();
    }

    public Set searchAssignableDynamicGroups(String wildcard, int level) throws AMException, SSOException {
        return this.searchAssignableDynamicGroups(wildcard, null, level);
    }

    public Set searchAssignableDynamicGroups(String wildcard, int level, String groupSearchTemplate, Map avPairs) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (debug.warningEnabled()) {
                debug.warning("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12, groupSearchTemplate), wildcard, avPairs, level);
    }

    public AMSearchResults searchAssignableDynamicGroups(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchAssignableDynamicGroups(wildcard, null, searchControl);
    }

    public Set searchAssignableDynamicGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12), wildcard, avPairs, level);
    }

    public AMSearchResults searchAssignableDynamicGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12), wildcard, avPairs, searchControl);
    }

    public Set createDynamicGroups(Map dynamicGroups) throws AMException, SSOException {
        Iterator iter = dynamicGroups.keySet().iterator();
        HashSet<AMDynamicGroupImpl> groups = new HashSet<AMDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)dynamicGroups.get(groupName);
            AMDynamicGroupImpl groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public AMGroup createDynamicGroup(String name, Map attributes, Map serviceNameAndAttrs) throws AMException, SSOException {
        return this.createGroup(name, attributes, serviceNameAndAttrs, 11);
    }

    public void deleteDynamicGroups(Set dynamicGroupDNs) throws AMException, SSOException {
        Iterator iter = dynamicGroupDNs.iterator();
        while (iter.hasNext()) {
            String dynamicGroupDN = (String)iter.next();
            AMDynamicGroupImpl dynamicGroup = new AMDynamicGroupImpl(this.token, dynamicGroupDN);
            dynamicGroup.delete();
        }
    }

    public Set getDynamicGroups(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(11));
    }

    public long getNumberOfDynamicGroups(int level) throws AMException, SSOException {
        return this.getDynamicGroups(level).size();
    }

    public Set searchDynamicGroups(String wildcard, int level) throws AMException, SSOException {
        return this.searchDynamicGroups(wildcard, null, level);
    }

    public Set searchDynamicGroups(String wildcard, int level, String groupSearchTemplate, Map avPairs) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (debug.warningEnabled()) {
                debug.warning("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11, groupSearchTemplate), wildcard, avPairs, level);
    }

    public AMSearchResults searchDynamicGroups(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchDynamicGroups(wildcard, null, searchControl);
    }

    public Set searchDynamicGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11), wildcard, avPairs, level);
    }

    public AMSearchResults searchDynamicGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11), wildcard, avPairs, searchControl);
    }

    public Set createStaticGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMStaticGroupImpl> groups = new HashSet<AMStaticGroupImpl>();
        while (iter.hasNext()) {
            StringBuffer groupDNSB = new StringBuffer();
            groupDNSB.append(AMNamingAttrManager.getNamingAttr(9)).append("=").append((String)iter.next()).append(",").append(this.entryDN);
            AMStaticGroupImpl groupImpl = new AMStaticGroupImpl(this.token, groupDNSB.toString());
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public AMGroup createStaticGroup(String name, Map attributes, Map serviceNameAndAttrs) throws AMException, SSOException {
        return this.createGroup(name, attributes, serviceNameAndAttrs, 10);
    }

    public void deleteStaticGroups(Set groupDNs) throws AMException, SSOException {
        Iterator iter = groupDNs.iterator();
        while (iter.hasNext()) {
            String groupDN = (String)iter.next();
            AMStaticGroupImpl group = new AMStaticGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public Set getStaticGroups(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(9));
    }

    public long getNumberOfStaticGroups(int level) throws AMException, SSOException {
        return this.getStaticGroups(level).size();
    }

    public Set searchStaticGroups(String wildcard, int level) throws AMException, SSOException {
        return this.searchStaticGroups(wildcard, null, level);
    }

    public Set searchStaticGroups(String wildcard, int level, String groupSearchTemplate, Map avPairs) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (debug.messageEnabled()) {
                debug.message("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9, groupSearchTemplate), wildcard, avPairs, level);
    }

    public AMSearchResults searchStaticGroups(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchStaticGroups(wildcard, null, searchControl);
    }

    public Set searchStaticGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9), wildcard, avPairs, level);
    }

    public AMSearchResults searchStaticGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(9), wildcard, avPairs, searchControl);
    }

    public Set searchGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, level);
    }

    public AMSearchResults searchGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, searchControl);
    }

    public Set createPeopleContainers(Set peopleContainerNames) throws AMException, SSOException {
        Iterator iter = peopleContainerNames.iterator();
        HashSet<AMPeopleContainerImpl> peopleContainers = new HashSet<AMPeopleContainerImpl>();
        while (iter.hasNext()) {
            StringBuffer peopleContainerDNSB = new StringBuffer();
            peopleContainerDNSB.append(AMNamingAttrManager.getNamingAttr(5)).append("=").append((String)iter.next()).append(",").append(this.entryDN);
            AMPeopleContainerImpl peopleContainerImpl = new AMPeopleContainerImpl(this.token, peopleContainerDNSB.toString());
            peopleContainerImpl.create();
            peopleContainers.add(peopleContainerImpl);
        }
        return peopleContainers;
    }

    public Set createPeopleContainers(Map peopleContainersMap) throws AMException, SSOException {
        Iterator iter = peopleContainersMap.keySet().iterator();
        HashSet<AMPeopleContainerImpl> peopleContainers = new HashSet<AMPeopleContainerImpl>();
        while (iter.hasNext()) {
            String peopleContainerName = (String)iter.next();
            StringBuffer peopleContainerDNSB = new StringBuffer();
            peopleContainerDNSB.append(AMNamingAttrManager.getNamingAttr(5)).append("=").append(peopleContainerName).append(",").append(this.entryDN);
            Map attributes = (Map)peopleContainersMap.get(peopleContainerName);
            AMPeopleContainerImpl peopleContainerImpl = new AMPeopleContainerImpl(this.token, peopleContainerDNSB.toString());
            peopleContainerImpl.setAttributes(attributes);
            peopleContainerImpl.create();
            peopleContainers.add(peopleContainerImpl);
        }
        return peopleContainers;
    }

    public void deletePeopleContainers(Set peopleContainerDNs) throws AMException, SSOException {
        Iterator iter = peopleContainerDNs.iterator();
        while (iter.hasNext()) {
            String peopleContainerDN = (String)iter.next();
            AMPeopleContainerImpl peopleContainer = new AMPeopleContainerImpl(this.token, peopleContainerDN);
            peopleContainer.delete();
        }
    }

    public Set getPeopleContainers(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(5));
    }

    public long getNumberOfPeopleContainers(int level) throws AMException, SSOException {
        return this.getPeopleContainers(level).size();
    }

    public Set searchPeopleContainers(String wildcard, int level) throws AMException, SSOException {
        return this.searchPeopleContainers(wildcard, null, level);
    }

    public AMSearchResults searchPeopleContainers(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchPeopleContainers(wildcard, null, searchControl);
    }

    public Set searchPeopleContainers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(5), this.getSearchFilter(5), wildcard, avPairs, level);
    }

    public AMSearchResults searchPeopleContainers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(5), this.getSearchFilter(5), wildcard, avPairs, searchControl);
    }

    public Set createGroupContainers(Set groupContainerNames) throws AMException, SSOException {
        Iterator iter = groupContainerNames.iterator();
        HashSet<AMGroupContainerImpl> groupContainers = new HashSet<AMGroupContainerImpl>();
        while (iter.hasNext()) {
            String groupContainerDN = AMNamingAttrManager.getNamingAttr(4) + "=" + (String)iter.next() + "," + this.entryDN;
            AMGroupContainerImpl groupContainerImpl = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainerImpl.create();
            groupContainers.add(groupContainerImpl);
        }
        return groupContainers;
    }

    public Set createGroupContainers(Map groupContainersMap) throws AMException, SSOException {
        Iterator iter = groupContainersMap.keySet().iterator();
        HashSet<AMGroupContainerImpl> groupContainers = new HashSet<AMGroupContainerImpl>();
        while (iter.hasNext()) {
            String groupContainerName = (String)iter.next();
            String groupContainerDN = AMNamingAttrManager.getNamingAttr(4) + "=" + groupContainerName + "," + this.entryDN;
            Map attributes = (Map)groupContainersMap.get(groupContainerName);
            AMGroupContainerImpl groupContainerImpl = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainerImpl.setAttributes(attributes);
            groupContainerImpl.create();
            groupContainers.add(groupContainerImpl);
        }
        return groupContainers;
    }

    public void deleteGroupContainers(Set groupContainerDNs) throws AMException, SSOException {
        Iterator iter = groupContainerDNs.iterator();
        while (iter.hasNext()) {
            String groupContainerDN = (String)iter.next();
            AMGroupContainerImpl groupContainer = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainer.delete();
        }
    }

    public Set getGroupContainers(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(4));
    }

    public long getNumberOfGroupContainers(int level) throws AMException, SSOException {
        return this.getGroupContainers(level).size();
    }

    public Set searchGroupContainers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), wildcard, avPairs, level);
    }

    public AMSearchResults searchGroupContainers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), wildcard, avPairs, searchControl);
    }

    public Set createUsers(Set userNames) throws AMException, SSOException {
        HashSet<AMUserImpl> usersSet = new HashSet<AMUserImpl>();
        Set serviceNames = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
        }
        Iterator iter = userNames.iterator();
        while (iter.hasNext()) {
            String userDN = AMNamingAttrManager.getNamingAttr(1) + "=" + (String)iter.next() + "," + this.entryDN;
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            if (objectClasses != null && !objectClasses.isEmpty()) {
                user.setAttribute("objectclass", objectClasses);
            }
            user.create();
            usersSet.add(user);
        }
        return usersSet;
    }

    public Set createUsers(Map usersMap) throws AMException, SSOException {
        HashSet<AMUserImpl> usersSet = new HashSet<AMUserImpl>();
        Set serviceNames = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
        }
        Iterator iter = usersMap.keySet().iterator();
        while (iter.hasNext()) {
            String userName = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(1) + "=" + userName + "," + this.entryDN;
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            Map userMap = (Map)usersMap.get(userName);
            user.setAttributes(userMap);
            if (objectClasses != null && !objectClasses.isEmpty()) {
                Set existingOC = (Set)userMap.get("objectclass");
                if (existingOC != null && !existingOC.isEmpty()) {
                    objectClasses = AMCommonUtils.combineOCs(objectClasses, existingOC);
                }
                user.setAttribute("objectclass", objectClasses);
            }
            user.create();
            usersSet.add(user);
        }
        return usersSet;
    }

    public AMUser createUser(String uid, Map attrMap, Map serviceNameAndAttrs) throws AMException, SSOException {
        HashSet<String> serviceNames = this.getOrgTypeAttributes("iPlanetAMAdminConsoleService", "iplanet-am-required-services");
        if (serviceNames == Collections.EMPTY_SET) {
            serviceNames = new HashSet<String>();
        }
        Set assignServiceNames = serviceNameAndAttrs.keySet();
        Set registered = this.dsServices.getRegisteredServiceNames(null, this.entryDN);
        Iterator it = assignServiceNames.iterator();
        while (it.hasNext()) {
            String tmpS = (String)it.next();
            if (registered.contains(tmpS)) continue;
            Object[] args = new Object[]{tmpS};
            throw new AMException(AMSDKBundle.getString("459", args, this.locale), "459", args);
        }
        it = assignServiceNames.iterator();
        while (it.hasNext()) {
            String tmp = (String)it.next();
            serviceNames.add(tmp);
        }
        Set objectClasses = null;
        if (serviceNames != null && !serviceNames.isEmpty()) {
            objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
            Set userOCs = (Set)attrMap.get("objectclass");
            objectClasses = AMCommonUtils.combineOCs(userOCs, objectClasses);
        }
        String userDN = AMNamingAttrManager.getNamingAttr(1) + "=" + uid + "," + this.entryDN;
        AMUserImpl user = new AMUserImpl(this.token, userDN);
        user.setAttributes(attrMap);
        it = assignServiceNames.iterator();
        while (it.hasNext()) {
            String thisService = (String)it.next();
            Map sAttrMap = (Map)serviceNameAndAttrs.get(thisService);
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(thisService, this.token);
                ServiceSchema ss = ssm.getSchema(SchemaType.USER);
                sAttrMap = ss.validateAndInheritDefaults(sAttrMap, true);
                sAttrMap = AMCommonUtils.removeEmptyValues(sAttrMap);
                user.setAttributes(sAttrMap);
            }
            catch (SMSException se) {
                debug.error("AMOrganizationImpl: Data validation failed-> " + thisService, se);
                Object[] args = new Object[]{thisService};
                throw new AMException(AMSDKBundle.getString("976", args, this.locale), "976", args);
            }
        }
        if (objectClasses != null && !objectClasses.isEmpty()) {
            user.setAttribute("objectclass", objectClasses);
        }
        user.create();
        return user;
    }

    public void deleteUsers(Set users) throws AMException, SSOException {
        Iterator iter = users.iterator();
        while (iter.hasNext()) {
            String userDN = (String)iter.next();
            AMUserImpl user = new AMUserImpl(this.token, userDN);
            user.delete();
        }
    }

    public Set getUserDNs() throws AMException, SSOException {
        return this.search(1, this.getSearchFilter(1));
    }

    public AMUser getUser(String uid, String userSearchTemplate) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (debug.messageEnabled()) {
                debug.message("AMOrganization.getUser: ancestor org is deleted for: " + this.entryDN + " :returning null");
            }
            return null;
        }
        Set users = this.searchUsers(uid, 2, userSearchTemplate, null);
        if (users.size() > 1) {
            Object[] args = new Object[]{uid};
            throw new AMException(AMSDKBundle.getString("969", args, this.locale), "969", args);
        }
        Iterator it = users.iterator();
        if (it.hasNext()) {
            return new AMUserImpl(this.token, (String)it.next());
        }
        return null;
    }

    public long getNumberOfUsers(int level) throws AMException, SSOException {
        return this.getUsers(level).size();
    }

    public Set searchUsers(String wildcard, int level) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, level);
    }

    public Set searchUsers(String wildcard, int level, String userSearchTemplate, Map avPairs) throws AMException, SSOException {
        if (AMCompliance.isComplianceUserDeletionEnabled() && AMCompliance.isAncestorOrgDeleted(this.token, this.entryDN, 2)) {
            if (debug.warningEnabled()) {
                debug.warning("AMOrganization.searchAssDynGroup: ancestor org is deleted for: " + this.entryDN + " :returning empty set");
            }
            return Collections.EMPTY_SET;
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, userSearchTemplate), wildcard, avPairs, level);
    }

    public AMSearchResults searchUsers(String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchUsers(wildcard, null, searchControl);
    }

    public Set searchUsers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, avPairs, level);
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, avPairs, searchControl);
    }

    public AMSearchResults searchUsers(String wildcard, AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, searchControl, avfilter);
    }

    public AMSearchResults searchUsers(AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        return this.searchObjects(this.getSearchFilter(1), searchControl, avfilter);
    }

    public long getNumberOfServices() throws AMException, SSOException {
        return this.getRegisteredServiceNames().size();
    }

    public Set getRegisteredServiceNames() throws AMException, SSOException {
        return this.dsServices.getRegisteredServiceNames(this.token, this.entryDN);
    }

    public synchronized void registerService(String serviceName, boolean createTemplate, boolean activate) throws AMException, SSOException {
        block20: {
            if (debug.messageEnabled()) {
                debug.message("AMOrganizationImpl.registerService(" + serviceName + ", " + createTemplate + ", " + activate + ")");
            }
            try {
                this.dsServices.registerService(this.token, this.entryDN, serviceName);
            }
            catch (AMException le) {
                if (le.getErrorCode().equalsIgnoreCase("464")) break block20;
                throw le;
            }
        }
        HashSet<String> serviceStatus = this.getAttribute("sunRegisteredServiceName");
        if (!((Object)serviceStatus).equals(Collections.EMPTY_SET)) {
            Iterator iter = serviceStatus.iterator();
            while (iter.hasNext()) {
                String status = (String)iter.next();
                if (!status.equalsIgnoreCase(serviceName)) continue;
                Set services = ServiceManager.servicesAssignedByDefault();
                if (services != null && !services.isEmpty()) {
                    Iterator items = services.iterator();
                    while (items.hasNext()) {
                        String dService = (String)items.next();
                        if (!serviceName.toLowerCase().equals(dService.toLowerCase())) continue;
                        return;
                    }
                    continue;
                }
                Object[] args = new Object[]{serviceName};
                throw new AMException(AMSDKBundle.getString("464", args, this.locale), "464", args);
            }
        } else {
            serviceStatus = new HashSet<String>();
        }
        serviceStatus.add(serviceName);
        this.setAttribute("sunRegisteredServiceName", serviceStatus);
        try {
            this.store();
        }
        catch (AMException le) {
            try {
                Set objectClass = this.getAttribute("objectclass");
                if (debug.messageEnabled()) {
                    debug.message("object class=" + objectClass);
                }
                if (objectClass.contains("sunManagedOrganization")) {
                    throw le;
                }
                objectClass.add("sunManagedOrganization");
                this.setAttribute("objectclass", objectClass);
                this.setAttribute("sunRegisteredServiceName", serviceStatus);
                this.store();
            }
            catch (Exception e) {
                if (debug.messageEnabled()) {
                    debug.message("error adding objectclass", e);
                }
                throw le;
            }
        }
        if (createTemplate) {
            try {
                if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.POLICY)) {
                    this.createTemplate(300, serviceName, null);
                }
                if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.DYNAMIC)) {
                    this.createTemplate(301, serviceName, null);
                }
            }
            catch (SMSException smsex) {
                throw new AMException(AMSDKBundle.getString("451", this.locale), "451");
            }
        }
    }

    public synchronized void unregisterService(String serviceName) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMOrganizationImpl.unregisterService(" + serviceName + ")");
        }
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.isRegisteredForSubOrgs(serviceName)) {
            Object[] args = new Object[]{serviceName};
            throw new AMException(AMSDKBundle.getString("445", args, this.locale), "445", args);
        }
        try {
            block9: {
                if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.DYNAMIC)) {
                    try {
                        this.dsServices.unRegisterService(this.token, this.entryDN, this.profileType, serviceName, 301);
                    }
                    catch (AMException le) {
                        if (!debug.messageEnabled()) break block9;
                        debug.message("AMOrganizationImpl.unregister exception in dsManager.unRegisterServiceDYNAMIC_TEMPLATE serviceName=" + serviceName);
                    }
                }
            }
            if (AMServiceUtils.serviceHasSubSchema(this.token, serviceName, SchemaType.ORGANIZATION) && this.orgTemplateExists(serviceName)) {
                AMTemplate template = this.getTemplate(serviceName, 302);
                this.dsServices.unRegisterService(this.token, this.entryDN, this.profileType, serviceName, 302);
                template.delete();
            }
            Set serviceStatus = this.getAttribute("sunRegisteredServiceName");
            Iterator iter = serviceStatus.iterator();
            while (iter.hasNext()) {
                String status = (String)iter.next();
                if (!status.equalsIgnoreCase(serviceName)) continue;
                serviceStatus.remove(status);
                this.setAttribute("sunRegisteredServiceName", serviceStatus);
                this.store();
                break;
            }
        }
        catch (SMSException smsex) {
            Object[] args = new Object[]{serviceName};
            throw new AMException(AMSDKBundle.getString("913", args, this.locale), "913", args);
        }
    }

    public Set getUsers(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(1));
    }

    public void unassignAllPolicies(String serviceName, Set policyDNs) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public void modifyAllPolicyTemplates(String serviceName, Set policyDNs) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public boolean deleteAllNamedPolicyTemplates(String policyDN) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public Set getAssignedPolicyDNs() throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public boolean isPolicyAssigned(String policyDN, String serviceName) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public boolean orgTemplateExists(String serviceName) throws AMException, SSOException {
        ServiceConfig sc = AMServiceUtils.getOrgConfig(this.token, this.entryDN, serviceName);
        return sc != null;
    }

    protected Set getOrgTypeAttributes(String serviceName, String attrName) throws SSOException {
        Set attrValues = null;
        try {
            AMTemplate amTemplate = this.getTemplate(serviceName, 302);
            attrValues = amTemplate.getAttribute(attrName);
            if (debug.messageEnabled()) {
                debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org template " + serviceName + " : " + attrName + "\n" + this.entryDN + " : " + attrValues);
            }
        }
        catch (AMException ame) {
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(this.token, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                attrValues = (Set)defaultValues.get(attrName);
                if (debug.messageEnabled()) {
                    debug.message("AMOrganizationImpl.getOrgTypeAttributes(): obtained from org defaults " + serviceName + " : " + attrName + "\n" + this.entryDN + " : " + attrValues);
                }
            }
            catch (Exception se) {
                debug.warning("AMOrganizationImpl.getOrgTypeAttributes(): Error encountered in retrieving default org attrs for", se);
            }
        }
        return attrValues;
    }

    private boolean isRegisteredForSubOrgs(String serviceName) throws SSOException {
        HashMap avPair = new HashMap();
        HashSet<String> value = new HashSet<String>();
        value.add(serviceName);
        avPair.put("sunRegisteredServiceName", value);
        Set subOrgs = null;
        try {
            subOrgs = this.searchSubOrganizations("*", avPair, 2);
        }
        catch (AMException ae) {
            // empty catch block
        }
        return subOrgs != null && !subOrgs.isEmpty() && subOrgs.size() > 1;
    }

    protected AMGroup createGroup(String name, Map attributes, Map serviceNameAndAttrs, int type) throws AMException, SSOException {
        AMGroupImpl groupImpl;
        String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + name + "," + this.entryDN;
        switch (type) {
            case 10: {
                groupImpl = new AMStaticGroupImpl(this.token, groupDN);
                break;
            }
            case 11: {
                groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
                break;
            }
            case 12: {
                groupImpl = new AMAssignableDynamicGroupImpl(this.token, groupDN);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (serviceNameAndAttrs != null && !serviceNameAndAttrs.isEmpty()) {
            Set serviceNames = serviceNameAndAttrs.keySet();
            Set registered = this.dsServices.getRegisteredServiceNames(null, this.entryDN);
            Iterator it = serviceNames.iterator();
            while (it.hasNext()) {
                String tmpS = (String)it.next();
                if (registered.contains(tmpS)) continue;
                Object[] args = new Object[]{tmpS};
                throw new AMException(AMSDKBundle.getString("459", args, this.locale), "459", args);
            }
            Set objectClasses = null;
            if (serviceNames != null && !serviceNames.isEmpty()) {
                objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
                Set userOCs = (Set)attributes.get("objectclass");
                objectClasses = AMCommonUtils.combineOCs(userOCs, objectClasses);
            }
            if ((it = serviceNames.iterator()).hasNext()) {
                String thisService = (String)it.next();
                Map sAttrMap = (Map)serviceNameAndAttrs.get(thisService);
                try {
                    ServiceSchemaManager ssm = new ServiceSchemaManager(thisService, this.token);
                    ServiceSchema ss = ssm.getSchema(SchemaType.GROUP);
                    sAttrMap = ss.validateAndInheritDefaults(sAttrMap, true);
                    sAttrMap = AMCommonUtils.removeEmptyValues(sAttrMap);
                    groupImpl.setAttributes(sAttrMap);
                }
                catch (SMSException se) {
                    debug.error("AMGroupContainerImpl.createStaticGroup: Data validation failed.. ", se);
                }
                Object[] args = new Object[]{thisService};
                throw new AMException(AMSDKBundle.getString("976", args, this.locale), "976", args);
            }
            if (objectClasses != null && !objectClasses.isEmpty()) {
                groupImpl.setAttribute("objectclass", objectClasses);
            }
        }
        groupImpl.setAttributes(attributes);
        groupImpl.create();
        return groupImpl;
    }

    public AMSearchResults searchAssignableDynamicGroups(String wildcard, Map avPairs, String groupSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(12, groupSearchTemplate), wildcard, avPairs, searchControl);
    }

    public AMSearchResults searchDynamicGroups(String wildcard, Map avPairs, String groupSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(11, groupSearchTemplate), wildcard, avPairs, searchControl);
    }

    public AMSearchResults searchStaticGroups(String wildcard, Map avPairs, String groupSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), this.getSearchFilter(10, groupSearchTemplate), wildcard, avPairs, searchControl);
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, String userSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, userSearchTemplate), wildcard, avPairs, searchControl);
    }

    public Set createEntities(int type, Map entityNamesAndAttrs) throws AMException, SSOException {
        AMEntityType entityType = (AMEntityType)AMCommonUtils.supportedEntitiesBasedOnType.get(Integer.toString(type));
        AMStoreConnection amsc = new AMStoreConnection(this.token);
        String entityTypeName = amsc.getAMObjectName(type);
        String containerDN = entityType.getContainerRDN();
        int containerType = entityType.getContainerType();
        String createDN = this.entryDN;
        if (containerDN != null && containerDN.length() > 0) {
            String nString = AMNamingAttrManager.getNamingAttr(containerType);
            createDN = nString + "=" + containerDN + "," + this.entryDN;
        }
        switch (containerType) {
            case 3: {
                AMOrganizationalUnit ou = amsc.getOrganizationalUnit(createDN);
                if (ou.isExists()) {
                    Set supportedTypes = ou.getSupportedTypes();
                    if (!supportedTypes.contains(entityTypeName)) {
                        supportedTypes.add(entityTypeName);
                        ou.setSupportedTypes(supportedTypes);
                    }
                } else {
                    HashSet<String> supportedTypes = new HashSet<String>();
                    supportedTypes.add(entityTypeName);
                    HashMap ouMap = new HashMap();
                    HashMap<String, HashSet<String>> ouAttrsMap = new HashMap<String, HashSet<String>>();
                    ouAttrsMap.put("sunIdentityServerSupportedTypes", supportedTypes);
                    ouMap.put(containerDN, ouAttrsMap);
                    this.createOrganizationalUnits(ouMap);
                    ou = amsc.getOrganizationalUnit(createDN);
                }
                return ou.createEntities(entityTypeName, entityNamesAndAttrs);
            }
            case 5: {
                AMPeopleContainer pc = amsc.getPeopleContainer(createDN);
                if (pc.isExists()) {
                    return pc.createEntities(entityTypeName, entityNamesAndAttrs);
                }
                HashSet<String> pcSet = new HashSet<String>();
                pcSet.add(containerDN);
                this.createPeopleContainers(pcSet);
                pc = amsc.getPeopleContainer(createDN);
                return pc.createEntities(entityTypeName, entityNamesAndAttrs);
            }
        }
        return this.createEntitiesUnderOrg(type, entityNamesAndAttrs);
    }

    public Set createEntities(int type, Set entityNames) throws AMException, SSOException {
        AMEntityType entityType = (AMEntityType)AMCommonUtils.supportedEntitiesBasedOnType.get(Integer.toString(type));
        AMStoreConnection amsc = new AMStoreConnection(this.token);
        String entityTypeName = amsc.getAMObjectName(type);
        String containerDN = entityType.getContainerRDN();
        int containerType = entityType.getContainerType();
        String createDN = this.entryDN;
        if (containerDN != null && containerDN.length() > 0) {
            String nString = AMNamingAttrManager.getNamingAttr(containerType);
            createDN = nString + "=" + containerDN + "," + this.entryDN;
        }
        switch (containerType) {
            case 3: {
                AMOrganizationalUnit ou = amsc.getOrganizationalUnit(createDN);
                if (ou.isExists()) {
                    Set supportedTypes = ou.getSupportedTypes();
                    if (!supportedTypes.contains(entityTypeName)) {
                        supportedTypes.add(entityTypeName);
                        ou.setSupportedTypes(supportedTypes);
                    }
                } else {
                    HashSet<String> supportedTypes = new HashSet<String>();
                    supportedTypes.add(entityTypeName);
                    HashMap ouMap = new HashMap();
                    HashMap<String, HashSet<String>> ouAttrsMap = new HashMap<String, HashSet<String>>();
                    ouAttrsMap.put("sunIdentityServerSupportedTypes", supportedTypes);
                    ouMap.put(containerDN, ouAttrsMap);
                    this.createOrganizationalUnits(ouMap);
                    ou = amsc.getOrganizationalUnit(createDN);
                }
                return ou.createEntities(entityTypeName, entityNames);
            }
            case 5: {
                AMPeopleContainer pc = amsc.getPeopleContainer(createDN);
                if (pc.isExists()) {
                    return pc.createEntities(entityTypeName, entityNames);
                }
                HashSet<String> pcSet = new HashSet<String>();
                pcSet.add(containerDN);
                this.createPeopleContainers(pcSet);
                pc = amsc.getPeopleContainer(createDN);
                return pc.createEntities(entityTypeName, entityNames);
            }
        }
        return this.createEntitiesUnderOrg(type, entityNames);
    }

    public void deleteEntities(int type, Set entityDNs) throws AMException, SSOException {
        Iterator iter = entityDNs.iterator();
        while (iter.hasNext()) {
            String rDN = (String)iter.next();
            AMEntityImpl resource = new AMEntityImpl(this.token, rDN);
            resource.delete();
        }
    }

    public Set searchEntities(int type, String wildcard, int scope, Map avPairs) throws AMException, SSOException {
        AMEntityType entityType = (AMEntityType)AMCommonUtils.supportedEntitiesBasedOnType.get(Integer.toString(type));
        AMStoreConnection amsc = new AMStoreConnection(this.token);
        String containerDN = entityType.getContainerRDN();
        int containerType = entityType.getContainerType();
        String searchTemplate = entityType.getSearchTemplate();
        String searchDN = this.entryDN;
        if (containerDN != null && containerDN.length() > 0) {
            String nString = AMNamingAttrManager.getNamingAttr(containerType);
            searchDN = nString + "=" + containerDN + "," + this.entryDN;
        }
        switch (containerType) {
            case 3: {
                AMOrganizationalUnit ou = amsc.getOrganizationalUnit(searchDN);
                if (ou.isExists()) {
                    return ou.searchEntities(wildcard, 1, searchTemplate, avPairs);
                }
                return Collections.EMPTY_SET;
            }
            case 5: {
                AMPeopleContainer pc = amsc.getPeopleContainer(searchDN);
                if (pc.isExists()) {
                    pc.searchEntities(wildcard, 1, searchTemplate, avPairs);
                    break;
                }
                return Collections.EMPTY_SET;
            }
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, searchTemplate), wildcard, avPairs, scope);
    }

    public AMSearchResults searchEntities(int type, String wildcard, Map avPairs, AMSearchControl ctrls) throws AMException, SSOException {
        AMEntityType entityType = (AMEntityType)AMCommonUtils.supportedEntitiesBasedOnType.get(Integer.toString(type));
        AMStoreConnection amsc = new AMStoreConnection(this.token);
        String containerDN = entityType.getContainerRDN();
        int containerType = entityType.getContainerType();
        String searchTemplate = entityType.getSearchTemplate();
        String searchDN = this.entryDN;
        if (containerDN != null && containerDN.length() > 0) {
            String nString = AMNamingAttrManager.getNamingAttr(containerType);
            searchDN = nString + "=" + containerDN + "," + this.entryDN;
        }
        switch (containerType) {
            case 3: {
                AMOrganizationalUnit ou = amsc.getOrganizationalUnit(searchDN);
                if (ou.isExists()) {
                    return ou.searchEntities(wildcard, avPairs, searchTemplate, ctrls);
                }
                return null;
            }
            case 5: {
                AMPeopleContainer pc = amsc.getPeopleContainer(searchDN);
                if (pc.isExists()) {
                    pc.searchEntities(wildcard, avPairs, searchTemplate, ctrls);
                    break;
                }
                return null;
            }
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1, searchTemplate), wildcard, avPairs, ctrls);
    }

    public AMSearchResults searchEntities(int type, String wildcard, String avfilter, AMSearchControl ctrl) throws AMException, SSOException {
        AMEntityType entityType = (AMEntityType)AMCommonUtils.supportedEntitiesBasedOnType.get(Integer.toString(type));
        AMStoreConnection amsc = new AMStoreConnection(this.token);
        String containerDN = entityType.getContainerRDN();
        int containerType = entityType.getContainerType();
        String searchTemplate = entityType.getSearchTemplate();
        String searchDN = this.entryDN;
        if (containerDN != null && containerDN.length() > 0) {
            String nString = AMNamingAttrManager.getNamingAttr(containerType);
            searchDN = nString + "=" + containerDN + "," + this.entryDN;
        }
        switch (containerType) {
            case 3: {
                AMOrganizationalUnit ou = amsc.getOrganizationalUnit(searchDN);
                if (ou.isExists()) {
                    return ou.searchEntities(wildcard, ctrl, avfilter, searchTemplate);
                }
                throw new AMException(AMSDKBundle.getString("461", this.locale), "461");
            }
            case 5: {
                AMPeopleContainer pc = amsc.getPeopleContainer(searchDN);
                if (pc.isExists()) {
                    pc.searchEntities(wildcard, ctrl, avfilter, searchTemplate);
                    break;
                }
                throw new AMException(AMSDKBundle.getString("461", this.locale), "461");
            }
        }
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(1), this.getSearchFilter(1), wildcard, ctrl, avfilter);
    }

    protected Set createEntitiesUnderOrg(int type, Map entityNamesAndAttrs) throws AMException, SSOException {
        String stype;
        if (debug.messageEnabled()) {
            debug.message("AMOrganizationImpl.createEntities enter.  entityNamesAndAttrs=" + entityNamesAndAttrs);
        }
        if ((stype = (String)AMCommonUtils.supportedNames.get(Integer.toString(type))) == null) {
            throw new AMException(AMSDKBundle.getString("117", this.locale), "117");
        }
        if (type == 1) {
            Set uSet = this.createUsers(entityNamesAndAttrs);
            HashSet<AMEntityImpl> resultSet = new HashSet<AMEntityImpl>();
            Iterator it = uSet.iterator();
            while (it.hasNext()) {
                AMUser u = (AMUser)it.next();
                AMEntityImpl e = new AMEntityImpl(this.token, u.getDN());
                resultSet.add(e);
            }
            return resultSet;
        }
        HashSet<AMEntityImpl> entitySet = new HashSet<AMEntityImpl>();
        Iterator iter = entityNamesAndAttrs.keySet().iterator();
        while (iter.hasNext()) {
            String userName = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(type) + "=" + userName + "," + this.entryDN;
            AMEntityImpl user = new AMEntityImpl(this.token, userDN);
            Map userMap = (Map)entityNamesAndAttrs.get(userName);
            user.setAttributes(userMap);
            user.create(stype);
            entitySet.add(user);
        }
        return entitySet;
    }

    protected Set createEntitiesUnderOrg(int type, Set entityNames) throws AMException, SSOException {
        String stype = (String)AMCommonUtils.supportedNames.get(Integer.toString(type));
        if (stype == null) {
            throw new AMException(AMSDKBundle.getString("117", this.locale), "117");
        }
        if (type == 1) {
            Set uSet = this.createUsers(entityNames);
            HashSet<AMEntityImpl> resultSet = new HashSet<AMEntityImpl>();
            Iterator it = uSet.iterator();
            while (it.hasNext()) {
                AMUser u = (AMUser)it.next();
                AMEntityImpl e = new AMEntityImpl(this.token, u.getDN());
                resultSet.add(e);
            }
            return resultSet;
        }
        HashSet<AMEntityImpl> entitySet = new HashSet<AMEntityImpl>();
        Iterator iter = entityNames.iterator();
        while (iter.hasNext()) {
            String userName = (String)iter.next();
            String userDN = AMNamingAttrManager.getNamingAttr(type) + "=" + userName + "," + this.entryDN;
            AMEntityImpl user = new AMEntityImpl(this.token, userDN);
            user.create(stype);
            entitySet.add(user);
        }
        return entitySet;
    }

    public boolean isActivated() throws AMException, SSOException {
        return this.getStringAttribute(statusAN).equalsIgnoreCase("active");
    }
}

