/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.UMSException;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.shared.locale.Locale;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class AMException
extends Exception
implements L10NMessage {
    private static final long serialVersionUID = -660487903675407220L;
    private String localizedMsg = null;
    private String errorCode = null;
    private Object[] args = null;
    private LDAPException rootCause = null;
    private String ldapErrorMsg = null;
    private String ldapErrCode = null;

    public AMException(String msg, String errorCode) {
        super(msg);
        this.localizedMsg = msg;
        this.errorCode = errorCode;
    }

    public AMException(SSOToken token, String errorCode) {
        this.localizedMsg = AMSDKBundle.getString(errorCode, AMCommonUtils.getUserLocale(token));
        this.errorCode = errorCode;
    }

    public AMException(String msg, String errorCode, UMSException ue) {
        try {
            this.rootCause = (LDAPException)ue.getRootCause();
            this.ldapErrCode = Integer.toString(this.rootCause.getLDAPResultCode());
            this.ldapErrorMsg = AMSDKBundle.getString(this.ldapErrCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.localizedMsg = this.ldapErrorMsg != null ? msg + "::" + this.ldapErrorMsg : msg;
        this.errorCode = errorCode;
    }

    public AMException(SSOToken token, String errorCode, UMSException ue) {
        try {
            this.rootCause = (LDAPException)ue.getRootCause();
            this.ldapErrCode = Integer.toString(this.rootCause.getLDAPResultCode());
            this.ldapErrorMsg = AMSDKBundle.getString(this.ldapErrCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        String message = AMSDKBundle.getString(errorCode, AMCommonUtils.getUserLocale(token));
        this.localizedMsg = this.ldapErrorMsg != null ? message + "::" + this.ldapErrorMsg : message;
        this.errorCode = errorCode;
    }

    public AMException(String msg, String errorCode, Object[] args) {
        super(msg);
        this.localizedMsg = msg;
        this.errorCode = errorCode;
        this.args = args;
    }

    public AMException(String msg, String errorCode, Object[] args, UMSException ue) {
        try {
            this.rootCause = (LDAPException)ue.getRootCause();
            this.ldapErrCode = Integer.toString(this.rootCause.getLDAPResultCode());
            this.ldapErrorMsg = AMSDKBundle.getString(this.ldapErrCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.localizedMsg = this.ldapErrorMsg != null ? msg + "::" + this.ldapErrorMsg : msg;
        this.errorCode = errorCode;
        this.args = args;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getMessage() {
        return this.localizedMsg;
    }

    public String getLDAPErrorCode() {
        return this.ldapErrCode;
    }

    public LDAPException getLDAPException() {
        return this.rootCause;
    }

    public String getL10NMessage(java.util.Locale locale) {
        String result = this.errorCode;
        if (locale != null) {
            ResourceBundle rb = AMSDKBundle.getBundleFromHash(locale);
            String mid = Locale.getString(rb, this.errorCode, AMCommonUtils.debug);
            result = this.args == null || this.args.length == 0 ? mid : MessageFormat.format(mid, this.args);
        }
        return result;
    }

    public String getResourceBundleName() {
        return "amProfile";
    }
}

