/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.util.Util;

public class IpAddress
implements Address {
    private InetAddress ip_addr;
    private int port;
    private byte[] additional_data;
    protected static final HashMap sAddrCache = new HashMap();
    protected static final Log log = LogFactory.getLog((Class)IpAddress.class);
    static boolean resolve_dns = false;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final boolean jdk_14 = Util.getJavaVersion() >= 14;

    public IpAddress() {
        this.ip_addr = null;
        this.port = 0;
        this.additional_data = null;
    }

    public IpAddress(String i, int p) {
        block3: {
            this.ip_addr = null;
            this.port = 0;
            this.additional_data = null;
            this.port = p;
            try {
                this.ip_addr = InetAddress.getByName(i);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)("failed to get " + i + ": " + e));
            }
        }
        if (this.ip_addr == null) {
            this.setAddressToLocalHost();
        }
    }

    public IpAddress(InetAddress i, int p) {
        this.ip_addr = null;
        this.port = 0;
        this.additional_data = null;
        this.ip_addr = i;
        this.port = p;
        if (this.ip_addr == null) {
            this.setAddressToLocalHost();
        }
    }

    private void setAddressToLocalHost() {
        block2: {
            try {
                this.ip_addr = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)("exception: " + e));
            }
        }
    }

    public IpAddress(int port) {
        this(port, true);
    }

    public IpAddress(int port, boolean set_default_host) {
        this.ip_addr = null;
        this.port = 0;
        this.additional_data = null;
        this.port = port;
        if (set_default_host) {
            this.setAddressToLocalHost();
        }
    }

    public InetAddress getIpAddress() {
        return this.ip_addr;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isMulticastAddress() {
        return this.ip_addr != null ? this.ip_addr.isMulticastAddress() : false;
    }

    public byte[] getAdditionalData() {
        return this.additional_data;
    }

    public void setAdditionalData(byte[] additional_data) {
        this.additional_data = additional_data;
    }

    public int compare(IpAddress other) {
        return this.compareTo(other);
    }

    public int compareTo(Object o) {
        int rc;
        int h2;
        if (o == null || !(o instanceof IpAddress)) {
            throw new ClassCastException("comparison between different classes: the other object is " + (o != null ? o.getClass() : o));
        }
        IpAddress other = (IpAddress)((Object)o);
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                return this.port < other.port ? -1 : (this.port > other.port ? 1 : 0);
            }
            return -1;
        }
        int h1 = this.ip_addr.hashCode();
        int n = h1 < (h2 = other.ip_addr.hashCode()) ? -1 : (rc = h1 > h2 ? 1 : 0);
        return rc != 0 ? rc : (this.port < other.port ? -1 : (this.port > other.port ? 1 : 0));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        int retval = this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
        return retval;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else if (this.ip_addr.isMulticastAddress()) {
            sb.append(this.ip_addr.getHostAddress());
        } else {
            String host_name = null;
            host_name = resolve_dns ? this.ip_addr.getHostName() : this.ip_addr.getHostAddress();
            this.appendShortName(host_name, sb);
        }
        sb.append(":" + this.port);
        if (this.additional_data != null) {
            sb.append(" (additional data: ").append(this.additional_data.length).append(" bytes)");
        }
        return sb.toString();
    }

    private void appendShortName(String hostname, StringBuffer sb) {
        if (hostname == null) {
            return;
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index));
        } else {
            sb.append(hostname);
        }
    }

    private static final String addressToString(byte[] address) {
        int q;
        int r = 0;
        int charPos = 15;
        char[] buf = new char[15];
        int dot = 46;
        int i = address[3] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[2] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[1] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[0] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        return new String(buf, charPos, 15 - charPos);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] address = this.ip_addr.getAddress();
        out.write(address);
        out.writeInt(this.port);
        if (this.additional_data != null) {
            out.writeInt(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeInt(0);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = 0;
        byte[] a = new byte[4];
        in.readFully(a);
        this.port = in.readInt();
        this.ip_addr = jdk_14 ? InetAddress.getByAddress(a) : IpAddress.getIpAddress(a);
        len = in.readInt();
        if (len > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeShort(address.length);
            out.write(address, 0, address.length);
        } else {
            out.writeShort(0);
        }
        out.writeInt(this.port);
        if (this.additional_data != null) {
            out.writeBoolean(true);
            out.writeInt(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFrom(DataInputStream in) throws IOException {
        int len = in.readShort();
        if (len > 0) {
            byte[] a = new byte[len];
            in.readFully(a);
            this.ip_addr = jdk_14 ? InetAddress.getByAddress(a) : IpAddress.getIpAddress(a);
        }
        this.port = in.readInt();
        if (!in.readBoolean()) {
            return;
        }
        len = in.readInt();
        if (len > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
    }

    public int size() {
        int size = 11;
        if (this.additional_data != null) {
            size += this.additional_data.length + 4;
        }
        return size;
    }

    public Object clone() throws CloneNotSupportedException {
        IpAddress ret = new IpAddress(this.ip_addr, this.port);
        if (this.additional_data != null) {
            ret.additional_data = new byte[this.additional_data.length];
            System.arraycopy(this.additional_data, 0, ret.additional_data, 0, this.additional_data.length);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static InetAddress getIpAddress(byte[] addr) {
        try {
            InetAddress result;
            HashKey key = new HashKey(addr);
            HashMap hashMap = sAddrCache;
            synchronized (hashMap) {
                result = (InetAddress)sAddrCache.get(key);
                if (result == null) {
                    result = InetAddress.getByName(IpAddress.addressToString(addr));
                    sAddrCache.put(key, result);
                }
            }
            return result;
        }
        catch (Exception x) {
            x.printStackTrace();
            if (log.isErrorEnabled()) {
                log.error((Object)x.getMessage());
            }
            return null;
        }
    }

    static {
        try {
            resolve_dns = Boolean.valueOf(System.getProperty("resolve.dns", "false"));
        }
        catch (SecurityException ex) {
            resolve_dns = false;
        }
    }

    static class HashKey {
        private final byte[] mIpAddress;

        public HashKey(byte[] ipaddress) {
            this.mIpAddress = ipaddress == null ? new byte[0] : ipaddress;
        }

        public int hashCode() {
            if (this.mIpAddress.length > 0) {
                return this.mIpAddress[0];
            }
            return 0;
        }

        public byte[] getIpBytes() {
            return this.mIpAddress;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof HashKey) {
                byte[] other = ((HashKey)o).getIpBytes();
                if (other.length != this.mIpAddress.length) {
                    return false;
                }
                boolean result = true;
                for (int i = 0; i < other.length && result; result &= other[i] == this.mIpAddress[i], ++i) {
                }
                return result;
            }
            return false;
        }
    }
}

