/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service.lease;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.service.AbstractService;
import org.jgroups.service.lease.DenyResponseHeader;
import org.jgroups.service.lease.LeaseInfoReplicationHeader;
import org.jgroups.service.lease.LeaseRequestHeader;
import org.jgroups.service.lease.LeaseResponseHeader;
import org.jgroups.util.Util;

public class LeaseFactoryService
extends AbstractService {
    private static final String NEW_LEASE_METHOD = "LeaseFactoryService.processNewLeaseRequest()";
    private static final String RENEW_LEASE_METHOD = "LeaseFactoryService.processRenewLeaseRequest()";
    private static final String CANCEL_LEASE_METHOD = "LeaseFactoryService.processCancelLeaseRequest()";
    private static final String DENY_METHOD = "LeaseFactoryService.denyLeaseRequest()";
    public static final String LEASE_SERVICE_NAME = "Leasing Service";
    public static final int DEFAULT_BEST_FIT_DURATION = 10000;
    public static final int MAXIMUM_DURATION = 60000;
    protected final PullPushAdapter clientAdapter;
    protected final Map leases;

    public LeaseFactoryService(Channel serviceChannel, Channel clientChannel) {
        super(serviceChannel, clientChannel);
        this.clientAdapter = new PullPushAdapter((Transport)clientChannel, new ClientMessageListener());
        this.leases = new HashMap();
        this.setMessageListener(new ServiceMessageListener());
    }

    public String getName() {
        return LEASE_SERVICE_NAME;
    }

    protected long getBestFitDuration() {
        return 10000L + System.currentTimeMillis();
    }

    protected long getMaximumDuration() {
        return 60000L + System.currentTimeMillis();
    }

    protected void incorrectStateReceived(Object incorrectState) {
        System.err.println("Incorrect state received : " + incorrectState);
    }

    protected void propagateStateChange(int type, LeaseInfo leaseInfo, Object leaseTarget) {
        LeaseInfoReplicationHeader header = new LeaseInfoReplicationHeader(type, leaseInfo);
        Message msg = new Message();
        msg.putHeader("leaseInfoReplicationHeader", header);
        msg.setObject((Serializable)leaseTarget);
        try {
            this.serviceChannel.send(msg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void denyLeaseRequest(int denialType, Address requester, String reason, Object leaseTarget, Object tenant) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Denying request: type=" + denialType + ", requester=" + requester + ", leaseTarget=" + leaseTarget + ", tenant=" + tenant + ", reason : " + reason));
        }
        DenyResponseHeader responseHeader = new DenyResponseHeader(denialType, reason, tenant);
        Message msg = new Message();
        msg.putHeader("denyResponseHeader", responseHeader);
        msg.setDest(requester);
        msg.setObject((Serializable)leaseTarget);
        try {
            this.clientChannel.send(msg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void processNewLeaseRequest(LeaseRequestHeader header, Object leaseTarget, Address requester) {
        LeaseInfo leaseInfo;
        if (leaseTarget == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("New lease request: target=" + leaseTarget + ", tenant=" + header.getTenant() + ", requester=" + requester));
        }
        if ((leaseInfo = (LeaseInfo)this.leases.get(leaseTarget)) != null && leaseInfo.isExpired()) {
            this.leases.remove(leaseTarget);
            leaseInfo = null;
        }
        if (leaseInfo != null) {
            this.denyLeaseRequest(1, requester, "Lease target is currently in use. If you are owner of lease use lease renewal mechanism to extend lease time.", leaseTarget, header.getTenant());
            return;
        }
        Object tenant = header.getTenant();
        if (tenant == null) {
            this.denyLeaseRequest(1, requester, "Tenant is unknown. Please check if you specified entity to which lease should be granted.", leaseTarget, tenant);
            return;
        }
        long leaseExpiration = 0L;
        if (header.getDuration() == -1L) {
            leaseExpiration = this.getBestFitDuration();
        } else if (header.getDuration() == Long.MAX_VALUE) {
            leaseExpiration = this.getMaximumDuration();
        } else {
            leaseExpiration = header.getDuration();
            if (!header.isAbsolute()) {
                leaseExpiration += System.currentTimeMillis();
            }
        }
        leaseInfo = new LeaseInfo(tenant, leaseExpiration);
        try {
            LeaseResponseHeader responseHeader = new LeaseResponseHeader(1, leaseExpiration, false, tenant);
            Message msg = new Message();
            msg.putHeader("leaseResponseHeader", responseHeader);
            msg.setDest(requester);
            msg.setObject((Serializable)leaseTarget);
            this.clientChannel.send(msg);
            this.leases.put(leaseTarget, leaseInfo);
            this.propagateStateChange(1, leaseInfo, leaseTarget);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void processRenewLeaseRequest(LeaseRequestHeader header, Object leaseTarget, Address requester) {
        LeaseInfo leaseInfo;
        if (leaseTarget == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Renew lease request: target=" + leaseTarget + ", tenant=" + header.getTenant() + ", requester=" + requester));
        }
        if ((leaseInfo = (LeaseInfo)this.leases.get(leaseTarget)) != null && leaseInfo.isExpired()) {
            this.leases.remove(leaseTarget);
            leaseInfo = null;
        }
        if (leaseInfo == null) {
            this.denyLeaseRequest(2, requester, "Lease you are trying to extent is not available or expired.", leaseTarget, header.getTenant());
        } else {
            if (!leaseInfo.getTenant().equals(header.getTenant())) {
                this.denyLeaseRequest(2, requester, "You are not a tenant of this lease.", leaseTarget, header.getTenant());
                return;
            }
            long leaseExpiration = 0L;
            if (header.getDuration() == -1L) {
                leaseExpiration = this.getBestFitDuration();
            } else if (header.getDuration() == Long.MAX_VALUE) {
                leaseExpiration = this.getMaximumDuration();
            } else {
                leaseExpiration = header.getDuration();
                if (!header.isAbsolute()) {
                    leaseExpiration += System.currentTimeMillis();
                }
            }
            leaseInfo.extendLease(leaseExpiration);
            try {
                LeaseResponseHeader responseHeader = new LeaseResponseHeader(2, leaseExpiration, false, header.getTenant());
                Message msg = new Message();
                msg.putHeader("leaseResponseHeader", responseHeader);
                msg.setDest(requester);
                msg.setObject((Serializable)leaseTarget);
                this.clientChannel.send(msg);
                this.propagateStateChange(2, leaseInfo, leaseTarget);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void processCancelLeaseRequest(LeaseRequestHeader header, Object leaseTarget, Address requester) {
        LeaseInfo leaseInfo;
        if (leaseTarget == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cancel lease request: target=" + leaseTarget + ", tenant=" + header.getTenant() + ", requester=" + requester));
        }
        if ((leaseInfo = (LeaseInfo)this.leases.get(leaseTarget)) == null) {
            this.denyLeaseRequest(3, requester, "No lease was granted for specified lease target.", leaseTarget, header.getTenant());
            return;
        }
        if (!leaseInfo.getTenant().equals(header.getTenant())) {
            this.denyLeaseRequest(3, requester, "Lease belongs to another tenant.", leaseTarget, header.getTenant());
            return;
        }
        this.leases.remove(leaseTarget);
        Message msg = new Message();
        msg.putHeader("leaseResponseHeader", new LeaseResponseHeader(3, header.getTenant()));
        msg.setDest(requester);
        msg.setObject((Serializable)leaseTarget);
        try {
            this.clientChannel.send(msg);
            this.propagateStateChange(3, leaseInfo, leaseTarget);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class LeaseInfo
    implements Externalizable {
        public static final int NEW_LEASE_TYPE = 1;
        public static final int RENEW_LEASE_TYPE = 2;
        public static final int CANCEL_LEASE_TYPE = 3;
        private long expiresAt;
        private Object tenant;

        public LeaseInfo() {
        }

        public LeaseInfo(Object tenant, long expiresAt) {
            this.expiresAt = expiresAt;
            this.tenant = tenant;
        }

        public LeaseInfo(LeaseRequestHeader requestHeader) {
            this.tenant = requestHeader.getTenant();
            this.expiresAt = requestHeader.getDuration();
            if (!requestHeader.isAbsolute()) {
                this.expiresAt += System.currentTimeMillis();
            }
        }

        public long expiresAt() {
            return this.expiresAt;
        }

        public Object getTenant() {
            return this.tenant;
        }

        public void extendLease(long newExpiration) {
            this.expiresAt = newExpiration;
        }

        public boolean isExpired() {
            return this.expiresAt <= System.currentTimeMillis();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.expiresAt = in.readLong();
            this.tenant = in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.expiresAt);
            out.writeObject(this.tenant);
        }
    }

    private class ServiceMessageListener
    implements MessageListener {
        private ServiceMessageListener() {
        }

        public byte[] getState() {
            try {
                return Util.objectToByteBuffer(new HashMap(LeaseFactoryService.this.leases));
            }
            catch (Exception ex) {
                if (LeaseFactoryService.this.log.isErrorEnabled()) {
                    LeaseFactoryService.this.log.error((Object)("exception marshalling state: " + ex));
                }
                return null;
            }
        }

        public void receive(Message msg) {
            if (msg.getSrc().equals(LeaseFactoryService.this.getAddress())) {
                return;
            }
            LeaseInfoReplicationHeader header = (LeaseInfoReplicationHeader)msg.getHeader("leaseInfoReplicationHeader");
            if (header == null) {
                return;
            }
            Object tmp = null;
            tmp = msg.getObject();
            switch (header.getType()) {
                case 1: {
                    LeaseFactoryService.this.leases.put(tmp, header.getLeaseInfo());
                    break;
                }
                case 2: {
                    LeaseFactoryService.this.leases.put(tmp, header.getLeaseInfo());
                    break;
                }
                case 3: {
                    LeaseFactoryService.this.leases.remove(tmp);
                    break;
                }
                default: {
                    System.err.println("Incorrect type " + header.getType());
                }
            }
        }

        public void setState(byte[] data) {
            Object state;
            try {
                state = Util.objectFromByteBuffer(data);
            }
            catch (Exception ex) {
                if (LeaseFactoryService.this.log.isErrorEnabled()) {
                    LeaseFactoryService.this.log.error((Object)("exception unmarshalling state: " + ex));
                }
                return;
            }
            if (!(state instanceof Map)) {
                LeaseFactoryService.this.incorrectStateReceived(state);
                return;
            }
            Iterator iterator = ((Map)state).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object leaseTarget = entry.getKey();
                if (!(entry.getValue() instanceof LeaseInfo)) {
                    LeaseFactoryService.this.incorrectStateReceived(state);
                    return;
                }
                LeaseInfo leaseInfo = (LeaseInfo)entry.getValue();
                LeaseFactoryService.this.leases.put(leaseTarget, leaseInfo);
            }
        }
    }

    private class ClientMessageListener
    implements MessageListener {
        private ClientMessageListener() {
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message msg) {
            if (!LeaseFactoryService.this.isCoordinator()) {
                return;
            }
            LeaseRequestHeader leaseRequestHeader = null;
            try {
                leaseRequestHeader = (LeaseRequestHeader)msg.getHeader("leaseRequestHeader");
            }
            catch (ClassCastException ccex) {
                ccex.printStackTrace();
                return;
            }
            if (leaseRequestHeader == null) {
                return;
            }
            Object leaseTarget = null;
            leaseTarget = msg.getObject();
            Address requester = msg.getSrc();
            switch (leaseRequestHeader.getType()) {
                case 1: {
                    LeaseFactoryService.this.processNewLeaseRequest(leaseRequestHeader, leaseTarget, requester);
                    break;
                }
                case 2: {
                    LeaseFactoryService.this.processRenewLeaseRequest(leaseRequestHeader, leaseTarget, requester);
                    break;
                }
                case 3: {
                    LeaseFactoryService.this.processCancelLeaseRequest(leaseRequestHeader, leaseTarget, requester);
                    break;
                }
            }
        }

        public void setState(byte[] state) {
        }
    }
}

