/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelException;
import org.jgroups.conf.ClassMap;
import org.jgroups.conf.MagicNumberReader;
import org.jgroups.util.Util;

public class ClassConfigurator {
    static ClassConfigurator instance = null;
    private final Map classMap = new HashMap();
    private final Map magicMap = new TreeMap();
    private final Map streamMapId = new TreeMap();
    private final Map streamMapClass = new HashMap();
    protected final Log log = LogFactory.getLog(this.getClass());

    private ClassConfigurator() {
    }

    public void init() throws ChannelException {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.xml.parsers.DocumentBuilderFactory");
            MagicNumberReader reader = new MagicNumberReader();
            try {
                String mnfile = System.getProperty("org.jgroups.conf.magicNumberFile");
                if (mnfile != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Using " + mnfile + " as magic number file"));
                    }
                    reader.setFilename(mnfile);
                }
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            ClassMap[] mapping = reader.readMagicNumberMapping();
            if (mapping != null) {
                for (int i = 0; i < mapping.length; ++i) {
                    Integer m = new Integer(mapping[i].getMagicNumber());
                    try {
                        Class clazz = mapping[i].getClassForMap();
                        ObjectStreamClass objStreamClass = ObjectStreamClass.lookup(clazz);
                        if (objStreamClass == null) {
                            throw new ChannelException("ObjectStreamClass for " + clazz + " not found");
                        }
                        if (this.magicMap.containsKey(m)) {
                            throw new ChannelException("magic key " + m + " (" + clazz.getName() + ')' + " is already in map; please make sure that " + "all magic keys are unique");
                        }
                        this.magicMap.put(m, clazz);
                        this.classMap.put(clazz, m);
                        this.streamMapId.put(m, objStreamClass);
                        this.streamMapClass.put(objStreamClass, m);
                        continue;
                    }
                    catch (ClassNotFoundException cnf) {
                        throw new ChannelException("failed loading class: " + cnf);
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("mapping is:\n" + this.printMagicMap()));
                }
            }
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (Throwable x) {
            throw new ChannelException("failed reading the magic number mapping file", x);
        }
    }

    public static ClassConfigurator getInstance(boolean init) throws ChannelException {
        if (instance == null) {
            instance = new ClassConfigurator();
            if (init) {
                instance.init();
            }
        }
        return instance;
    }

    public Class get(int magic) {
        return (Class)this.magicMap.get(new Integer(magic));
    }

    public Class get(String clazzname) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(clazzname);
        }
        catch (Exception x) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)Util.getStackTrace(x));
            }
            return null;
        }
    }

    public int getMagicNumber(Class clazz) {
        Integer i = (Integer)this.classMap.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public int getMagicNumberFromObjectStreamClass(ObjectStreamClass objStream) {
        Integer i = (Integer)this.streamMapClass.get(objStream);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public ObjectStreamClass getObjectStreamClassFromMagicNumber(int magic_number) {
        ObjectStreamClass retval = null;
        retval = (ObjectStreamClass)this.streamMapId.get(new Integer(magic_number));
        return retval;
    }

    public String toString() {
        return this.printMagicMap();
    }

    public String printMagicMap() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.magicMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(":\t").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public String printClassMap() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.classMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        ClassConfigurator test = ClassConfigurator.getInstance(true);
        System.out.println('\n' + test.printMagicMap());
    }
}

