/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.ejb.TransactionRequiredLocalException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockejb.MockContainer;
import org.mockejb.MockEjbSystemException;
import org.mockejb.TransactionPolicy;
import org.mockejb.interceptor.ClassPatternPointcut;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.InvocationContext;

public class TransactionManager
implements Interceptor,
Serializable {
    private static Log logger = LogFactory.getLog((String)(class$org$mockejb$TransactionManager == null ? (class$org$mockejb$TransactionManager = TransactionManager.class$("org.mockejb.TransactionManager")) : class$org$mockejb$TransactionManager).getName());
    public static final String USER_TRANSACTION_JNDI = "javax.transaction.UserTransaction";
    public static final String POLICY_CONTEXT_KEY = "transactionPolicy";
    private static UserTransaction sharedUserTransaction;
    private TransactionPolicy policy = TransactionPolicy.SUPPORTS;
    static /* synthetic */ Class class$org$mockejb$TransactionManager;

    public TransactionManager(TransactionPolicy policy) {
        this.setPolicy(policy);
    }

    public TransactionManager() {
    }

    public TransactionPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(TransactionPolicy policy) {
        this.policy = policy;
    }

    public void intercept(InvocationContext invocationContext) throws Exception {
        UserTransaction newTran = null;
        TransactionPolicy thisCallPolicy = (TransactionPolicy)invocationContext.getOptionalPropertyValue(POLICY_CONTEXT_KEY);
        if (thisCallPolicy == null) {
            thisCallPolicy = this.policy;
        }
        Method method = invocationContext.getTargetMethod();
        if (this.handlePolicy(thisCallPolicy, invocationContext.getTargetObject(), method, invocationContext.getParamVals())) {
            newTran = TransactionManager.getUserTransaction();
            this.log(method, "Begin transaction");
            newTran.begin();
        }
        try {
            invocationContext.proceed();
            this.commitOrRollback(newTran);
        }
        catch (Exception exception) {
            if (MockContainer.isSystemException(exception)) {
                if (newTran != null && (newTran.getStatus() == 0 || newTran.getStatus() == 1)) {
                    newTran.rollback();
                    this.log(method, "Rollback because of system exception");
                }
            } else {
                try {
                    this.commitOrRollback(newTran);
                }
                catch (RollbackException rollbackEx) {
                    logger.error((Object)"There has been rollback exception trying to rollback the transaction set for rollback. Ignoring. ", (Throwable)rollbackEx);
                }
            }
            throw exception;
        }
    }

    private void commitOrRollback(UserTransaction tran) throws SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        if (tran != null) {
            if (tran.getStatus() == 0) {
                tran.commit();
                this.log("Committing transaction");
            } else if (tran.getStatus() == 1) {
                tran.rollback();
                this.log("Rollling back transaction");
            }
        }
    }

    protected boolean handlePolicy(TransactionPolicy policy, Object targetObj, Method method, Object[] args) throws SystemException, NamingException {
        UserTransaction tran;
        boolean newTranRequired = false;
        if (policy == TransactionPolicy.REQUIRED) {
            UserTransaction tran2 = TransactionManager.getUserTransaction();
            newTranRequired = tran2 == null || tran2.getStatus() == 6 || tran2.getStatus() == 3 || tran2.getStatus() == 4 || tran2.getStatus() == 5;
        } else if (policy == TransactionPolicy.REQUIRED_NEW) {
            newTranRequired = true;
        } else if (policy == TransactionPolicy.MANDATORY) {
            UserTransaction tran3 = TransactionManager.getUserTransaction();
            if (tran3 == null || tran3.getStatus() == 6 || tran3.getStatus() == 3 || tran3.getStatus() == 4 || tran3.getStatus() == 5) {
                throw new TransactionRequiredLocalException("Attempt to invoke method with Mandatory policy without transaction context");
            }
        } else if (policy == TransactionPolicy.NEVER && ((tran = TransactionManager.getUserTransaction()) != null || tran.getStatus() == 0)) {
            throw new EJBException("Attempt to invoke method with Never policy inside transaction context");
        }
        return newTranRequired;
    }

    public static UserTransaction getUserTransaction() {
        UserTransaction userTransaction = null;
        if (sharedUserTransaction != null) {
            userTransaction = sharedUserTransaction;
        } else {
            try {
                InitialContext context = new InitialContext();
                userTransaction = (UserTransaction)context.lookup(USER_TRANSACTION_JNDI);
            }
            catch (NamingException namingEx) {
                throw new MockEjbSystemException("Errors while trying to obtain javax.transaction.UserTransaction from JNDI", namingEx);
            }
        }
        return userTransaction;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        sharedUserTransaction = userTransaction;
    }

    private void log(Method method, String message) {
        this.log(message + " for \n" + method);
    }

    protected void log(String message) {
        logger.debug((Object)message);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassPatternPointcut)) {
            return false;
        }
        TransactionManager transactionManager = (TransactionManager)obj;
        return this.policy == transactionManager.policy;
    }

    public int hashCode() {
        return this.policy.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

