/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockejb.BasicEjbDescriptor;
import org.mockejb.EjbBeanAccess;
import org.mockejb.EntityBeanDescriptor;
import org.mockejb.EntityDatabase;
import org.mockejb.GenericHome;
import org.mockejb.MockEjbContext;
import org.mockejb.interceptor.Aspect;
import org.mockejb.interceptor.ClassPointcut;
import org.mockejb.interceptor.InvocationContext;
import org.mockejb.interceptor.MethodPatternPointcut;
import org.mockejb.interceptor.Pointcut;
import org.mockejb.interceptor.PointcutPair;

public class BMPFinderHandler
implements Aspect,
Serializable {
    private static Log logger = LogFactory.getLog((String)(class$org$mockejb$BMPFinderHandler == null ? (class$org$mockejb$BMPFinderHandler = BMPFinderHandler.class$("org.mockejb.BMPFinderHandler")) : class$org$mockejb$BMPFinderHandler).getName());
    protected EntityDatabase entityDatabase;
    static /* synthetic */ Class class$org$mockejb$BMPFinderHandler;
    static /* synthetic */ Class class$javax$ejb$EntityBean;
    static /* synthetic */ Class class$org$mockejb$MockEjbContext;

    public BMPFinderHandler(EntityDatabase entityDatabase) {
        this.entityDatabase = entityDatabase;
    }

    public Pointcut getPointcut() {
        return PointcutPair.and(new MethodPatternPointcut("ejbFind"), new ClassPointcut(class$javax$ejb$EntityBean == null ? (class$javax$ejb$EntityBean = BMPFinderHandler.class$("javax.ejb.EntityBean")) : class$javax$ejb$EntityBean, true));
    }

    public void intercept(InvocationContext invocationContext) throws Exception {
        invocationContext.proceed();
        BasicEjbDescriptor ejbDescriptor = (BasicEjbDescriptor)invocationContext.getPropertyValue("descriptor");
        MockEjbContext ejbContext = (MockEjbContext)invocationContext.getPropertyValue((class$org$mockejb$MockEjbContext == null ? (class$org$mockejb$MockEjbContext = BMPFinderHandler.class$("org.mockejb.MockEjbContext")) : class$org$mockejb$MockEjbContext).getName());
        if (ejbDescriptor instanceof EntityBeanDescriptor && !((EntityBeanDescriptor)ejbDescriptor).isCMP()) {
            EntityBeanDescriptor descriptor = (EntityBeanDescriptor)ejbDescriptor;
            invocationContext.proceed();
            logger.debug((Object)("Intercepted " + invocationContext.getProxyMethod()));
            Object pkOrPkCollection = invocationContext.getReturnObject();
            if (!(pkOrPkCollection instanceof Collection || pkOrPkCollection instanceof EJBObject || pkOrPkCollection instanceof EJBLocalObject)) {
                Object entity = this.findInCacheOrCreate(descriptor, ejbContext, pkOrPkCollection);
                invocationContext.setReturnObject(entity);
            } else if (pkOrPkCollection instanceof Collection) {
                Collection pks = (Collection)pkOrPkCollection;
                Iterator i = pks.iterator();
                ArrayList<Object> resultingCollection = new ArrayList<Object>();
                while (i.hasNext()) {
                    Object pk = i.next();
                    if (pk instanceof EJBObject || pk instanceof EJBLocalObject) continue;
                    Object entity = this.findInCacheOrCreate(descriptor, ejbContext, pk);
                    resultingCollection.add(entity);
                }
                invocationContext.setReturnObject(resultingCollection);
            }
        }
    }

    protected Object findInCacheOrCreate(EntityBeanDescriptor descriptor, MockEjbContext ejbContext, Object pk) throws Exception {
        Object newEntity = this.entityDatabase.find(descriptor.getHomeClass(), pk);
        if (newEntity == null) {
            logger.debug((Object)("Entity " + descriptor.getIfaceClass().getName() + " for PK " + pk + " was not found in the EntityDatabase. Will try to create the new entity and call ejbLoad"));
            GenericHome home = (GenericHome)ejbContext.getEJBLocalHome();
            newEntity = home.genericCreate();
            EjbBeanAccess beanAccess = (EjbBeanAccess)newEntity;
            Object bean = beanAccess.getBean();
            if (!(bean instanceof EntityBean)) {
                throw new EJBException("Can't call ejbLoad on the " + bean.getClass().getName() + " because it does not implement EntityBean interface. You can avod this error by" + " adding the entity with PK " + pk + " to the EntityDatabase.");
            }
            MockEjbContext newEntityContext = beanAccess.getEjbContext();
            newEntityContext.setPrimaryKey(pk);
            EntityBean entityBean = (EntityBean)bean;
            entityBean.ejbLoad();
        }
        return newEntity;
    }

    public boolean equals(Object obj) {
        return obj instanceof BMPFinderHandler && this.entityDatabase.equals(((BMPFinderHandler)obj).entityDatabase);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.entityDatabase.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

