/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.net.URI;
import org.jboss.internal.soa.esb.util.FtpImpl;
import org.jboss.internal.soa.esb.util.FtpsImpl;
import org.jboss.internal.soa.esb.util.SecureFtpImpl;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FTPSEpr;
import org.jboss.soa.esb.addressing.eprs.SFTPEpr;
import org.jboss.soa.esb.util.RemoteFileSystem;
import org.jboss.soa.esb.util.RemoteFileSystemException;

public class RemoteFileSystemFactory {
    private RemoteFileSystemFactory() {
    }

    public static RemoteFileSystem getRemoteFileSystem(FTPEpr p_oEpr, boolean p_bConnect) throws RemoteFileSystemException {
        URI uri = null;
        try {
            uri = p_oEpr.getURI();
            String scheme = uri.getScheme();
            if ("ftp".equals(scheme)) {
                return new FtpImpl(p_oEpr, p_bConnect);
            }
            if ("ftps".equals(scheme)) {
                return new FtpsImpl((FTPSEpr)p_oEpr, p_bConnect);
            }
            if ("sftp".equals(scheme)) {
                return new SecureFtpImpl((SFTPEpr)p_oEpr, p_bConnect);
            }
        }
        catch (Exception e) {
            throw new RemoteFileSystemException(e);
        }
        throw new RemoteFileSystemException("Unknown or unsupported protocol");
    }
}

