/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.soa.esb.helpers.ConfigTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiUtil {
    public static final String ESB_JNDI_PARAMETER_PREFIX = "org.jboss.esb.";

    private JndiUtil() {
    }

    public static Set<String> getJndiPrefixesSet(String jndiPrefixesValue) {
        TreeSet<String> jndiPrefixesSet = new TreeSet<String>();
        jndiPrefixesSet.add("java.naming.");
        jndiPrefixesSet.add(ESB_JNDI_PARAMETER_PREFIX);
        if (jndiPrefixesValue != null) {
            String[] values;
            for (String value : values = jndiPrefixesValue.split(",")) {
                String trim = value.trim();
                if (trim.length() <= 0) continue;
                jndiPrefixesSet.add(trim);
            }
        }
        return jndiPrefixesSet;
    }

    public static String[] getJndiPrefixes(String jndiPrefixesValue) {
        Set<String> jndiPrefixesSet = JndiUtil.getJndiPrefixesSet(jndiPrefixesValue);
        return jndiPrefixesSet.toArray(new String[jndiPrefixesSet.size()]);
    }

    public static Properties parseEnvironmentProperties(ConfigTree config) {
        Properties env = new Properties();
        String[] jndiPrefixes = JndiUtil.getJndiPrefixes(JndiUtil.getPropertyValue(config, "jndi-prefixes"));
        Set<String> attributeNames = config.getAttributeNames();
        block0: for (String name : attributeNames) {
            for (String jndiPrefix : jndiPrefixes) {
                if (!name.startsWith(jndiPrefix)) continue;
                env.setProperty(name, config.getAttribute(name));
                continue block0;
            }
        }
        return env;
    }

    public static String getPropertyValue(ConfigTree config, String propertyName) {
        return config.getAttribute(propertyName);
    }
}

