/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.util.StreamUtils;

public class DeploymentArchive {
    private static Logger logger = Logger.getLogger(DeploymentArchive.class);
    private String archiveName;
    private LinkedHashMap<String, byte[]> entries = new LinkedHashMap();

    public DeploymentArchive(String archiveName) {
        AssertArgument.isNotNull(archiveName, "archiveName");
        this.archiveName = archiveName;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String path, InputStream data) {
        AssertArgument.isNotNullAndNotEmpty(path, "path");
        AssertArgument.isNotNull(data, "data");
        try {
            this.entries.put(this.trimLeadingSlash(path.trim()), StreamUtils.readStream(data));
        }
        finally {
            try {
                data.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Unable to close input stream for archive entry '" + path + "'."));
            }
        }
    }

    public void addEntry(String path, byte[] data) {
        AssertArgument.isNotNullAndNotEmpty(path, "path");
        AssertArgument.isNotNull(data, "data");
        this.entries.put(this.trimLeadingSlash(path.trim()), data);
    }

    public void addEntry(String path) {
        AssertArgument.isNotNullAndNotEmpty(path, "path");
        path = path.trim();
        if (path.endsWith("/")) {
            this.entries.put(this.trimLeadingSlash(path), null);
        } else {
            this.entries.put(this.trimLeadingSlash(path) + "/", null);
        }
    }

    public void addEntry(String path, String resource) throws IOException {
        AssertArgument.isNotNull(path, "path");
        AssertArgument.isNotNull(resource, "resource");
        InputStream resourceStream = this.getClass().getResourceAsStream(resource);
        if (resourceStream == null) {
            throw new IOException("Classpath resource '" + resource + "' no found.");
        }
        this.addEntry(path, resourceStream);
    }

    public void addEntry(Class clazz) throws IOException {
        AssertArgument.isNotNull(clazz, "clazz");
        String className = clazz.getName();
        className = className.replace('.', '/') + ".class";
        this.addEntry(className, "/" + className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toOutputStream(OutputStream outputStream) throws IOException {
        AssertArgument.isNotNull(outputStream, "outputStream");
        ZipOutputStream archiveStream = outputStream instanceof ZipOutputStream ? (ZipOutputStream)outputStream : new ZipOutputStream(outputStream);
        try {
            this.writeEntriesToArchive(archiveStream);
        }
        finally {
            try {
                archiveStream.flush();
            }
            finally {
                try {
                    archiveStream.close();
                }
                catch (IOException e) {
                    logger.info((Object)"Unable to close archive output stream.");
                }
            }
        }
    }

    public JarInputStream toInputStream() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.toOutputStream(outputStream);
        return new JarInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
    }

    private void writeEntriesToArchive(ZipOutputStream archiveStream) throws IOException {
        Set<Map.Entry<String, byte[]>> entrySet = this.entries.entrySet();
        for (Map.Entry<String, byte[]> entry : entrySet) {
            try {
                archiveStream.putNextEntry(new ZipEntry(entry.getKey()));
                if (entry.getValue() != null) {
                    archiveStream.write(entry.getValue());
                }
                archiveStream.closeEntry();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to create archive entry '" + entry.getKey() + "'.").initCause(e);
            }
        }
    }

    private String trimLeadingSlash(String path) {
        StringBuilder builder = new StringBuilder(path);
        while (builder.length() > 0 && builder.charAt(0) == '/') {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }
}

