/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.wstrust.SamlCredential;
import org.jboss.identity.federation.core.wstrust.auth.TokenCallback;
import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

public class JBossSTSTokenCallbackHandler
implements EsbCallbackHandler {
    private Logger log = Logger.getLogger(JBossSTSTokenCallbackHandler.class);
    private AuthenticationRequest authRequest;

    public JBossSTSTokenCallbackHandler() {
    }

    public JBossSTSTokenCallbackHandler(AuthenticationRequest authRequest) {
        this.authRequest = authRequest;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof TokenCallback)) continue;
            TokenCallback tokenCallback = (TokenCallback)callback;
            for (Object object : this.authRequest.getCredentials()) {
                if (!(object instanceof SamlCredential)) continue;
                try {
                    tokenCallback.setToken((Object)((SamlCredential)object).getAssertionAsElement());
                }
                catch (ProcessingException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setAuthenticationRequest(AuthenticationRequest authRequest) {
        this.authRequest = authRequest;
    }

    public void setSecurityConfig(SecurityConfig config) {
    }
}

