/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.login;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.soa.esb.services.security.principals.Group;
import org.jboss.soa.esb.services.security.principals.Role;
import org.jboss.soa.esb.services.security.principals.User;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateLoginModule
implements LoginModule {
    public static final String KEYSTORE_URL = "keyStoreURL";
    public static final String KEYSTORE_PASSWORD = "keyStorePassword";
    public static final String KEYSTORE_TYPE = "keyStoreType";
    public static final String ROLE_PROPERTIES = "rolesPropertiesFile";
    private Logger log = Logger.getLogger(CertificateLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;
    private X509Certificate verifiedCertificate;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        this.assertOptions(this.options);
        this.assertCallbackHandler(this.callbackHandler);
        NameCallback aliasCallback = new NameCallback("Key Alias: ");
        PasswordCallback passwordCallback = new PasswordCallback("Key Password", false);
        ObjectCallback objectCallback = new ObjectCallback("Certificate: ");
        try {
            this.callbackHandler.handle(new Callback[]{aliasCallback, passwordCallback, objectCallback});
        }
        catch (IOException e) {
            throw new LoginException("Failed to invoke callback: " + e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("CallbackHandler does not support: " + e.getCallback());
        }
        X509Certificate callerCert = this.getCallerCertificate(objectCallback);
        String alias = this.getAlias(aliasCallback);
        KeyStore keyStore = this.loadKeyStore();
        try {
            Certificate esbCertificate = keyStore.getCertificate(alias);
            if (esbCertificate == null) {
                throw new LoginException("No certificate found in keystore for alias '" + alias + "'");
            }
            callerCert.verify(esbCertificate.getPublicKey());
            this.verifiedCertificate = callerCert;
            return true;
        }
        catch (KeyStoreException e) {
            throw new LoginException("KeystoreException : " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new LoginException("NoSuchAlgorithmException : " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new LoginException("InvalidKeyExcpetion : " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new LoginException("NoSuchProviderException : " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new LoginException("SignatureException : " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new LoginException("CertificateException : " + e.getMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.verifiedCertificate == null) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        String name = this.verifiedCertificate.getSubjectX500Principal().getName();
        name = name.substring(name.indexOf(61) + 1, name.indexOf(44));
        User authenticatedPrincipal = new User(name);
        principals.add(authenticatedPrincipal);
        this.addRoles(this.subject, authenticatedPrincipal, this.verifiedCertificate, Collections.unmodifiableMap(this.options));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.verifiedCertificate = null;
        return false;
    }

    protected void addRoles(Subject subject, Principal principal, X509Certificate cert, Map<String, ?> options) throws LoginException {
        String roleProperties = (String)options.get(ROLE_PROPERTIES);
        if (roleProperties == null) {
            this.log.warn((Object)"No rolesPropertiesFile was specified hence no roles will be added.");
        } else {
            InputStream resourceAsStream = this.getResourceAsStream(roleProperties, this.getClass());
            if (resourceAsStream == null) {
                throw new LoginException("rolesPropertiesFile was specified as '" + roleProperties + "' but could not be located on the local file system or on the classpath. Please check the configuration.");
            }
            try {
                Properties roles = new Properties();
                roles.load(resourceAsStream);
                String listOfRoles = (String)roles.get(principal.getName());
                if (listOfRoles != null) {
                    this.log.debug((Object)("Roles for " + principal.getName() + " [" + listOfRoles + "]"));
                    for (String role : listOfRoles.split(",")) {
                        this.addRole(role, subject);
                    }
                }
            }
            catch (IOException e) {
                throw new LoginException("IOException while trying to read properties from '" + roleProperties + "'");
            }
            finally {
                try {
                    resourceAsStream.close();
                }
                catch (IOException ignore) {
                    this.log.error((Object)ignore.getMessage(), (Throwable)ignore);
                }
            }
        }
    }

    private void addRole(String roleName, Subject subject) {
        if (roleName != null) {
            Role role = new Role(roleName);
            Set<Group> principals = subject.getPrincipals(Group.class);
            if (principals.isEmpty()) {
                Group group = new Group("Roles");
                group.addMember(role);
                subject.getPrincipals().add((Principal)((Object)group));
            } else {
                for (Group groups : principals) {
                    if (!"Roles".equals(groups.getName())) continue;
                    groups.addMember(role);
                }
            }
        }
    }

    void assertOptions(Map<String, ?> options) throws LoginException {
        if (options == null || options.isEmpty() || !options.containsKey(KEYSTORE_URL) || !options.containsKey(KEYSTORE_PASSWORD)) {
            throw new LoginException(this.getMissingRequiredOptionString(options));
        }
    }

    private KeyStore loadKeyStore() throws LoginException {
        String keyStorePath = (String)this.options.get(KEYSTORE_URL);
        KeyStore keystore = null;
        InputStream in = null;
        try {
            String keyStoreType = (String)this.options.get(KEYSTORE_TYPE);
            if (keyStoreType == null) {
                keyStoreType = KeyStore.getDefaultType();
            }
            keystore = KeyStore.getInstance(keyStoreType);
            in = this.getResourceAsStream(keyStorePath, this.getClass());
            if (in == null) {
                throw new LoginException("Could not open a stream to the keystore '" + keyStorePath + "'");
            }
            keystore.load(in, ((String)this.options.get(KEYSTORE_PASSWORD)).toCharArray());
            this.log.info((Object)("Successfully loaded keystore: '" + keyStorePath + "'"));
        }
        catch (KeyStoreException e) {
            throw new LoginException("KeyStoreException while trying to load keystore '" + keyStorePath + "': " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new LoginException("NoSuchAlgorithm while trying to load keystore '" + keyStorePath + "': " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new LoginException("CertificateException while trying to load keystore '" + keyStorePath + "': " + e.getMessage());
        }
        catch (IOException e) {
            throw new LoginException("IOException while trying to load keystore '" + keyStorePath + "': " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.log.error((Object)("Error while closing stream to keystore '" + keyStorePath + "'"), (Throwable)e);
                }
            }
        }
        return keystore;
    }

    private String getMissingRequiredOptionString(Map<String, ?> options) {
        StringBuilder sb = new StringBuilder();
        sb.append("Options missing [");
        if (options == null || !options.containsKey(KEYSTORE_URL)) {
            sb.append(KEYSTORE_URL).append(", ");
        }
        if (options == null || !options.containsKey(KEYSTORE_PASSWORD)) {
            sb.append(KEYSTORE_PASSWORD).append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private void assertCallbackHandler(CallbackHandler handler) throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No callback handler was specified for CertificateLoginModule.");
        }
    }

    private X509Certificate getCallerCertificate(ObjectCallback objectCallback) throws LoginException {
        Set credentials = (Set)objectCallback.getCredential();
        if (credentials == null || credentials.isEmpty()) {
            throw new LoginException("No X509Certificate was passed to the login module");
        }
        X509Certificate callerCert = null;
        for (Object object : credentials) {
            if (!(object instanceof X509Certificate)) continue;
            callerCert = (X509Certificate)object;
            break;
        }
        if (callerCert == null) {
            throw new LoginException("No X509Certificate was passed to the login module");
        }
        return callerCert;
    }

    private String getAlias(NameCallback callback) throws LoginException {
        String alias = callback.getName();
        if (alias == null) {
            throw new LoginException("No X509Certificate was passed to the login module");
        }
        return callback.getName();
    }

    private InputStream getResourceAsStream(String resourceName, Class<?> caller) {
        URL fileUrl = null;
        File file = null;
        try {
            fileUrl = new URL(resourceName);
            file = new File(fileUrl.getFile());
        }
        catch (MalformedURLException ignored) {
            file = new File(resourceName);
        }
        if (file.exists() && file.isFile()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException ignore) {
                // empty catch block
            }
        }
        return ClassUtil.getResourceAsStream(resourceName, caller);
    }
}

