/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.routing.cbr;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.services.routing.cbr.ContentBasedRouter;
import org.jboss.soa.esb.util.ClassUtil;

public class ContentBasedRouterFactory {
    private static Logger logger = Logger.getLogger(ContentBasedRouterFactory.class);

    public static ContentBasedRouter getRouter(String className) throws MessageRouterException {
        ContentBasedRouter cbr = null;
        logger.log((Priority)Level.DEBUG, (Object)("Going to load " + className));
        try {
            Class cbrClass = ClassUtil.forName(className, ContentBasedRouterFactory.class);
            cbr = (ContentBasedRouter)cbrClass.newInstance();
        }
        catch (ClassNotFoundException cnfex) {
            throw new MessageRouterException("Content Based Router Implementation=" + className + " not found", cnfex);
        }
        catch (Exception e) {
            throw new MessageRouterException(className + " invokation problem. " + e.getLocalizedMessage(), e);
        }
        return cbr;
    }
}

