/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.parameters;

import org.jboss.internal.soa.esb.parameters.ParamFileRepository;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.parameters.ParamRepository;
import org.jboss.soa.esb.util.ClassUtil;

public abstract class ParamRepositoryFactory {
    private static ParamRepository instance;

    public static ParamRepository getInstance() {
        if (instance == null) {
            instance = ParamRepositoryFactory.synchedGetInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParamRepository synchedGetInstance() {
        Class<ParamRepositoryFactory> clazz = ParamRepositoryFactory.class;
        synchronized (ParamRepositoryFactory.class) {
            if (instance == null) {
                String runtimeClassName = Configuration.getParamRepositoryImplClass();
                if (runtimeClassName == null) {
                    instance = new ParamFileRepository();
                } else {
                    try {
                        Class runtimeClass = ClassUtil.forName(runtimeClassName, ParamRepositoryFactory.class);
                        instance = (ParamRepository)runtimeClass.newInstance();
                    }
                    catch (Exception e) {
                        new IllegalStateException("System Configuration Exception: Unable to create system " + ParamRepository.class.getSimpleName() + " instance from runtime class name [" + runtimeClassName + "]", e);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reset() {
        Class<ParamRepositoryFactory> clazz = ParamRepositoryFactory.class;
        synchronized (ParamRepositoryFactory.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

