/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;
import org.jboss.soa.esb.util.Util;

public class NotifyConsole
extends NotificationTarget {
    private MessagePayloadProxy payloadProxy;

    public NotifyConsole(ConfigTree tree) {
        super(tree);
        this.payloadProxy = new MessagePayloadProxy(tree, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
        this.payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
    }

    public void sendNotification(Message message) throws NotificationException {
        try {
            Object obj = this.payloadProxy.getPayload(message);
            if (obj instanceof byte[]) {
                System.out.println("ConsoleNotifier " + Util.getStamp() + "<" + new String((byte[])obj) + ">");
            } else {
                System.out.println("ConsoleNotifier " + Util.getStamp() + "<" + obj + ">");
            }
        }
        catch (MessageDeliverException e) {
            throw new NotificationException(e);
        }
    }
}

