/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.ActionStatusBean;
import org.jboss.soa.esb.listeners.message.MessageAlerts;

public class ServiceMessageCounter
extends NotificationBroadcasterSupport
implements DynamicMBean,
Serializable {
    private Hashtable<String, IntHolder> actionCounterHash;
    private Hashtable<String, IntHolder> actionFailedCounterHash;
    private Hashtable<String, LongHolder> actionProcessTimeHash;
    private Hashtable<String, LongHolder> actionBytesProcessedHash;
    private Hashtable<String, LongHolder> actionBytesFailedHash;
    private Hashtable<String, Long> actionLengthThresholdHash;
    private Hashtable<String, Long> actionTimeThresholdHash;
    private String[] actionNames;
    private final ObjectName listObjectName;
    private int serviceCount;
    private long bytesFailed;
    private long bytesProcessed;
    private long bytesOverall;
    private long timeProcessed;
    private int notificationindex = 0;
    private Long alertTime = new Long("-1");
    private Long alertLength = new Long("-1");
    public static final String SERVICE_LENGTH_NOTIFICATION_TYPE = "org.jboss.esb.message.service.length.alert";
    public static final String SERVICE_TIME_NOTIFICATION_TYPE = "org.jboss.esb.message.service.time.alert";
    public static final String ACTION_LENGTH_NOTIFICATION_TYPE = "org.jboss.esb.message.action.length.alert";
    public static final String ACTION_TIME_NOTIFICATION_TYPE = "org.jboss.esb.message.action.time.alert";
    public static final String RESET_COUNTER = "resetCounter";
    private static final String MESSAGE_COUNTER = "messages successfully processed count";
    private static final String FAILED_MESSAGE_COUNTER = "messages failed count";
    private static final String PROCESSING_TIME = "processing time";
    private static final String BYTES_FAILED = "failed bytes";
    private static final String BYTES_PROCESSED = "processed bytes";
    private static final String OVERALL_SERVICE_COUNT = "overall service message count";
    private static final String OVERALL_BYTES = "overall service count bytes";
    private static final String OVERALL_BYTES_PROCESSED = "overall processedbytes";
    private static final String OVERALL_BYTES_FAILED = "overall failed bytes";
    private static final String OVERALL_TIME_PROCESSED = "overall service time processed";
    private static final String ALERT_TIME = "service alert time";
    private static final String ALERT_LENGTH = "service alert length";
    private static final String ALERT_TIME_DESC = "set service alert time";
    private static final String ALERT_LENGTH_DESC = "set service alert desc";
    private static final String ACTION_ALERT_TIME = "action alert time";
    private static final String ACTION_ALERT_LENGTH = "action alert length";
    private static final String ACTION_ALERT_TIME_DESC = "set action alert time";
    private static final String ACTION_ALERT_LENGTH_DESC = "set action alert length";
    private static final int NANOSECONDS_PER_MILLISECONDS = 1000000;
    private static final Logger logger = Logger.getLogger(ServiceMessageCounter.class);

    public Long getAlertTime() {
        return this.alertTime;
    }

    public void setAlertTime(Long alertTime) {
        this.alertTime = alertTime;
    }

    public Long getAlertLength() {
        return this.alertLength;
    }

    public void setAlertLength(Long alertLength) {
        this.alertLength = alertLength;
    }

    public Long getActionAlertTime() {
        return this.alertTime;
    }

    public void setActionAlertTime(Long alertTime) {
        this.alertTime = alertTime;
    }

    public Long getActionAlertLength() {
        return this.alertLength;
    }

    public void setActionAlertLength(Long alertLength) {
        this.alertLength = alertLength;
    }

    public ServiceMessageCounter(ConfigTree f_config, String objectName) {
        this.actionCounterHash = new Hashtable();
        this.actionFailedCounterHash = new Hashtable();
        this.actionProcessTimeHash = new Hashtable();
        this.actionBytesProcessedHash = new Hashtable();
        this.actionBytesFailedHash = new Hashtable();
        this.actionLengthThresholdHash = new Hashtable();
        this.actionTimeThresholdHash = new Hashtable();
        if (f_config.getAttribute("service-alert-length") != null) {
            this.alertLength = new Long(f_config.getAttribute("service-alert-length"));
        }
        if (f_config.getAttribute("service-alert-time") != null) {
            this.alertTime = new Long(f_config.getAttribute("service-alert-time"));
        }
        this.init(f_config);
        ObjectName listObjectName = null;
        try {
            listObjectName = new ObjectName("jboss.esb:" + objectName);
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception creating MBean object name, counter will be unregistered", (Throwable)ex);
        }
        this.listObjectName = listObjectName;
    }

    private String getActionId(ConfigTree ct) {
        if (ct.getAttribute("name") != null) {
            return ct.getAttribute("name");
        }
        if (ct.getAttribute("action") != null) {
            return ct.getAttribute("action");
        }
        return null;
    }

    public synchronized void incrementTotalCount() {
        ++this.serviceCount;
    }

    private void init(ConfigTree configTree) {
        ConfigTree[] actionList = configTree.getChildren("action");
        int numActions = actionList.length;
        this.actionNames = new String[numActions];
        for (int count = 0; count < numActions; ++count) {
            ConfigTree actionConfig = actionList[count];
            String actionId = this.getActionId(actionConfig);
            this.actionCounterHash.put(actionId + " " + MESSAGE_COUNTER, new IntHolder());
            this.actionFailedCounterHash.put(actionId + " " + FAILED_MESSAGE_COUNTER, new IntHolder());
            this.actionProcessTimeHash.put(actionId + " " + PROCESSING_TIME, new LongHolder());
            this.actionBytesFailedHash.put(actionId + " " + BYTES_FAILED, new LongHolder());
            this.actionBytesProcessedHash.put(actionId + " " + BYTES_PROCESSED, new LongHolder());
            if (actionConfig.getAttribute("action-alert-length") != null) {
                this.actionLengthThresholdHash.put(actionId, new Long(actionConfig.getAttribute("action-alert-length")));
            }
            if (actionConfig.getAttribute("action-alert-time") != null) {
                this.actionTimeThresholdHash.put(actionId, new Long(actionConfig.getAttribute("action-alert-time")));
            }
            this.actionNames[count] = actionId;
        }
        this.serviceCount = 0;
        this.bytesProcessed = 0L;
        this.bytesFailed = 0L;
        this.bytesOverall = 0L;
        this.timeProcessed = new Long(0L);
    }

    public synchronized void resetCounter() {
        this.serviceCount = 0;
        this.bytesProcessed = 0L;
        this.bytesFailed = 0L;
        this.bytesOverall = 0L;
        this.timeProcessed = 0L;
        for (String key : this.actionCounterHash.keySet()) {
            this.actionCounterHash.put(key, new IntHolder());
        }
        for (String key : this.actionFailedCounterHash.keySet()) {
            this.actionFailedCounterHash.put(key, new IntHolder());
        }
        for (String key : this.actionProcessTimeHash.keySet()) {
            this.actionProcessTimeHash.put(key, new LongHolder());
        }
        for (String key : this.actionBytesFailedHash.keySet()) {
            this.actionBytesFailedHash.put(key, new LongHolder());
        }
        for (String key : this.actionBytesProcessedHash.keySet()) {
            this.actionBytesProcessedHash.put(key, new LongHolder());
        }
    }

    public synchronized MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo alertLengthInfo;
        Method alertLengthSetter;
        Method alertLengthGetter;
        String actionId;
        Enumeration<String> keys;
        MBeanAttributeInfo overallTimeProcessed;
        MBeanAttributeInfo overallBytes;
        MBeanAttributeInfo overallBytesFailed;
        MBeanAttributeInfo overallBytesProcessed;
        MBeanAttributeInfo overallCount;
        int count = this.actionCounterHash.size() + this.actionProcessTimeHash.size() + this.actionFailedCounterHash.size() + this.actionBytesProcessedHash.size() + this.actionBytesFailedHash.size() + this.actionLengthThresholdHash.size() + this.actionTimeThresholdHash.size() + 7;
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[count];
        int counter = 0;
        for (String key : this.actionCounterHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionProcessTimeHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Double", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionFailedCounterHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionBytesFailedHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Long", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionBytesProcessedHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Long", "Property " + key, true, false, false);
            ++counter;
        }
        attrs[counter] = overallCount = new MBeanAttributeInfo(OVERALL_SERVICE_COUNT, "java.lang.Integer", "Property overall service message count", true, false, false);
        attrs[++counter] = overallBytesProcessed = new MBeanAttributeInfo(OVERALL_BYTES_PROCESSED, "java.lang.Long", "Property overall processedbytes", true, false, false);
        attrs[++counter] = overallBytesFailed = new MBeanAttributeInfo(OVERALL_BYTES_FAILED, "java.lang.Long", "Property overall failed bytes", true, false, false);
        attrs[++counter] = overallBytes = new MBeanAttributeInfo(OVERALL_BYTES, "java.lang.Long", "Property overall service count bytes", true, false, false);
        attrs[++counter] = overallTimeProcessed = new MBeanAttributeInfo(OVERALL_TIME_PROCESSED, "java.lang.Long", "Property overall service time processed", true, false, false);
        ++counter;
        try {
            MBeanAttributeInfo alertTimeInfo;
            Method alertTimeGetter = this.getClass().getMethod("getAlertTime", new Class[0]);
            Method alertTimeSetter = this.getClass().getMethod("setAlertTime", Long.class);
            attrs[counter] = alertTimeInfo = new MBeanAttributeInfo(ALERT_TIME, ALERT_TIME_DESC, alertTimeGetter, alertTimeSetter);
            ++counter;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        try {
            MBeanAttributeInfo alertLengthInfo2;
            Method alertLengthGetter2 = this.getClass().getMethod("getAlertLength", new Class[0]);
            Method alertLengthSetter2 = this.getClass().getMethod("setAlertLength", Long.class);
            attrs[counter] = alertLengthInfo2 = new MBeanAttributeInfo(ALERT_LENGTH, ALERT_LENGTH_DESC, alertLengthGetter2, alertLengthSetter2);
            ++counter;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        try {
            keys = this.actionLengthThresholdHash.keys();
            while (keys.hasMoreElements()) {
                actionId = keys.nextElement();
                alertLengthGetter = this.getClass().getMethod("getActionAlertLength", new Class[0]);
                alertLengthSetter = this.getClass().getMethod("setActionAlertLength", Long.class);
                attrs[counter] = alertLengthInfo = new MBeanAttributeInfo(actionId + " " + ACTION_ALERT_LENGTH, actionId + " " + ACTION_ALERT_LENGTH_DESC, alertLengthGetter, alertLengthSetter);
                ++counter;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        try {
            keys = this.actionTimeThresholdHash.keys();
            while (keys.hasMoreElements()) {
                actionId = keys.nextElement();
                alertLengthGetter = this.getClass().getMethod("getActionAlertTime", new Class[0]);
                alertLengthSetter = this.getClass().getMethod("setActionAlertTime", Long.class);
                attrs[counter] = alertLengthInfo = new MBeanAttributeInfo(actionId + " " + ACTION_ALERT_TIME, actionId + " " + ACTION_ALERT_TIME_DESC, alertLengthGetter, alertLengthSetter);
                ++counter;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        MBeanNotificationInfo[] notifications = this.getNotificationInfo();
        MBeanOperationInfo[] opers = new MBeanOperationInfo[]{new MBeanOperationInfo(RESET_COUNTER, "Reset the counter", null, "void", 1)};
        return new MBeanInfo(this.getClass().getName(), "Service Message Counter MBean", attrs, null, opers, notifications);
    }

    public synchronized Object getAttribute(String key) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.actionCounterHash.containsKey(key)) {
            return this.actionCounterHash.get((Object)key).value;
        }
        if (this.actionProcessTimeHash.containsKey(key)) {
            long processTotal = this.actionProcessTimeHash.get((Object)key).value;
            String actionId = key.substring(0, key.indexOf(PROCESSING_TIME) - 1);
            int successCount = this.actionCounterHash.get((Object)new StringBuilder().append((String)actionId).append((String)" ").append((String)MESSAGE_COUNTER).toString()).value;
            Double value = null;
            value = successCount > 0 ? Double.valueOf((double)processTotal / (double)successCount) : null;
            return value;
        }
        if (this.actionFailedCounterHash.containsKey(key)) {
            return this.actionFailedCounterHash.get((Object)key).value;
        }
        if (this.actionBytesFailedHash.containsKey(key)) {
            return this.actionBytesFailedHash.get((Object)key).value;
        }
        if (this.actionBytesProcessedHash.containsKey(key)) {
            return this.actionBytesProcessedHash.get((Object)key).value;
        }
        if (OVERALL_SERVICE_COUNT.equals(key)) {
            return this.serviceCount;
        }
        if (OVERALL_BYTES_PROCESSED.equals(key)) {
            return this.bytesProcessed;
        }
        if (OVERALL_BYTES_FAILED.equals(key)) {
            return this.bytesFailed;
        }
        if (OVERALL_BYTES.equals(key)) {
            return this.bytesOverall;
        }
        if (OVERALL_TIME_PROCESSED.equals(key)) {
            return this.timeProcessed;
        }
        if (ALERT_TIME.equals(key)) {
            return this.alertTime;
        }
        if (ALERT_LENGTH.equals(key)) {
            return this.alertLength;
        }
        if (key.endsWith(ACTION_ALERT_LENGTH)) {
            String temp = key.replace(" action alert length", "");
            return this.actionLengthThresholdHash.get(temp);
        }
        if (key.endsWith(ACTION_ALERT_TIME)) {
            String temp = key.replace(" action alert time", "");
            return this.actionTimeThresholdHash.get(temp);
        }
        return null;
    }

    public synchronized AttributeList getAttributes(String[] arg0) {
        AttributeList attributeList = new AttributeList();
        for (String key : this.actionCounterHash.keySet()) {
            Attribute at = new Attribute(key, this.actionCounterHash.get(key).toString());
            attributeList.add(at);
        }
        Attribute overallCount = new Attribute(OVERALL_SERVICE_COUNT, this.serviceCount);
        attributeList.add(overallCount);
        for (String key : this.actionProcessTimeHash.keySet()) {
            long processTotal = this.actionProcessTimeHash.get((Object)key).value;
            String actionId = key.substring(0, key.indexOf(PROCESSING_TIME));
            IntHolder successCount = this.actionCounterHash.get(actionId + " " + MESSAGE_COUNTER);
            String avgTime = null;
            if (successCount != null && successCount.value > 0) {
                avgTime = (double)processTotal / (double)successCount.value + " ns";
            }
            Attribute at = new Attribute(key, avgTime);
            attributeList.add(at);
        }
        for (String key : this.actionFailedCounterHash.keySet()) {
            Attribute at = new Attribute(key, this.actionFailedCounterHash.get(key).toString());
            attributeList.add(at);
        }
        for (String key : this.actionBytesFailedHash.keySet()) {
            Attribute at = new Attribute(key, this.actionBytesFailedHash.get(key).toString());
            attributeList.add(at);
        }
        for (String key : this.actionBytesProcessedHash.keySet()) {
            Attribute at = new Attribute(key, this.actionBytesProcessedHash.get(key).toString());
            attributeList.add(at);
        }
        return attributeList;
    }

    public Object invoke(String method, Object[] arg1, String[] arg2) throws MBeanException, ReflectionException {
        if (method.equalsIgnoreCase(RESET_COUNTER)) {
            this.resetCounter();
            return "Invoking the " + method + " on the lifecycle.";
        }
        throw new ReflectionException(new NoSuchMethodException(method));
    }

    public void setAttribute(Attribute arg0) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (ALERT_TIME.equals(arg0.getName())) {
            this.alertTime = (Long)arg0.getValue();
        } else if (ALERT_LENGTH.equals(arg0.getName())) {
            this.alertLength = (Long)arg0.getValue();
        } else if (arg0.getName().endsWith(ACTION_ALERT_LENGTH)) {
            String temp = arg0.getName().replace(" action alert length", "");
            this.actionLengthThresholdHash.remove(temp);
            this.actionLengthThresholdHash.put(temp, (Long)arg0.getValue());
        } else if (arg0.getName().endsWith(ACTION_ALERT_TIME)) {
            String temp = arg0.getName().replace(" action alert time", "");
            this.actionTimeThresholdHash.remove(temp);
            this.actionTimeThresholdHash.put(temp, (Long)arg0.getValue());
        }
    }

    public AttributeList setAttributes(AttributeList arg0) {
        return null;
    }

    protected void registerMBean() {
        if (this.listObjectName == null) {
            return;
        }
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException ise) {
            return;
        }
        try {
            mbeanServer.registerMBean(this, this.listObjectName);
            MessageAlerts alerts = new MessageAlerts();
            try {
                ObjectName alertObjectName = new ObjectName("jboss.esb:service=MessageAlerts");
                if (!mbeanServer.isRegistered(alertObjectName)) {
                    mbeanServer.registerMBean(alerts, alertObjectName);
                }
                if (this.isAlertsEnabled()) {
                    this.addNotificationListener(alerts, null, null);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"", (Throwable)e);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.warn((Object)"", (Throwable)e);
        }
    }

    protected void unregisterMBean() {
        if (this.listObjectName == null) {
            return;
        }
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException ise) {
            return;
        }
        try {
            mbeanServer.unregisterMBean(this.listObjectName);
        }
        catch (InstanceNotFoundException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.warn((Object)"", (Throwable)e);
        }
    }

    public synchronized void alertService(ActionStatusBean asb) {
        Notification n;
        String alert;
        if (this.getAlertTime() >= 0L && asb.getServiceTime() / 1000000L > this.getAlertTime()) {
            alert = this.getObjectName().toString() + " service alert time " + asb.getServiceTime() / 1000000L + " took longer than " + this.getAlertTime() + " ms";
            logger.warn((Object)alert);
            n = new Notification(ALERT_TIME, this, this.notificationindex++, System.currentTimeMillis(), alert);
            this.sendNotification(n);
        }
        if (this.getAlertLength() >= 0L && asb.getBytesProcessed() > this.getAlertLength()) {
            alert = this.getObjectName().toString() + " service message size " + asb.getBytesProcessed() + " was larger than " + this.getAlertLength() + " bytes";
            logger.warn((Object)alert);
            n = new Notification(ALERT_LENGTH, this, this.notificationindex++, System.currentTimeMillis(), alert);
            this.sendNotification(n);
        }
    }

    public boolean isAlertsEnabled() {
        boolean value = this.getAlertLength() > 0L || this.getAlertTime() > 0L || this.getActionAlertLength() > 0L || this.getActionAlertTime() > 0L;
        return value;
    }

    public synchronized void alertAction(ActionStatusBean asb, String actionName) {
        long actionTime = -1L;
        if (actionName != null && this.actionTimeThresholdHash.containsKey(actionName)) {
            actionTime = this.actionTimeThresholdHash.get(actionName);
        }
        if (actionTime >= 0L && asb.getProcTime() / 1000000L > actionTime) {
            String alert = this.getObjectName().toString() + " service, " + actionName + " action alert time " + asb.getProcTime() / 1000000L + " took longer than " + actionTime + " ms";
            logger.warn((Object)alert);
            Notification n = new Notification(ACTION_ALERT_TIME, this, this.notificationindex++, System.currentTimeMillis(), alert);
            this.sendNotification(n);
        }
        long actionLength = -1L;
        if (actionName != null && this.actionLengthThresholdHash.containsKey(actionName)) {
            actionLength = this.actionLengthThresholdHash.get(actionName);
        }
        if (actionLength >= 0L && asb.getBytesProcessed() > actionLength) {
            String alert = this.getObjectName().toString() + " service, " + actionName + " action message size " + asb.getBytesProcessed() + " was larger than " + actionLength + " bytes";
            logger.warn((Object)alert);
            Notification n = new Notification(ACTION_ALERT_LENGTH, this, this.notificationindex++, System.currentTimeMillis(), alert);
            this.sendNotification(n);
        }
    }

    public synchronized void update(ActionStatusBean asb) {
        String actionName = this.actionNames[asb.getProcCount()];
        if ("SENT".equals(asb.getStatus())) {
            IntHolder count = this.actionCounterHash.get(actionName + " " + MESSAGE_COUNTER);
            ++count.value;
            LongHolder time = this.actionProcessTimeHash.get(actionName + " " + PROCESSING_TIME);
            time.value += asb.getProcTime();
            this.timeProcessed += asb.getProcTime();
            LongHolder bProcessed = this.actionBytesProcessedHash.get(actionName + " " + BYTES_PROCESSED);
            bProcessed.value += asb.getBytesProcessed();
            this.alertAction(asb, actionName);
            if (asb.getProcCount() == this.actionNames.length - 1) {
                this.bytesProcessed += asb.getBytesProcessed();
                this.alertService(asb);
            }
        } else if ("FAILED".equals(asb.getStatus())) {
            IntHolder count = this.actionFailedCounterHash.get(actionName + " " + FAILED_MESSAGE_COUNTER);
            ++count.value;
            LongHolder time = this.actionProcessTimeHash.get(actionName + " " + PROCESSING_TIME);
            time.value += asb.getProcTime();
            this.timeProcessed += asb.getProcTime();
            LongHolder bFailed = this.actionBytesFailedHash.get(actionName + " " + BYTES_FAILED);
            bFailed.value += asb.getBytesProcessed();
            this.bytesFailed += asb.getBytesProcessed();
            this.alertService(asb);
        }
        if (asb.getProcCount() == 0) {
            this.bytesOverall += asb.getBytesProcessed();
        }
    }

    protected ObjectName getObjectName() {
        return this.listObjectName;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{SERVICE_TIME_NOTIFICATION_TYPE, SERVICE_LENGTH_NOTIFICATION_TYPE, ACTION_TIME_NOTIFICATION_TYPE, ACTION_LENGTH_NOTIFICATION_TYPE}, "javax.management.Notification", "JBoss ESB message alert notification")};
    }

    private static final class LongHolder
    implements Serializable {
        long value;

        private LongHolder() {
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    private static final class IntHolder
    implements Serializable {
        int value;

        private IntHolder() {
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

