/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.util.DefaultReplyTo;
import org.jboss.soa.esb.couriers.Courier;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

public class Invoker {
    private static Logger _logger = Logger.getLogger(Invoker.class);

    public static void invoke(Message message, String category, String name) throws RegistryException, MalformedEPRException, CourierException, ServiceNotFoundException {
        try {
            Invoker.invokeAndAwaitResponse(message, category, name, -1);
        }
        catch (CourierTimeoutException e) {
            _logger.fatal((Object)"Unexpected CourierTimeoutException caught!");
        }
    }

    public static Message invokeAndAwaitResponse(Message message, String category, String name, int maxWaitMillis) throws RegistryException, MalformedEPRException, CourierException, CourierTimeoutException, ServiceNotFoundException {
        Call call = message.getHeader().getCall();
        List<EPR> eprs = RegistryUtil.getEprs(category, name);
        if (null == eprs || eprs.size() < 1) {
            throw new RegistryException("No eprs found for <" + category + "," + name + ">");
        }
        EPR service = (EPR)eprs.iterator().next();
        call.setTo(service);
        return Invoker.invokeAndAwaitResponse(message, maxWaitMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message invokeAndAwaitResponse(Message outgoing, int maxWaitMillis) throws CourierException, MalformedEPRException, CourierTimeoutException {
        Message message;
        Call call = outgoing.getHeader().getCall();
        if (null == call.getMessageID()) {
            URI uri = null;
            try {
                uri = new URI(UUID.randomUUID().toString());
            }
            catch (URISyntaxException e) {
                _logger.fatal((Object)("Failed to create URI: " + e));
                throw new CourierException(e);
            }
            call.setMessageID(uri);
        }
        Courier sender = CourierFactory.getCourier(call.getTo());
        TwoWayCourier receiver = null;
        try {
            boolean waitForResponse;
            boolean bl = waitForResponse = maxWaitMillis > 0;
            if (waitForResponse) {
                if (null == call.getReplyTo()) {
                    call.setReplyTo(DefaultReplyTo.getReplyTo(call.getTo()));
                }
                receiver = CourierFactory.getPickupCourier(call.getReplyTo());
            }
            sender.deliver(outgoing);
            message = waitForResponse ? receiver.pickup(maxWaitMillis) : null;
        }
        catch (Throwable throwable) {
            CourierUtil.cleanCourier(sender);
            CourierUtil.cleanCourier(receiver);
            throw throwable;
        }
        CourierUtil.cleanCourier(sender);
        CourierUtil.cleanCourier((PickUpOnlyCourier)receiver);
        return message;
    }
}

