/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.util.BeanConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBeanConfigurator
extends BeanConfigurator {
    private static final List<String> ignored = Arrays.asList("action", "action", "class", "listenerClass", "process");
    private static final Map<String, String> optionalFields = ActionBeanConfigurator.getOptionalFieldsMap();

    ActionBeanConfigurator(ConfigTree config, Object bean) {
        ConfigTree[] children;
        AssertArgument.isNotNull(config, "config");
        this.setBean(bean);
        List<KeyValuePair> pairs = config.attributesAsList();
        ConfigTree parent = config.getParent();
        if (parent != null) {
            List<KeyValuePair> parentAttributes = parent.attributesAsList();
            for (KeyValuePair attr : parentAttributes) {
                String newKeyName = optionalFields.get(attr.getKey());
                if (newKeyName == null) continue;
                pairs.add(new KeyValuePair(newKeyName, attr.getValue()));
            }
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (KeyValuePair kvp : pairs) {
            if (ignored.contains(kvp.getKey())) continue;
            properties.put(kvp.getKey(), kvp.getValue());
        }
        for (ConfigTree child : children = config.getAllChildren()) {
            properties.put(child.getName(), child.toXml());
        }
        this.setProperties(properties);
        this.setOptionalFields(optionalFields.values());
    }

    static Map<String, String> getOptionalFieldsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("service-category", "serviceCategory");
        map.put("service-name", "serviceName");
        map.put("service-description", "serviceDescription");
        map.put("maxThreads", "maxThreads");
        map.put("mep", "mep");
        return map;
    }
}

