/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies.cache;

import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jgroups.View;

public class DeleteOnEvictTreeCacheListener
implements TreeCacheListener {
    private Logger log = Logger.getLogger(DeleteOnEvictTreeCacheListener.class);
    private TreeCache treeCache;

    public DeleteOnEvictTreeCacheListener(TreeCache treeCache) {
        if (treeCache == null) {
            throw new IllegalArgumentException("treeCache must not be null");
        }
        this.treeCache = treeCache;
    }

    public void nodeEvicted(Fqn fqn) {
        try {
            this.treeCache.remove(fqn);
            this.log.debug((Object)("removed fqn : " + fqn));
        }
        catch (CacheException e) {
            this.log.error((Object)("Exception while trying to remove data for fqn : " + fqn), (Throwable)e);
        }
    }

    public void cacheStarted(TreeCache arg0) {
    }

    public void cacheStopped(TreeCache arg0) {
    }

    public void nodeCreated(Fqn arg0) {
    }

    public void nodeLoaded(Fqn arg0) {
    }

    public void nodeModified(Fqn arg0) {
    }

    public void nodeRemoved(Fqn arg0) {
    }

    public void nodeVisited(Fqn arg0) {
    }

    public void viewChange(View arg0) {
    }
}

