/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.web.tomcat.security.JBossSecurityMgrRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerDelegate {
    public static final String defaultVHost = "localhost";
    public static final Map<String, Integer> hostReference = new HashMap<String, Integer>();
    public static final Map<String, Integer> connectorReference = new HashMap<String, Integer>();
    public static final String DOMAIN_NAME = "jboss.esb.tomcat";
    private static MBeanServer mbeanServer = null;
    private static HttpServerDelegate instance = null;

    private HttpServerDelegate() {
    }

    public static synchronized HttpServerDelegate getInstance() {
        if (instance == null) {
            mbeanServer = MBeanServerLocator.locateJBoss();
            instance = new HttpServerDelegate();
            instance.createEngine();
        }
        return instance;
    }

    private void createEngine() {
        try {
            Set<ObjectInstance> engines;
            Set<ObjectInstance> services = mbeanServer.queryMBeans(new ObjectName("jboss.esb.tomcat:type=Service"), null);
            if (services.size() == 0) {
                StandardService service = new StandardService();
                service.setName("jboss.esb.catalina");
                Registry.getRegistry().registerComponent((Object)service, new ObjectName("jboss.esb.tomcat:type=Service"), null);
            }
            if ((engines = mbeanServer.queryMBeans(new ObjectName("jboss.esb.tomcat:type=Engine"), null)).size() == 0) {
                StandardEngine engine = new StandardEngine();
                JBossSecurityMgrRealm realm = new JBossSecurityMgrRealm();
                realm.setCertificatePrincipal("org.jboss.security.auth.certs.SubjectDNMapping");
                realm.setAllRolesMode("authOnly");
                engine.setRealm((Realm)realm);
                Registry.getRegistry().registerComponent((Object)realm, new ObjectName("jboss.esb.tomcat:type=Realm"), null);
                engine.setDefaultHost(defaultVHost);
                engine.setDomain(DOMAIN_NAME);
                engine.setName("jboss.esb.tomcat.engine");
                mbeanServer.setAttribute(new ObjectName("jboss.esb.tomcat:type=Service"), new Attribute("container", engine));
                Registry.getRegistry().registerComponent((Object)engine, new ObjectName("jboss.esb.tomcat:type=Engine"), null);
            }
            mbeanServer.invoke(new ObjectName("jboss.esb.tomcat:type=Service"), "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create tomcat engine in ESB", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createHost(String host) throws Exception {
        ObjectName hostName = new ObjectName("jboss.esb.tomcat:host=" + host + ",type=Host");
        ObjectName stardardEngineName = new ObjectName("jboss.esb.tomcat:type=Engine");
        Set<ObjectName> hosts = mbeanServer.queryNames(hostName, null);
        if (hosts.size() == 0) {
            StandardHost newHost = new StandardHost();
            newHost.setName(host);
            mbeanServer.invoke(stardardEngineName, "addChild", new Object[]{newHost}, new String[]{Container.class.getName()});
            Map<String, Integer> map = hostReference;
            synchronized (map) {
                hostReference.put(host, 1);
            }
        } else {
            this.updateReference(hostReference, host, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnector(String address, String port, List<KeyValuePair> properties) throws Exception {
        ObjectName standardServiceName = new ObjectName("jboss.esb.tomcat:type=Service");
        Set connectors = this.queryObjects("jboss.esb.tomcat:address=" + URLEncoder.encode("/" + address) + ",port=" + port + ",type=Connector,*");
        if (connectors.size() == 0) {
            Connector connector = null;
            connector = new Connector("org.apache.coyote.http11.Http11Protocol");
            connector.setPort(Integer.parseInt(port));
            for (KeyValuePair property : properties) {
                boolean effected = IntrospectionUtils.setProperty((Object)connector, (String)property.getKey(), (String)property.getValue());
                if (effected) continue;
                connector.setProperty(property.getKey(), property.getValue());
            }
            connector.setAttribute("address", (Object)address);
            mbeanServer.invoke(standardServiceName, "addConnector", new Object[]{connector}, new String[]{Connector.class.getName()});
            Map<String, Integer> map = connectorReference;
            synchronized (map) {
                connectorReference.put(port, 1);
            }
        } else {
            this.updateReference(connectorReference, port, 1);
        }
    }

    public void addContext(String host, StandardContext ctx) throws Exception {
        ObjectName hostName = new ObjectName("jboss.esb.tomcat:host=" + host + ",type=Host");
        this.addContext(hostName, ctx);
    }

    public void addContext(ObjectName hostName, StandardContext ctx) throws Exception {
        mbeanServer.invoke(hostName, "addChild", new Object[]{ctx}, new String[]{Container.class.getName()});
    }

    public void destroyContext(String host, String address, String port, String httpContext) throws Exception {
        Set connectors;
        ObjectName contextName = new ObjectName("jboss.esb.tomcat:j2eeType=WebModule,name=//" + host + httpContext + ",*");
        Set<ObjectName> engines = mbeanServer.queryNames(contextName, null);
        if (engines.isEmpty()) {
            throw new InstanceNotFoundException("HttpContext:" + httpContext + "not found");
        }
        contextName = engines.iterator().next();
        mbeanServer.invoke(contextName, "destroy", new Object[0], new String[0]);
        this.updateReference(hostReference, host, -1);
        this.updateReference(connectorReference, port, -1);
        Integer obj = hostReference.get(host);
        if (obj != null && obj == 0) {
            ObjectName standardHostName = new ObjectName("jboss.esb.tomcat:host=" + host + ",type=Host");
            mbeanServer.invoke(standardHostName, "destroy", new Object[0], new String[0]);
        }
        if ((obj = connectorReference.get(port)) != null && obj == 0 && (connectors = this.queryObjects("jboss.esb.tomcat:address=" + URLEncoder.encode("/" + address) + ",port=" + port + ",type=Connector,*")).size() > 0) {
            ObjectName connector = (ObjectName)connectors.iterator().next();
            mbeanServer.invoke(connector, "destroy", new Object[0], new String[0]);
        }
    }

    public void destroyContext(ObjectName contextName) throws Exception {
        mbeanServer.invoke(contextName, "destroy", new Object[0], new String[0]);
    }

    public Set queryObjects(String objectName) throws Exception {
        ObjectName name = new ObjectName(objectName);
        Set<ObjectName> objects = mbeanServer.queryNames(name, null);
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReference(Map refrenceMap, String key, int increment) {
        Map map = refrenceMap;
        synchronized (map) {
            if (refrenceMap.get(key) != null) {
                int count = (Integer)refrenceMap.get(key);
                if (count == 0) {
                    return;
                }
                refrenceMap.put(key, count + increment);
            }
        }
    }
}

