/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.ContextConfig;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.naming.Util;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.listeners.gateway.HttpDispatchServlet;
import org.jboss.soa.esb.listeners.gateway.HttpMessageComposer;
import org.jboss.soa.esb.listeners.gateway.HttpServerDelegate;
import org.jboss.soa.esb.listeners.lifecycle.AbstractManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.UncomposedMessageDeliveryAdapter;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryFactory;
import org.jboss.soa.esb.util.ClassUtil;

public class HttpGatewayListener
extends AbstractManagedLifecycle {
    private static Logger logger = Logger.getLogger(HttpGatewayListener.class);
    public static final String SERVER_HOST_TAG = "http_host";
    public static final String SERVER_PORT_TAG = "http_port";
    public static final String REQUEST_CONTEXT_TAG = "http_context";
    public static final String DISPATCH_SERVLET_CLASS = "dispatch_servlet";
    public static final String ALLOW_HTTP_METHOD = "allowHttpMethod";
    public static final String AUTH_METHOD = "authMethod";
    public static final String SECURITY_DOMAIN = "securityDomain";
    public static final String SECURITY_ROLE = "securityRole";
    public String host = null;
    public String address = null;
    public String port = null;
    public String maxThreads = "5";
    public String httpContext = null;
    private EPR endpointReference = null;
    private String serviceCategory = null;
    private String serviceName = null;
    private StandardContext ctx = null;
    private String dispatchServletClassName = HttpDispatchServlet.class.getName();
    private Object protocol = "http";
    private boolean useJBossWebServletEngine = false;

    public HttpGatewayListener(ConfigTree config) throws ConfigurationException {
        super(config);
        String asyncResponse;
        boolean synchronous;
        this.host = config.getAttribute(SERVER_HOST_TAG);
        try {
            this.address = InetAddress.getByName(this.host).getHostAddress();
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid host configuration");
        }
        this.port = config.getAttribute(SERVER_PORT_TAG);
        this.httpContext = config.getAttribute(REQUEST_CONTEXT_TAG);
        this.serviceCategory = config.getAttribute("target-service-category");
        this.serviceName = config.getAttribute("target-service-name");
        if (config.getAttribute(DISPATCH_SERVLET_CLASS) != null) {
            this.dispatchServletClassName = config.getAttribute(DISPATCH_SERVLET_CLASS);
        }
        boolean bl = synchronous = !config.getAttribute("synchronous", "true").equalsIgnoreCase("false");
        if (!synchronous && (asyncResponse = config.getAttribute("asyncResponse")) != null && ClassUtil.getResourceAsStream(asyncResponse, this.getClass()) == null) {
            throw new ConfigurationException("Asynchronous response resource file '" + asyncResponse + "' not found on classpath.");
        }
        if (config.getAttribute(ALLOW_HTTP_METHOD) != null) {
            String allowMethods = config.getAttribute(ALLOW_HTTP_METHOD);
            String[] methods = allowMethods.split(",");
            ArrayList<String> standardMesthods = new ArrayList<String>();
            standardMesthods.add("GET");
            standardMesthods.add("POST");
            standardMesthods.add("DELETE");
            standardMesthods.add("PUT");
            standardMesthods.add("OPTIONS");
            standardMesthods.add("HEAD");
            standardMesthods.add("TRACE");
            for (String method : methods) {
                if (standardMesthods.contains(method.toUpperCase())) continue;
                throw new ConfigurationException("Invalid allow http method configuration, please specify the specify method list with comma-separated(e.g. POST,GET,PUT,DELETE");
            }
        }
        try {
            Set contexts;
            Set ports = HttpServerDelegate.getInstance().queryObjects("jboss.web:port=" + this.port + ",type=Connector,*");
            if (ports.size() > 0) {
                contexts = HttpServerDelegate.getInstance().queryObjects("jboss.web:host=localhost,path=" + this.httpContext + ",*");
                if (contexts.size() > 0) {
                    throw new ConfigurationException("There is already an http context named " + this.httpContext + ", choose another one");
                }
                logger.info((Object)("This http gateway listener [" + config.getAttribute("name") + "] will be started on JBoss default port " + this.port + " and the configured host will be ignored."));
                this.useJBossWebServletEngine = true;
            } else {
                contexts = HttpServerDelegate.getInstance().queryObjects("jboss.esb.tomcat:host=localhost,path=" + this.httpContext + ",*");
                if (contexts.size() > 0) {
                    throw new ConfigurationException("There is already an http context named " + this.httpContext + ", choose another one");
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        if (config.getAttribute(AUTH_METHOD) != null) {
            if (config.getAttribute(SECURITY_DOMAIN) == null) {
                throw new ConfigurationException("Security domain configuration for this context not found for http authentication method " + config.getAttribute(AUTH_METHOD));
            }
            if (config.getAttribute(SECURITY_ROLE) == null) {
                throw new ConfigurationException("Security role configuration for this context not found for http authentication method " + config.getAttribute(AUTH_METHOD));
            }
        }
    }

    protected void doStart() throws ManagedLifecycleException {
        try {
            this.startHttpServer();
        }
        catch (Exception e) {
            throw new ManagedLifecycleException("Failed to start Http gateway listener", e);
        }
        try {
            this.registerEndpoint();
        }
        catch (Throwable t) {
            logger.error((Object)("Unable to register service endpoint '" + this.endpointReference.getAddr().getAddress() + "' for service '" + this.serviceCategory + ":" + this.serviceName + "'.  Stopping Http Listener Server..."), t);
            try {
                this.stopHttpServer();
            }
            catch (Exception e) {
                throw new ManagedLifecycleException("Failed to stop Http gateway listener", e);
            }
        }
    }

    protected void doStop() throws ManagedLifecycleException {
        this.unregisterEndpoint();
        try {
            this.stopHttpServer();
        }
        catch (Exception e) {
            throw new ManagedLifecycleException("Failed to stop Http gateway listener", e);
        }
    }

    protected void doInitialise() throws ManagedLifecycleException {
    }

    protected void doDestroy() throws ManagedLifecycleException {
    }

    protected void startHttpServer() throws Exception {
        this.ctx = new StandardContext();
        final URL[] urls = new URL[]{};
        URLClassLoader urlClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, this.getClass().getClassLoader());
            }
        });
        WebappLoader loader = new WebappLoader((ClassLoader)urlClassLoader);
        this.ctx.setLoader((Loader)loader);
        ContextConfig ctxCfg = new ContextConfig();
        this.ctx.addLifecycleListener((LifecycleListener)ctxCfg);
        ctxCfg.setDefaultWebXml("org/apache/catalin/startup/NO_DEFAULT_XML");
        this.ctx.setPath(this.httpContext);
        this.ctx.setDocBase(".");
        ClassLoader oldloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        this.initWebappDefaults(this.ctx);
        Thread.currentThread().setContextClassLoader(oldloader);
        String encodedAddr = URLEncoder.encode("/" + this.address);
        String connectorName = "jboss.esb.tomcat:address=" + encodedAddr + ",port=" + this.port + ",type=Connector";
        if (!this.useJBossWebServletEngine) {
            HttpServerDelegate.getInstance().createHost("localhost");
            List<KeyValuePair> properties = this.getConfig().childPropertyList();
            if (this.getConfig().getAttribute("maxThreads") != null) {
                this.maxThreads = this.getConfig().getAttribute("maxThreads");
            }
            properties.add(new KeyValuePair("maxThreads", this.maxThreads));
            HttpServerDelegate.getInstance().createConnector(this.address, this.port, properties);
            HttpServerDelegate.getInstance().addContext("localhost", this.ctx);
        } else {
            connectorName = "jboss.web:port=" + this.port + ",type=Connector,*";
            HttpServerDelegate.getInstance().addContext(new ObjectName("jboss.web:host=localhost,type=Host"), this.ctx);
        }
        Set connectors = HttpServerDelegate.getInstance().queryObjects(connectorName);
        if (connectors.isEmpty()) {
            throw new InstanceNotFoundException("ObjectName: " + connectorName + " Not found");
        }
        ObjectName obj = (ObjectName)connectors.iterator().next();
        try {
            this.protocol = MBeanServerLocator.locateJBoss().getAttribute(obj, "scheme");
        }
        catch (Exception e) {
            this.protocol = "http";
        }
    }

    private void registerEndpoint() throws ConfigurationException, RegistryException {
        try {
            this.endpointReference = new HTTPEpr(new URI(this.protocol + "://" + this.address + ":" + this.port + this.httpContext));
            this.endpointReference.getAddr().addExtension("is-gateway", "true");
        }
        catch (Exception e) {
            throw new RegistryException("Tomcat gateway listener registration failed", e);
        }
        String serviceDescription = this.getConfig().getAttribute("service-description");
        RegistryFactory.getRegistry().registerEPR(this.serviceCategory, this.serviceName, serviceDescription, this.endpointReference, this.endpointReference.getAddr().getAddress());
    }

    private void unregisterEndpoint() {
        try {
            RegistryFactory.getRegistry().unRegisterEPR(this.serviceCategory, this.serviceName, this.endpointReference);
        }
        catch (Throwable t) {
            logger.error((Object)("Unable to unregister service endpoint '" + this.endpointReference.getAddr().getAddress() + "' for service '" + this.serviceCategory + ":" + this.serviceName + "'."), t);
        }
    }

    public void stopHttpServer() throws Exception {
        if (!this.useJBossWebServletEngine) {
            HttpServerDelegate.getInstance().destroyContext("localhost", this.address, this.port, this.httpContext);
        } else {
            Set contexts = HttpServerDelegate.getInstance().queryObjects("jboss.web:j2eeType=WebModule,name=//localhost" + this.httpContext + ",*");
            for (ObjectName obName : contexts) {
                HttpServerDelegate.getInstance().destroyContext(obName);
            }
        }
    }

    protected UncomposedMessageDeliveryAdapter createDeliveryAdapter() throws ConfigurationException {
        return UncomposedMessageDeliveryAdapter.getGatewayDeliveryAdapter(this.getConfig(), new HttpMessageComposer());
    }

    protected void initWebappDefaults(StandardContext ctx) throws Exception {
        if (this.isHttpAuthConfiured()) {
            Context envCtx;
            InitialContext iniCtx = new InitialContext();
            try {
                envCtx = (Context)iniCtx.lookup("java:comp/env");
            }
            catch (NamingException e) {
                envCtx = (Context)iniCtx.lookup("java:comp");
                envCtx = envCtx.createSubcontext("env");
            }
            String securityDomain = this.getConfig().getAttribute(SECURITY_DOMAIN);
            Util.bind((Context)envCtx, (String)"security/securityMgr", (Object)new LinkRef(securityDomain));
            Util.bind((Context)envCtx, (String)"security/realmMapping", (Object)new LinkRef(securityDomain));
            Util.bind((Context)envCtx, (String)"security/security-domain", (Object)new LinkRef(securityDomain));
            Util.bind((Context)envCtx, (String)"security/subject", (Object)new LinkRef(securityDomain));
        }
        StandardWrapper sw = (StandardWrapper)ctx.createWrapper();
        sw.setServletClass(this.dispatchServletClassName);
        sw.setName("default");
        ctx.addChild((Container)sw);
        ctx.getServletContext().setAttribute("config", (Object)this.getConfig());
        sw.addInitParameter("listings", "false");
        sw.setLoadOnStartup(1);
        try {
            sw.start();
        }
        catch (LifecycleException e) {
            logger.error((Object)"Unexpected error when start the default servlet");
            throw e;
        }
        ctx.addServletMapping("/", "default");
        if (this.isHttpAuthConfiured()) {
            String securityRole = this.getConfig().getAttribute(SECURITY_ROLE);
            SecurityConstraint constraint = new SecurityConstraint();
            constraint.addAuthRole(securityRole);
            SecurityCollection collection = new SecurityCollection("all");
            collection.addPattern("/*");
            constraint.addCollection(collection);
            ctx.addConstraint(constraint);
            ctx.addSecurityRole(securityRole);
            String authMethod = this.getConfig().getAttribute(AUTH_METHOD);
            LoginConfig config = new LoginConfig(authMethod, securityRole, null, null);
            ctx.setLoginConfig(config);
        }
    }

    private boolean isHttpAuthConfiured() {
        return this.getConfig().getAttribute(AUTH_METHOD) != null;
    }
}

