/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.scripting.GroovyActionProcessor;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.lifecycle.AbstractThreadedManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.BasicMessageComposer;
import org.jboss.soa.esb.listeners.message.UncomposedMessageDeliveryAdapter;
import org.jboss.soa.esb.util.ClassUtil;

public class GroovyGateway
extends AbstractThreadedManagedLifecycle {
    private static Logger logger = Logger.getLogger(GroovyGateway.class);
    private Script script;

    public GroovyGateway(ConfigTree config) throws ConfigurationException {
        super(config);
        String scriptPath = config.getAttribute("script");
        scriptPath = this.mapToPrebundledScript(scriptPath);
        if (scriptPath == null) {
            throw new ConfigurationException("No Groovy script specified on listener config " + config.getAttribute("name"));
        }
        try {
            GroovyShell shell = new GroovyShell();
            this.script = shell.parse(GroovyActionProcessor.getScriptFromClasspath(scriptPath));
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading Groovy script '" + scriptPath + "' stream.", e);
        }
    }

    private String mapToPrebundledScript(String scriptName) {
        try {
            String scriptPath = ClassUtil.getPath(this.getClass().getPackage()) + "/scripts/" + scriptName;
            if (!scriptPath.endsWith(".groovy")) {
                scriptPath = scriptPath + ".groovy";
            }
            if (GroovyActionProcessor.getScriptFromClasspath(scriptPath) != null) {
                return scriptPath;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return scriptName;
    }

    protected void doInitialise() throws ManagedLifecycleException {
        try {
            Binding binding = new Binding();
            UncomposedMessageDeliveryAdapter deliveryAdapter = this.createDeliveryAdapter();
            binding.setVariable("config", (Object)this.getConfig());
            binding.setVariable("gateway", (Object)this);
            binding.setVariable("listener", (Object)this);
            if (deliveryAdapter != null) {
                binding.setVariable("deliveryAdapter", (Object)deliveryAdapter);
            }
            this.script.setBinding(binding);
        }
        catch (ConfigurationException e) {
            throw new ManagedLifecycleException("Unable to construct message delivery adapter.", e);
        }
    }

    protected void doRun() {
        logger.info((Object)("Starting Groovy Gateway " + this.getConfig().getName()));
        this.script.run();
        logger.info((Object)("Stopping Groovy Gateway " + this.getConfig().getName()));
    }

    protected UncomposedMessageDeliveryAdapter createDeliveryAdapter() throws ConfigurationException {
        if (this.getConfig().getAttribute("target-service-name") != null) {
            return UncomposedMessageDeliveryAdapter.getGatewayDeliveryAdapter(this.getConfig(), new BasicMessageComposer());
        }
        return null;
    }
}

