/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.DeploymentException;
import org.jboss.internal.soa.esb.util.JBossDeployerUtil;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.jboss.soa.esb.listeners.deployers.mc.EsbMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsbConfigParser
extends AbstractVFSParsingDeployer<EsbMetaData> {
    private static final String ESB_DEPLOYMENT_XML = "META-INF/deployment.xml";
    private static EsbConfigFileFilter configFileFilter = new EsbConfigFileFilter();
    private String actionArtifactsFile = "/actionArtifactMap.properties";
    private Properties actionArtifactProperties;
    private String esbDeploymentPrefix = "jboss.esb:deployment=";
    private String esbArtifactName = "jbossesb";
    private String warDeploymentPrefix = "jboss.web.deployment:war=";
    private Logger log = Logger.getLogger(EsbConfigParser.class);

    public EsbConfigParser() {
        super(EsbMetaData.class);
        this.setSuffix("-esb.xml");
        this.setJarExtension(".esb");
        this.setStage(DeploymentStages.PARSE);
    }

    public void create() throws Exception {
        this.log.info((Object)"Created");
        this.actionArtifactProperties = JBossDeployerUtil.getArtifactProperties(this.actionArtifactsFile);
    }

    protected EsbMetaData parse(VFSDeploymentUnit deploymentUnit, VirtualFile file, EsbMetaData metadata) throws Exception {
        String esbConfigXml = this.readEsbConfigFile(file);
        String archiveName = deploymentUnit.getSimpleName();
        String deploymentName = this.getDeploymentName(deploymentUnit);
        ModelAdapter model = JBossDeployerUtil.getJbossEsbModel(esbConfigXml);
        Set<ObjectName> dependencies = this.getDependenciesFromDeploymentXml(deploymentUnit);
        Set<ObjectName> actionDependencies = this.getActionDependencies(deploymentName, model, this.actionArtifactProperties);
        dependencies.addAll(actionDependencies);
        EsbMetaData esbMetaData = new EsbMetaData(esbConfigXml, archiveName, deploymentName, dependencies, model);
        this.log.debug((Object)("Parsed ESB configuration'" + esbMetaData + "'"));
        return esbMetaData;
    }

    private String readEsbConfigFile(VirtualFile file) throws DeploymentException, IOException {
        List esbConfigFiles;
        if (file.getName().endsWith("-esb.xml")) {
            return JBossDeployerUtil.readEsbConfig(file.openStream());
        }
        VirtualFile child = file.getChild("META-INF");
        this.log.info((Object)("META-INF : " + child));
        try {
            esbConfigFiles = file.getChildrenRecursively((VirtualFileFilter)configFileFilter);
        }
        catch (IOException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        if (esbConfigFiles.size() == 0) {
            throw new DeploymentException("No JBossESB configuration could be located the archive '" + file + "'");
        }
        if (esbConfigFiles.size() > 1) {
            throw new DeploymentException("Only one JBossESB configuration can exist in an archive. Please check '" + file + "'");
        }
        return JBossDeployerUtil.readEsbConfig(((VirtualFile)esbConfigFiles.get(0)).openStream());
    }

    Set<ObjectName> getDependenciesFromDeploymentXml(VFSDeploymentUnit unit) throws DeploymentException {
        HashSet<ObjectName> dependencies;
        block7: {
            dependencies = new HashSet<ObjectName>();
            VirtualFile deploymentXml = unit.getFile(ESB_DEPLOYMENT_XML);
            try {
                if (deploymentXml == null || !deploymentXml.exists()) break block7;
                try {
                    Element depend;
                    String deployable;
                    Iterator esbDepends;
                    XmlFileLoader xfl = new XmlFileLoader();
                    Element jboss = xfl.getDocument(deploymentXml.openStream(), ESB_DEPLOYMENT_XML).getDocumentElement();
                    Iterator depends = MetaData.getChildrenByTagName((Element)jboss, (String)"depends");
                    if (depends != null) {
                        while (depends.hasNext()) {
                            Element depend2 = (Element)depends.next();
                            dependencies.add(new ObjectName(MetaData.getElementContent((Element)depend2)));
                        }
                    }
                    if ((esbDepends = MetaData.getChildrenByTagName((Element)jboss, (String)"esb-depends")) != null && esbDepends.hasNext() && (deployable = MetaData.getElementContent((Element)(depend = (Element)esbDepends.next()))).endsWith(".war")) {
                        String objectName = this.warDeploymentPrefix + "/" + deployable.substring(0, deployable.indexOf(46));
                        dependencies.add(new ObjectName(objectName));
                    }
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException(e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException e) {
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
        }
        return dependencies;
    }

    private Set<ObjectName> getActionDependencies(String deploymentName, ModelAdapter model, Properties actionArtifactProperties) throws DeploymentException {
        HashSet<ObjectName> deps = new HashSet<ObjectName>();
        HashSet<String> artifacts = new HashSet<String>();
        if (!deploymentName.equals(this.esbArtifactName)) {
            artifacts.add(this.esbArtifactName + ".esb");
        }
        Set<String> actionClasses = model.getActions();
        if (actionArtifactProperties != null) {
            int numActionClasses;
            int n = numActionClasses = actionClasses == null ? 0 : actionClasses.size();
            if (numActionClasses > 0) {
                for (String actionClass : actionClasses) {
                    String artifact = (String)actionArtifactProperties.get(actionClass);
                    if (artifact == null) continue;
                    artifacts.add(artifact);
                }
            }
        }
        for (String artifact : artifacts) {
            if (deploymentName.equals(artifact)) continue;
            String canonicalName = this.esbDeploymentPrefix + artifact;
            try {
                ObjectName on = ObjectNameConverter.convert((String)canonicalName);
                deps.add(on);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
        }
        return deps;
    }

    String getDeploymentName(VFSDeploymentUnit deploymentUnit) {
        String simpleName = deploymentUnit.getSimpleName();
        int idx = simpleName.indexOf(".esb");
        if (idx == -1) {
            return simpleName;
        }
        return simpleName.substring(0, simpleName.indexOf(".esb"));
    }

    public void setActionArtifactsFile(String actionArtifactsFile) {
        this.actionArtifactsFile = actionArtifactsFile;
    }

    public void setEsbDeploymentPrefix(String deploymentPrefix) {
        this.esbDeploymentPrefix = deploymentPrefix;
    }

    public void setEsbArtifactName(String esbArtifactName) {
        this.esbArtifactName = esbArtifactName;
    }

    public void setWarDeploymentPrefix(String deploymentPrefix) {
        this.warDeploymentPrefix = deploymentPrefix;
    }

    private static class EsbConfigFileFilter
    implements VirtualFileFilter {
        private EsbConfigFileFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return file.getName().endsWith("-esb.xml");
        }
    }
}

