/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers120.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers120.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.JbrBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.JbrListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.JbrProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Listener;
import org.jboss.soa.esb.listeners.gateway.JBossRemotingGatewayListener;
import org.w3c.dom.Element;

public class JbrListenerMapper {
    public static Element map(Element root, JbrListenerDocument.JbrListener listener, XMLBeansModel model) throws ConfigurationException {
        JbrProviderDocument.JbrProvider provider;
        JbrBusDocument.JbrBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (JbrBusDocument.JbrBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <jbr-listener> must reference a <jbr-bus>.");
        }
        try {
            provider = (JbrProviderDocument.JbrProvider)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <jbr-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(provider.getPropertyList(), listenerNode);
        MapperUtil.mapProperties(bus.getPropertyList(), listenerNode);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            String host = provider.getHost();
            listenerNode.setAttribute("gatewayClass", JBossRemotingGatewayListener.class.getName());
            listenerNode.setAttribute("is-gateway", Boolean.toString(listener.getIsGateway()));
            if (host != null) {
                listenerNode.setAttribute("jbr-serverBindAddress", host);
            }
        } else {
            throw new ConfigurationException("Invalid <jbr-listener> config [" + listener.getName() + "].  <jbr-listener> is currently only supported as a gateway listener.");
        }
        listenerNode.setAttribute("jbr-serverProtocol", provider.getProtocol().toString());
        listenerNode.setAttribute("jbr-serverBindPort", Integer.toString(bus.getPort()));
        return listenerNode;
    }
}

