/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers110;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.internal.soa.esb.publish.ActionContractPublisher;
import org.jboss.internal.soa.esb.publish.ContractProvider;
import org.jboss.internal.soa.esb.publish.ContractPublisher;
import org.jboss.internal.soa.esb.publish.Publish;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.listeners.config.Action;
import org.jboss.soa.esb.listeners.config.ServiceContract;
import org.jboss.soa.esb.listeners.config.ServicePublisher;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.jboss.soa.esb.listeners.config.mappers110.ESBAwareGenerator;
import org.jboss.soa.esb.listeners.config.mappers110.GatewayGenerator;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.AbstractScheduledListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ActionDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ActionsDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.BusProvider;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.JbossesbDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.JcaGatewayDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ListenersDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.MepType;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.PropertyDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Provider;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ProvidersDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.Schedule;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ScheduleProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ServiceDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.ServicesDocument;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBeansModel {
    private JbossesbDocument.Jbossesb jbossesb;

    public XMLBeansModel(JbossesbDocument.Jbossesb jbossesb) {
        this.jbossesb = jbossesb;
    }

    public List<Listener> getGatewayListeners() throws ConfigurationException {
        return this.getListeners(true);
    }

    public List<Listener> getESBAwareListeners() throws ConfigurationException {
        return this.getListeners(false);
    }

    public ServiceDocument.Service getService(Listener listener) {
        List<ServiceDocument.Service> services = this.getServices();
        for (ServiceDocument.Service service : services) {
            List listenerList;
            ListenersDocument.Listeners listeners = service.getListeners();
            if (listeners == null || (listenerList = listeners.getListenerList()) == null) continue;
            for (Listener serviceListener : listenerList) {
                if (serviceListener != listener) continue;
                return service;
            }
        }
        throw new IllegalStateException("No Service instance found for the supplied Listener instance.  This should not be possible if the Listener instance was provided by this configuration.  Where has this Listener instance come from?");
    }

    public List<ServiceDocument.Service> getServices() {
        ServicesDocument.Services services = this.jbossesb.getServices();
        if (services != null) {
            return this.jbossesb.getServices().getServiceList();
        }
        return Collections.emptyList();
    }

    public Bus getBus(String busid) throws ConfigurationException {
        List providers = this.jbossesb.getProviders().getProviderList();
        for (Provider provider : providers) {
            if (!(provider instanceof BusProvider)) continue;
            List buses = ((BusProvider)provider).getBusList();
            for (Bus bus : buses) {
                if (!bus.getBusid().equals(busid)) continue;
                return bus;
            }
        }
        throw new ConfigurationException("Invalid ESB Configuration: No <bus> configuration matching busid reference value [" + busid + "].");
    }

    public Provider getProvider(Bus bus) {
        List providers = this.jbossesb.getProviders().getProviderList();
        for (Provider provider : providers) {
            if (!(provider instanceof BusProvider)) continue;
            List buses = ((BusProvider)provider).getBusList();
            for (Bus installedBus : buses) {
                if (installedBus != bus) continue;
                return provider;
            }
        }
        throw new IllegalStateException("No Provider instance found for the supplied Bus config instance.  This should not be possible if the Bus instance was provided by this configuration.  Where has this Bus instance come from?");
    }

    public Schedule getSchedule(String id) {
        if (id == null || this.jbossesb.getProviders() == null) {
            return null;
        }
        List providers = this.jbossesb.getProviders().getProviderList();
        for (Provider provider : providers) {
            if (!(provider instanceof ScheduleProviderDocument.ScheduleProvider)) continue;
            ScheduleProviderDocument.ScheduleProvider scheduleProvider = (ScheduleProviderDocument.ScheduleProvider)provider;
            List schedules = scheduleProvider.getScheduleList();
            for (Schedule schedule : schedules) {
                if (!id.equals(schedule.getScheduleid())) continue;
                return schedule;
            }
        }
        return null;
    }

    public ScheduleProviderDocument.ScheduleProvider getScheduleProvider() {
        if (this.jbossesb.getProviders() == null) {
            return null;
        }
        List providers = this.jbossesb.getProviders().getProviderList();
        for (Provider provider : providers) {
            if (!(provider instanceof ScheduleProviderDocument.ScheduleProvider)) continue;
            return (ScheduleProviderDocument.ScheduleProvider)provider;
        }
        return null;
    }

    public int getScheduledListenerCount() {
        int count = 0;
        if (this.jbossesb.getServices() != null) {
            List<ServiceDocument.Service> services = this.getServices();
            for (ServiceDocument.Service service : services) {
                ListenersDocument.Listeners listeners = service.getListeners();
                if (listeners == null) continue;
                for (Listener listener : listeners.getListenerList()) {
                    if (!(listener instanceof AbstractScheduledListener)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private boolean isGateway(Listener listener) {
        return listener.getIsGateway() || listener instanceof JcaGatewayDocument.JcaGateway;
    }

    private List<Listener> getListeners(boolean isGateway) throws ConfigurationException {
        ArrayList<Listener> gateways = new ArrayList<Listener>();
        if (this.jbossesb.getServices() != null) {
            List<ServiceDocument.Service> services = this.getServices();
            for (ServiceDocument.Service service : services) {
                boolean listenerAdded = false;
                ListenersDocument.Listeners listeners = service.getListeners();
                if (listeners != null) {
                    for (Listener listener : listeners.getListenerList()) {
                        if (this.isGateway(listener) != isGateway) continue;
                        gateways.add(listener);
                        listenerAdded = true;
                    }
                }
                if (XMLBeansModel.exposesInVMListener(service) || isGateway || listenerAdded) continue;
                throw new ConfigurationException("Service '" + service.getCategory() + ":" + service.getName() + "' does not define a Message-Aware (is-gateway='false') nor InVm Listener.");
            }
        }
        return gateways;
    }

    public String getParameterReloadSecs() {
        return this.jbossesb.getParameterReloadSecs().getStringValue();
    }

    public static String getProperty(List<PropertyDocument.Property> properties, String name, String defaultVal) {
        for (PropertyDocument.Property property : properties) {
            if (!property.getName().equals(name)) continue;
            return property.getValue();
        }
        return defaultVal;
    }

    public static boolean exposesInVMListener(ServiceDocument.Service service) {
        if (service.xgetInvmScope() != null && service.xgetInvmScope().getStringValue() != null) {
            return service.xgetInvmScope().getStringValue().equals("GLOBAL");
        }
        String systemDefaultScope = System.getProperty("jboss.esb.invm.scope.default", "GLOBAL");
        String defaultScope = ModulePropertyManager.getPropertyManager("core").getProperty("jboss.esb.invm.scope.default", systemDefaultScope);
        return defaultScope.equals("GLOBAL");
    }

    public void verifyScheduleProviderConfig() throws ConfigurationException {
        ProvidersDocument.Providers providersConfig = this.jbossesb.getProviders();
        if (providersConfig == null) {
            return;
        }
        List providers = providersConfig.getProviderList();
        int numScheduleProviders = 0;
        for (Provider provider : providers) {
            if (!(provider instanceof ScheduleProviderDocument.ScheduleProvider)) continue;
            ++numScheduleProviders;
        }
        if (numScheduleProviders > 1) {
            throw new ConfigurationException("Configuration contains " + numScheduleProviders + " <schedule-provider> configurations.  Only one of this provider type can exist per configuration.");
        }
    }

    public Map<Service, List<ServicePublisher>> getServicePublishers() {
        List<ServiceDocument.Service> serviceConfigs = this.getServices();
        LinkedHashMap<Service, List<ServicePublisher>> servicePublishers = new LinkedHashMap<Service, List<ServicePublisher>>();
        for (ServiceDocument.Service docService : serviceConfigs) {
            ContractPublisher publisher = XMLBeansModel.getContractPublisher(docService);
            Service service = new Service(docService.getCategory(), docService.getName());
            ServicePublisher servicePublisher = new ServicePublisher(service.getName(), service.getCategory(), publisher);
            servicePublisher.setDescription(docService.getDescription());
            XMLBeansModel.addPublisher(servicePublishers, service, servicePublisher);
        }
        return servicePublishers;
    }

    private static ContractPublisher getContractPublisher(ServiceDocument.Service service) {
        if (service.getActions() == null || service.getActions().getActionList() == null) {
            return null;
        }
        for (ActionDocument.Action action : service.getActions().getActionList()) {
            Class actionClass;
            try {
                actionClass = ClassUtil.forName(action.getClass1(), ServicePublisher.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find action class '" + action.getClass1() + "'.", e);
            }
            Publish publishAnnotation = actionClass.getAnnotation(Publish.class);
            if (publishAnnotation == null) continue;
            ActionContractPublisher publisher = null;
            Class publisherClass = publishAnnotation.value();
            try {
                publisher = (ActionContractPublisher)publisherClass.newInstance();
                Action actionInfo = new Action(action.getName(), action.getClass1(), action.getProcess(), XMLBeansModel.toProperties(action.getPropertyList()));
                if (!actionInfo.getProperties().getProperty("publishContract", "true").equals("true")) continue;
                publisher.setActionConfig(actionInfo);
                return publisher;
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Action Contract Publisher class '" + publisherClass.getName() + "' must implement " + ActionContractPublisher.class.getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate Contract Publisher '" + publisherClass.getName() + "'. Class must implement a public default constructor.", e);
            }
        }
        return null;
    }

    private static void addPublisher(Map<Service, List<ServicePublisher>> servicePublishers, Service service, ServicePublisher publisher) {
        List<ServicePublisher> publishers = servicePublishers.get(service);
        if (publishers != null) {
            publishers.add(publisher);
        } else {
            ArrayList<ServicePublisher> newPublishers = new ArrayList<ServicePublisher>();
            newPublishers.add(publisher);
            servicePublishers.put(service, newPublishers);
        }
    }

    public Document generateESBAwareConfig() throws ConfigurationException {
        ESBAwareGenerator awareGenerator = new ESBAwareGenerator(this);
        return awareGenerator.generate();
    }

    public Document generateGatewayConfig() throws ConfigurationException {
        GatewayGenerator gatewayGenerator = new GatewayGenerator(this);
        return gatewayGenerator.generate();
    }

    public static Properties toProperties(List<PropertyDocument.Property> configProperties) {
        Properties properties = new Properties();
        for (PropertyDocument.Property property : configProperties) {
            String name = property.getName();
            String value = property.getValue();
            if (value == null) continue;
            properties.setProperty(name, value);
        }
        return properties;
    }

    public Set<String> getActions() {
        ServicesDocument.Services services = this.jbossesb.getServices();
        if (services != null) {
            HashSet<String> actionClasses = new HashSet<String>();
            for (ServiceDocument.Service service : services.getServiceList()) {
                ActionsDocument.Actions actions = service.getActions();
                if (actions == null) continue;
                for (ActionDocument.Action action : actions.getActionList()) {
                    actionClasses.add(action.getClass1());
                }
            }
            return actionClasses;
        }
        return null;
    }

    public List<WebserviceInfo> getWebserviceServices() {
        ArrayList<WebserviceInfo> endpointServices = new ArrayList<WebserviceInfo>();
        ServicesDocument.Services services = this.jbossesb.getServices();
        if (services != null) {
            for (ServiceDocument.Service service : services.getServiceList()) {
                String inXsd;
                ActionsDocument.Actions actions = service.getActions();
                if (actions == null || actions.isSetWebservice() && !actions.getWebservice() || (inXsd = actions.getInXsd()) == null) continue;
                WebserviceInfo webserviceInfo = new WebserviceInfo(new Service(service.getCategory(), service.getName()), actions.getInXsd(), actions.getOutXsd(), actions.getFaultXsd(), service.getDescription(), MepType.REQUEST_RESPONSE.equals(actions.getMep()), actions.getRequestLocation(), actions.getResponseLocation(), actions.getAddressing());
                endpointServices.add(webserviceInfo);
            }
        }
        return endpointServices;
    }

    public List<ServiceContract> getServiceContracts() {
        ArrayList<ServiceContract> serviceContractList = new ArrayList<ServiceContract>();
        ServicesDocument.Services services = this.jbossesb.getServices();
        if (services != null) {
            block5: for (ServiceDocument.Service service : services.getServiceList()) {
                ActionsDocument.Actions actions = service.getActions();
                if (actions == null) continue;
                for (ActionDocument.Action action : actions.getActionList()) {
                    ContractProvider provider;
                    Class publisherClass;
                    Class actionClass;
                    try {
                        actionClass = ClassUtil.forName(action.getClass1(), ServiceContract.class);
                    }
                    catch (ClassNotFoundException e) {
                        continue block5;
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        continue block5;
                    }
                    Publish publishAnnotation = actionClass.getAnnotation(Publish.class);
                    if (publishAnnotation == null || !ContractProvider.class.isAssignableFrom(publisherClass = publishAnnotation.value())) continue;
                    try {
                        provider = (ContractProvider)publisherClass.newInstance();
                        Properties properties = XMLBeansModel.toProperties(action.getPropertyList());
                        provider.setContractProperties(properties);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create ContractProvider", e);
                    }
                    ServiceContract serviceContract = new ServiceContract(new Service(service.getCategory(), service.getName()), service.getDescription(), provider);
                    serviceContractList.add(serviceContract);
                    continue block5;
                }
            }
        }
        return serviceContractList;
    }
}

