/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.internal.soa.esb.listeners.war.WebGatewayDeploymentFactory;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.parameters.ParamRepositoryException;
import org.jboss.soa.esb.parameters.ParamRepositoryFactory;
import org.jboss.soa.esb.util.ClassUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleUtil {
    private LifecycleUtil() {
    }

    public static List<ManagedLifecycle> getListeners(String param) throws ParamRepositoryException, SAXException, ManagedLifecycleException {
        return LifecycleUtil.getListeners(LifecycleUtil.getConfigTree(param));
    }

    public static List<ManagedLifecycle> getListeners(ConfigTree tree) throws ManagedLifecycleException {
        return LifecycleUtil.getManagedInstances(tree, "listenerClass");
    }

    public static List<ManagedLifecycle> getGateways(String param) throws ParamRepositoryException, SAXException, ManagedLifecycleException {
        return LifecycleUtil.getGateways(LifecycleUtil.getConfigTree(param));
    }

    public static List<ManagedLifecycle> getGateways(ConfigTree tree) throws ManagedLifecycleException {
        return LifecycleUtil.getManagedInstances(tree, "gatewayClass");
    }

    private static List<ManagedLifecycle> getManagedInstances(ConfigTree tree, String classTag) throws ManagedLifecycleException {
        ArrayList<ManagedLifecycle> instances = new ArrayList<ManagedLifecycle>();
        for (ConfigTree child : tree.getAllChildren()) {
            ManagedLifecycle instance;
            Constructor constructor;
            Class instanceClass;
            String classname = child.getAttribute(classTag);
            if (classname == null) continue;
            try {
                instanceClass = ClassUtil.forName(classname, LifecycleUtil.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ManagedLifecycleException("Could not locate managed instance " + classname);
            }
            if (!ManagedLifecycle.class.isAssignableFrom(instanceClass)) {
                if (WebGatewayDeploymentFactory.class.isAssignableFrom(instanceClass)) continue;
                throw new ManagedLifecycleException("Managed instance " + classname + " does not implement ManagedLifecycle");
            }
            try {
                constructor = instanceClass.getConstructor(ConfigTree.class);
            }
            catch (NoSuchMethodException nsme) {
                throw new ManagedLifecycleException("Managed instance [" + classname + "] does not have correct constructor.  This class must contain a public constructor of the form 'public " + instanceClass.getSimpleName() + "(" + ConfigTree.class.getName() + " config);'");
            }
            try {
                instance = (ManagedLifecycle)constructor.newInstance(child);
            }
            catch (Exception ex) {
                throw new ManagedLifecycleException("Unexpected exception while instantiating managed instance", ex);
            }
            instances.add(instance);
        }
        return instances;
    }

    public static ConfigTree getConfigTree(String param) throws ParamRepositoryException, SAXException {
        String xml = ParamRepositoryFactory.getInstance().get(param);
        ConfigTree tree = ConfigTree.fromXml(xml);
        tree.setAttribute("configSource", "param-repository:" + param);
        return tree;
    }
}

