/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.lifecycle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.NamingContext;
import org.jboss.soa.esb.lifecycle.LifecycleResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleResourceManager {
    private static Logger logger = Logger.getLogger(LifecycleResourceManager.class);
    private static volatile Thread cleanupHook = new Thread(){

        public void run() {
            LifecycleResourceManager.getSingleton().cleanupAllResources();
        }
    };
    private static final LifecycleResourceManager SINGLETON;
    public static final String DEFAULT_IDENTITY = "ID-DEFAULT";
    private final Map<ClassLoader, Set<String>> associatedDeployments = new HashMap<ClassLoader, Set<String>>();
    private final Map<ClassLoader, String> identities = new HashMap<ClassLoader, String>();
    private ReadWriteLock deploymentLock = new ReentrantReadWriteLock();
    private final Map<ClassLoader, Map<Integer, Set<LifecycleResource<?>>>> classLoaderResourceMap = new HashMap();
    private final Map<Integer, Set<LifecycleResource<?>>> resourceMap = new TreeMap();
    private Lock resourceLock = new ReentrantLock();
    private long identityCounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateDeployment(String deploymentName) {
        String identity;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Lock writeLock = this.deploymentLock.writeLock();
        writeLock.lock();
        try {
            identity = this.identities.get(classLoader);
            if (identity != null) {
                Set<String> currentAssociations = this.associatedDeployments.get(classLoader);
                currentAssociations.add(deploymentName);
            } else {
                HashSet<String> associations = new HashSet<String>();
                associations.add(deploymentName);
                this.associatedDeployments.put(classLoader, associations);
                identity = "ID-" + Long.toString(this.identityCounter++);
                this.identities.put(classLoader, identity);
            }
        }
        finally {
            writeLock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Associating deploymentName " + deploymentName + " with identity: " + identity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAssociatedDeployments() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Lock readLock = this.deploymentLock.readLock();
        readLock.lock();
        try {
            Set<String> currentAssociations = this.associatedDeployments.get(classLoader);
            if (currentAssociations != null) {
                String[] stringArray = currentAssociations.toArray(new String[currentAssociations.size()]);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassociateDeployment(String deploymentName) {
        boolean cleanContext;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String identity = this.identities.get(classLoader);
        Lock writeLock = this.deploymentLock.writeLock();
        writeLock.lock();
        try {
            Set<String> currentAssociations = this.associatedDeployments.get(classLoader);
            if (currentAssociations != null) {
                currentAssociations.remove(deploymentName);
                boolean bl = cleanContext = currentAssociations.size() == 0;
                if (cleanContext) {
                    this.identities.remove(classLoader);
                    this.associatedDeployments.remove(classLoader);
                }
            } else {
                cleanContext = false;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Disassociating deploymentName " + deploymentName + " from identity: " + identity));
        }
        if (cleanContext) {
            this.cleanContextResources(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdentity() {
        String identity;
        Lock readLock = this.deploymentLock.readLock();
        readLock.lock();
        try {
            String currentIdentity = null;
            for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null && (currentIdentity = this.identities.get(classLoader)) == null; classLoader = classLoader.getParent()) {
            }
            identity = currentIdentity;
        }
        finally {
            readLock.unlock();
        }
        return null == identity ? DEFAULT_IDENTITY : identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerResource(LifecycleResource<?> lifecycleResource, ClassLoader classLoader, int priority) {
        this.resourceLock.lock();
        try {
            Map<Integer, Set<LifecycleResource<?>>> classLoaderMap = this.classLoaderResourceMap.get(classLoader);
            if (classLoaderMap != null) {
                LifecycleResourceManager.insertInto(classLoaderMap, priority, lifecycleResource);
            } else {
                TreeMap newMap = new TreeMap();
                this.classLoaderResourceMap.put(classLoader, newMap);
                LifecycleResourceManager.insertInto(newMap, priority, lifecycleResource);
            }
            LifecycleResourceManager.insertInto(this.resourceMap, priority, lifecycleResource);
        }
        finally {
            this.resourceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanContextResources(String identity) {
        this.resourceLock.lock();
        try {
            for (Set<LifecycleResource<?>> resourceSet : this.resourceMap.values()) {
                for (LifecycleResource<?> resource : resourceSet) {
                    resource.cleanupResource(identity);
                }
            }
        }
        finally {
            this.resourceLock.unlock();
        }
        NamingContext.closeAllContexts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyResources() {
        this.resourceLock.lock();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Map<Integer, Set<LifecycleResource<?>>> classLoaderMap = this.classLoaderResourceMap.remove(classLoader);
            if (classLoaderMap != null) {
                for (Map.Entry<Integer, Set<LifecycleResource<?>>> entry : classLoaderMap.entrySet()) {
                    Integer priority = entry.getKey();
                    Set<LifecycleResource<?>> classLoaderResourceMapSet = entry.getValue();
                    Set<LifecycleResource<?>> resourceMapSet = this.resourceMap.get(priority);
                    for (LifecycleResource<?> resource : classLoaderResourceMapSet) {
                        resource.destroyResources();
                        resourceMapSet.remove(resource);
                    }
                    if (resourceMapSet.size() != 0) continue;
                    this.resourceMap.remove(priority);
                }
            }
        }
        finally {
            this.resourceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAllResources() {
        this.resourceLock.lock();
        try {
            for (Set<LifecycleResource<?>> resourceSet : this.resourceMap.values()) {
                for (LifecycleResource<?> resource : resourceSet) {
                    try {
                        resource.destroyResources();
                    }
                    catch (Throwable ex) {
                        logger.warn((Object)("Caught exception " + ex + " during destroyResources."));
                    }
                }
            }
            this.resourceMap.clear();
            this.classLoaderResourceMap.clear();
        }
        finally {
            this.resourceLock.unlock();
        }
    }

    void registerResource(LifecycleResource<?> lifecycleResource, ClassLoader classLoader) {
        this.registerResource(lifecycleResource, classLoader, Integer.MIN_VALUE);
    }

    public static LifecycleResourceManager getSingleton() {
        return SINGLETON;
    }

    public static void deactivateHook() {
        Thread hook = cleanupHook;
        if (hook != null) {
            cleanupHook = null;
            Runtime.getRuntime().removeShutdownHook(hook);
        }
    }

    private static void insertInto(Map<Integer, Set<LifecycleResource<?>>> priorityMap, int priority, LifecycleResource<?> lifecycleResource) {
        Integer key = priority;
        Set<LifecycleResource<?>> currentResourceSet = priorityMap.get(key);
        if (currentResourceSet != null) {
            currentResourceSet.add(lifecycleResource);
        } else {
            HashSet newResourceSet = new HashSet();
            priorityMap.put(key, newResourceSet);
            newResourceSet.add(lifecycleResource);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(cleanupHook);
        SINGLETON = new LifecycleResourceManager();
    }
}

