/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.lifecycle;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleResource<R> {
    private static Logger logger = Logger.getLogger(LifecycleResource.class);
    private final LifecycleResourceFactory<R> factory;
    private final Map<String, R> lifecycleResourceMap = new HashMap<String, R>();
    private ReadWriteLock lifecycleResourceLock = new ReentrantReadWriteLock();
    private boolean destroyed;

    public LifecycleResource(LifecycleResourceFactory<R> factory, int priority) {
        this.factory = factory;
        LifecycleResourceManager.getSingleton().registerResource(this, factory.getClass().getClassLoader(), priority);
    }

    public LifecycleResource(LifecycleResourceFactory<R> factory) {
        this.factory = factory;
        LifecycleResourceManager.getSingleton().registerResource(this, factory.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R getLifecycleResource() throws LifecycleResourceException {
        String identity = LifecycleResourceManager.getSingleton().getIdentity();
        Lock readLock = this.lifecycleResourceLock.readLock();
        readLock.lock();
        try {
            R currentResource = this.lifecycleResourceMap.get(identity);
            if (currentResource != null) {
                R r = currentResource;
                return r;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.lifecycleResourceLock.writeLock();
        writeLock.lock();
        try {
            if (this.destroyed) {
                throw new LifecycleResourceException("Resource already destroyed");
            }
            R resource = this.lifecycleResourceMap.get(identity);
            if (resource != null) {
                R r = resource;
                return r;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating resource using factory: " + this.factory + " with identity " + identity));
            }
            R newResource = this.factory.createLifecycleResource(identity);
            this.lifecycleResourceMap.put(identity, newResource);
            R r = newResource;
            return r;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupResource(String identity) {
        R resource;
        Lock writeLock = this.lifecycleResourceLock.writeLock();
        writeLock.lock();
        try {
            resource = this.lifecycleResourceMap.remove(identity);
        }
        finally {
            writeLock.unlock();
        }
        if (resource != null) {
            this.cleanupLifecycleResource(this.factory, resource, identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void destroyResources() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Destroying all resources for factory : " + this.factory));
        }
        Lock writeLock = this.lifecycleResourceLock.writeLock();
        writeLock.lock();
        try {
            for (Map.Entry<String, R> entry : this.lifecycleResourceMap.entrySet()) {
                String identity = entry.getKey();
                R resource = entry.getValue();
                this.cleanupLifecycleResource(this.factory, resource, identity);
            }
            this.lifecycleResourceMap.clear();
            this.destroyed = true;
        }
        finally {
            writeLock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Destroyed all resources for factory : " + this.factory));
        }
    }

    private void cleanupLifecycleResource(LifecycleResourceFactory<R> factory, R resource, String identity) {
        block3: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cleaning up resource using factory: " + factory + " with identity " + identity));
            }
            try {
                factory.destroyLifecycleResource(resource, identity);
            }
            catch (Throwable th) {
                logger.warn((Object)("Unexpected error destroying lifecycle resource:" + th.getMessage()));
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("LifecycleResourceFactory: " + factory + ", identity: " + identity), th);
            }
        }
    }
}

