/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.http.HttpHeader;
import org.jboss.soa.esb.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse
implements Serializable {
    public static final String RESPONSE_KEY = HttpResponse.class.getName() + "#response";
    private Integer responseCode;
    private String contentType;
    private String encoding;
    private Long length;
    private List<HttpHeader> headers = new ArrayList<HttpHeader>();

    public HttpResponse(int responseCode) {
        this.responseCode = responseCode;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<HttpHeader> getHttpHeaders() {
        return this.headers;
    }

    public void addHeader(HttpHeader header) {
        AssertArgument.isNotNull(header, "header");
        this.headers.add(header);
    }

    public static HttpResponse getResponse(Message message) {
        AssertArgument.isNotNull(message, "message");
        return (HttpResponse)message.getBody().get(RESPONSE_KEY);
    }

    public void setResponse(Message message) {
        AssertArgument.isNotNull(message, "message");
        message.getBody().add(RESPONSE_KEY, this);
    }
}

