/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.Configurator;
import org.jboss.soa.esb.http.configurators.Connection;
import org.jboss.soa.esb.http.configurators.HttpProtocol;
import org.jboss.soa.esb.util.ClassUtil;

public abstract class HttpClientFactory {
    public static final String TARGET_HOST_URL = "target-host-url";
    public static final String MAX_TOTAL_CONNECTIONS = "max-total-connections";

    public static HttpClient createHttpClient(Properties properties) throws ConfigurationException {
        String[] configurators;
        AssertArgument.isNotNull(properties, "properties");
        HttpClient httpClient = new HttpClient();
        String fileConfig = (String)properties.remove("file");
        if (fileConfig != null) {
            try {
                properties.load(StreamUtils.getResource(fileConfig));
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to load HttpClient config '" + fileConfig + "'.");
            }
        }
        new Connection().configure(httpClient, properties);
        for (String configuratorClass : configurators = properties.getProperty("configurators", HttpProtocol.class.getName()).split(",")) {
            boolean skip = Boolean.valueOf(properties.getProperty((configuratorClass = configuratorClass.trim()) + ".skip", "false"));
            if (skip) continue;
            Configurator configurator = HttpClientFactory.createConfigurator(configuratorClass);
            configurator.configure(httpClient, properties);
        }
        return httpClient;
    }

    private static Configurator createConfigurator(String configuratorClass) throws ConfigurationException {
        try {
            return (Configurator)ClassUtil.forName(configuratorClass, HttpClientFactory.class).newInstance();
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Class [" + configuratorClass + "] must extend [" + Configurator.class.getName() + "].", e);
        }
        catch (ClassNotFoundException e) {
            if (!configuratorClass.startsWith(HttpProtocol.class.getPackage().getName())) {
                return HttpClientFactory.createConfigurator(HttpProtocol.class.getPackage().getName() + "." + configuratorClass);
            }
            throw new ConfigurationException("Configurator implementation class [" + configuratorClass + "] not found in classpath.", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate Configurator implementation class [" + configuratorClass + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate Configurator implementation class [" + configuratorClass + "].", e);
        }
    }

    public static void shutdown(HttpClient httpclient) {
        HttpConnectionManager connectionManager;
        if (httpclient != null && (connectionManager = httpclient.getHttpConnectionManager()) instanceof MultiThreadedHttpConnectionManager) {
            MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = (MultiThreadedHttpConnectionManager)connectionManager;
            multiThreadedHttpConnectionManager.shutdown();
        }
    }
}

