/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.services.security.PasswordUtil;

public abstract class Configurator {
    public abstract void configure(HttpClient var1, Properties var2) throws ConfigurationException;

    protected URI getTargetURI(Properties properties, boolean required) throws ConfigurationException {
        String targetURLString = properties.getProperty("target-host-url");
        if (required) {
            this.assertPropertySetAndNotBlank(targetURLString, "target-host-url");
        }
        if (targetURLString != null) {
            try {
                return new URI(targetURLString);
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException("'url' property is not a valid URI.");
            }
        }
        return null;
    }

    protected void assertPropertySetAndNotBlank(String propertyValue, String propertyName) throws ConfigurationException {
        if (propertyValue == null || propertyValue.trim().equals("")) {
            throw new ConfigurationException(this.getClass().getSimpleName() + " must be configured with a non-blank value for the '" + propertyName + "' property.");
        }
    }

    protected void assertPropertyIsInteger(String propertyValue, String propertyName) throws ConfigurationException {
        this.assertPropertySetAndNotBlank(propertyValue, propertyName);
        try {
            Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(this.getClass().getSimpleName() + " must be configured with an Integer value for the '" + propertyName + "' property.");
        }
    }

    protected String getPasswordFromFile(String password) throws ConfigurationException {
        if (PasswordUtil.isPasswordFile(password)) {
            try {
                return new PasswordUtil(password).getPasswordAsString();
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
        }
        return password;
    }
}

