/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.couriers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.TwoWayCourierImpl;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.couriers.Courier;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;

public class CourierFactory {
    private static final Logger LOGGER = Logger.getLogger(CourierFactory.class);
    private static final LifecycleResourceFactory<Map<TwoWayCourier, Exception>> lifecycleCourierFactory = new LifecycleCourierFactory();
    private static final LifecycleResource<Map<TwoWayCourier, Exception>> lifecycleCouriers = new LifecycleResource<Map<TwoWayCourier, Exception>>(lifecycleCourierFactory, 100000);
    private static CourierFactory instance = new CourierFactory();

    protected CourierFactory() {
    }

    public static CourierFactory getInstance() {
        return instance;
    }

    public static void setInstance(CourierFactory instance) {
        CourierFactory.instance = instance;
    }

    public TwoWayCourier getMessageCourier(EPR toEPR) throws CourierException, MalformedEPRException {
        return CourierFactory.getCourier(toEPR, null);
    }

    public static Courier getCourier(EPR toEPR) throws CourierException, MalformedEPRException {
        return CourierFactory.getCourier(toEPR, null);
    }

    public static TwoWayCourier getPickupCourier(EPR replyToEPR) throws CourierException, MalformedEPRException {
        return CourierFactory.getCourier(null, replyToEPR);
    }

    public static TwoWayCourier getCourier(EPR toEPR, EPR replyToEPR) throws CourierException, MalformedEPRException {
        TwoWayCourierImpl result = new TwoWayCourierImpl(toEPR, replyToEPR);
        CourierFactory.registerCourier(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerCourier(TwoWayCourier courier) throws CourierException {
        Map<TwoWayCourier, Exception> map;
        Exception ex = LOGGER.isDebugEnabled() ? new Exception("Courier Assignment stacktrace") : null;
        try {
            map = lifecycleCouriers.getLifecycleResource();
        }
        catch (LifecycleResourceException lre) {
            throw new CourierException("Unexpected lifecycle resource exception while registering courier", lre);
        }
        Map<TwoWayCourier, Exception> map2 = map;
        synchronized (map2) {
            map.put(courier, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterCourier(TwoWayCourier courier) {
        block5: {
            try {
                Map<TwoWayCourier, Exception> map;
                Map<TwoWayCourier, Exception> map2 = map = lifecycleCouriers.getLifecycleResource();
                synchronized (map2) {
                    map.remove(courier);
                }
            }
            catch (LifecycleResourceException lre) {
                LOGGER.warn((Object)("Unexpected error removing courier: " + lre.getMessage()));
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug((Object)"Unexpected error removing courier", (Throwable)lre);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleCourierFactory
    implements LifecycleResourceFactory<Map<TwoWayCourier, Exception>> {
        private LifecycleCourierFactory() {
        }

        @Override
        public Map<TwoWayCourier, Exception> createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new HashMap<TwoWayCourier, Exception>();
        }

        @Override
        public void destroyLifecycleResource(Map<TwoWayCourier, Exception> resource, String lifecycleIdentity) throws LifecycleResourceException {
            if (resource.size() > 0) {
                LOGGER.warn((Object)("Calling cleanup on existing couriers for identity " + lifecycleIdentity));
                Iterator<Map.Entry<TwoWayCourier, Exception>> entryIter = resource.entrySet().iterator();
                while (entryIter.hasNext()) {
                    Map.Entry<TwoWayCourier, Exception> entry = entryIter.next();
                    entryIter.remove();
                    if (LOGGER.isDebugEnabled() && entry.getValue() != null) {
                        LOGGER.debug((Object)"Courier allocation stacktrace", (Throwable)entry.getValue());
                    }
                    try {
                        entry.getKey().cleanup();
                    }
                    catch (Exception ex) {
                        LOGGER.warn((Object)"Unexpected exception cleaning up courier", (Throwable)ex);
                    }
                }
            }
        }
    }
}

