/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.common;

import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.services.registry.InVMRegistryInterceptor;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.services.DefaultEncryptionFactory;

public class Configuration {
    private static Logger _logger = Logger.getLogger(Configuration.class);
    private static KeyValuePair[] s_oaKV = new KeyValuePair[]{new KeyValuePair("org.jboss.soa.esb.mail.smtp.host", Configuration.getSmtpHost()), new KeyValuePair("org.jboss.soa.esb.mail.smtp.user", Configuration.getSmtpUsername()), new KeyValuePair("org.jboss.soa.esb.mail.smtp.password", Configuration.getSmtpPassword()), new KeyValuePair("org.jboss.soa.esb.mail.smtp.port", Configuration.getSmtpPort()), new KeyValuePair("org.jboss.soa.esb.mail.smtp.from", Configuration.getSmtpFrom()), new KeyValuePair("org.jboss.soa.esb.mail.smtp.auth", Configuration.getSmtpAuth()), new KeyValuePair("org.jboss.soa.esb.http.host", Configuration.getHttpHost()), new KeyValuePair("org.jboss.soa.esb.http.port", Configuration.getHttpPort()), new KeyValuePair("org.jboss.soa.esb.http.securePort", Configuration.getHttpSecurePort()), new KeyValuePair("org.jboss.soa.esb.http.responseStatusEnabled", Configuration.getHttpResponseStatusEnabled()), new KeyValuePair("org.jboss.soa.esb.jndi.server.url", Configuration.getJndiServerURL()), new KeyValuePair("org.jboss.soa.esb.jndi.server.context.factory", Configuration.getJndiServerContextFactory()), new KeyValuePair("org.jboss.soa.esb.jndi.server.pkg.prefix", Configuration.getJndiServerPkgPrefix()), new KeyValuePair("org.jboss.soa.esb.registry.queryManagerURI", Configuration.getRegistryQueryManageURI()), new KeyValuePair("org.jboss.soa.esb.registry.lifeCycleManagerURI", Configuration.getRegistryLifecycleManagerURI()), new KeyValuePair("org.jboss.soa.esb.registry.securityManagerURI", Configuration.getRegistrySecurityManagerURI()), new KeyValuePair("org.jboss.soa.esb.registry.implementationClass", Configuration.getRegistryImplementationClass()), new KeyValuePair("org.jboss.soa.esb.registry.factoryClass", Configuration.getRegistryFactoryClass()), new KeyValuePair("org.jboss.soa.esb.registry.user", Configuration.getRegistryUser()), new KeyValuePair("org.jboss.soa.esb.registry.password", Configuration.getRegistryPassword()), new KeyValuePair("org.jboss.soa.esb.scout.proxy.transportClass", Configuration.getRegistryScoutTransportClass()), new KeyValuePair("org.jboss.soa.esb.scout.proxy.uddiVersion", Configuration.getRegistryUDDIVersion()), new KeyValuePair("org.jboss.soa.esb.scout.proxy.uddiNameSpace", Configuration.getRegistryUDDINameSpace()), new KeyValuePair("org.jboss.soa.esb.paramsRepository.class", Configuration.getParamRepositoryImplClass()), new KeyValuePair("org.jboss.soa.esb.objStore.configFile", Configuration.getObjStoreConfigFile()), new KeyValuePair("org.jboss.soa.esb.encryption.factory.class", Configuration.getEncryptionFactoryClass()), new KeyValuePair("org.jboss.soa.esb.loadbalancer.policy", Configuration.getLoadBalancerPolicy()), new KeyValuePair("org.jboss.soa.esb.dls.redeliver", Configuration.getRedeliveryDlsOn()), new KeyValuePair("org.jboss.soa.esb.registry.cache.life", Configuration.getRegistryCacheLife()), new KeyValuePair("org.jboss.soa.esb.persistence.db.connection.url", Configuration.getStoreUrl()), new KeyValuePair("org.jboss.soa.esb.persistence.db.jdbc.driver", Configuration.getStoreDriver()), new KeyValuePair("org.jboss.soa.esb.persistence.db.user", Configuration.getStoreUser()), new KeyValuePair("org.jboss.soa.esb.persistence.db.pwd", Configuration.getStorePwd()), new KeyValuePair("org.jboss.soa.esb.persistence.db.pool.min.size", Configuration.getStorePoolMinSize()), new KeyValuePair("org.jboss.soa.esb.persistence.db.pool.max.size", Configuration.getStorePoolMaxSize()), new KeyValuePair("org.jboss.soa.esb.persistence.db.pool.initial.size", Configuration.getStorePoolInitialSize()), new KeyValuePair("org.jboss.soa.esb.persistence.db.pool.test.table", Configuration.getStorePoolTestTable()), new KeyValuePair("org.jboss.soa.esb.persistence.db.pool.timeout.millis", Configuration.getStorePoolTimeoutMillis()), new KeyValuePair("org.jboss.soa.esb.persistence.db.conn.manager", Configuration.getStoreDBConnectionManager()), new KeyValuePair("org.jboss.soa.esb.persistence.db.datasource.name", Configuration.getStoreDBDatasourceName()), new KeyValuePair("org.jboss.soa.esb.registry.interceptors", Configuration.getRegistryInterceptors()), new KeyValuePair("org.jboss.soa.esb.registry.cache.maxSize", Configuration.getRegistryCacheMaxSize()), new KeyValuePair("org.jboss.soa.esb.registry.cache.validityPeriod", Configuration.getRegistryCacheValidityPeriod())};

    public static String dump() {
        StringBuilder sb = new StringBuilder("Dump of SystemProperties:\n");
        for (KeyValuePair oCurr : s_oaKV) {
            sb.append(oCurr.getKey()).append("=").append(oCurr.getValue()).append("\n");
        }
        return sb.append("______________________________________").toString();
    }

    public static String getSmtpHost() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.mail.smtp.host", "localhost");
    }

    public static String getSmtpUsername() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.mail.smtp.user", "");
    }

    public static String getSmtpPassword() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.mail.smtp.password", "");
    }

    public static String getSmtpPort() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.mail.smtp.port", "25");
    }

    public static String getSmtpFrom() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.mail.smtp.from");
    }

    public static String getSmtpAuth() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.mail.smtp.auth");
    }

    public static String getHttpHost() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.http.host");
    }

    public static String getHttpPort() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.http.port");
    }

    public static String getHttpSecurePort() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.http.securePort");
    }

    public static String getHttpResponseStatusEnabled() {
        return ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.http.responseStatusEnabled");
    }

    public static String getJndiServerURL() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.jndi.server.url", "localhost");
    }

    public static String getJndiServerContextFactory() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.jndi.server.context.factory", "org.jnp.interfaces.NamingContextFactory");
    }

    public static String getJndiServerPkgPrefix() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.jndi.server.pkg.prefix", "org.jnp.interfaces");
    }

    public static String getLoadBalancerPolicy() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.loadbalancer.policy", "org.jboss.soa.esb.listeners.ha.FirstAvailable");
    }

    public static String getRedeliveryDlsOn() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.dls.redeliver", "true");
    }

    public static String getRegistryCacheLife() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.registry.cache.life", "60000");
    }

    public static String getRegistryQueryManageURI() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.queryManagerURI");
    }

    public static String getRegistryLifecycleManagerURI() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.lifeCycleManagerURI");
    }

    public static String getRegistrySecurityManagerURI() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.securityManagerURI");
    }

    public static String getRegistryFactoryClass() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.factoryClass");
    }

    public static String getRegistryImplementationClass() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.implementationClass");
    }

    public static String getRegistryScoutTransportClass() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.scout.proxy.transportClass");
    }

    public static String getRegistryUDDIVersion() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.scout.proxy.uddiVersion");
    }

    public static String getRegistryUDDINameSpace() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.scout.proxy.uddiNameSpace");
    }

    public static String getRegistryUser() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.user");
    }

    public static String getRegistryPassword() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.password");
    }

    public static String getRegistrySemanticEquivalences() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.semanticEquivalences");
    }

    public static String getRegistryPostalAddressScheme() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.postalAddressScheme");
    }

    public static String getRegistrySecurityAuthenticationMethod() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.security.authenticationMethod");
    }

    public static String getRegistryUDDIMaxRows() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.uddi.maxRows");
    }

    public static String getParamRepositoryImplClass() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.paramsRepository.class");
    }

    public static String getObjStoreConfigFile() {
        String property = ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.objStore.configFile");
        return property;
    }

    public static String getEncryptionFactoryClass() {
        return ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.encryption.factory.class", DefaultEncryptionFactory.class.getName());
    }

    public static String getStoreUrl() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.connection.url");
        return property;
    }

    public static String getStoreDriver() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.jdbc.driver");
        return property;
    }

    public static String getStorePwd() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.pwd");
        return property;
    }

    public static String getStoreUser() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.user");
        return property;
    }

    public static String getStorePoolInitialSize() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.pool.initial.size");
        return property;
    }

    public static String getStorePoolMinSize() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.pool.min.size");
        return property;
    }

    public static String getStorePoolMaxSize() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.pool.max.size");
        return property;
    }

    public static String getStorePoolTestTable() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.pool.test.table");
        return property;
    }

    public static String getStorePoolTimeoutMillis() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.pool.timeout.millis");
        return property;
    }

    public static String getStoreDBConnectionManager() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.conn.manager");
        return property;
    }

    public static String getStoreDBDatasourceName() {
        String property = ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.db.datasource.name");
        return property;
    }

    public static String getJcrStoreJNDIPath() {
        return ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.jcr.jndi.path");
    }

    public static String getJcrStoreUsername() {
        return ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.jcr.username");
    }

    public static String getJcrStorePassword() {
        return ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.jcr.password");
    }

    public static String getJcrStoreRootNodePath() {
        return ModulePropertyManager.getPropertyManager("dbstore").getProperty("org.jboss.soa.esb.persistence.jcr.root.node.path");
    }

    public static String getRegistryInterceptors() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.interceptors", InVMRegistryInterceptor.class.getName());
    }

    public static String getRegistryCacheMaxSize() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.cache.maxSize");
    }

    public static String getRegistryCacheValidityPeriod() {
        return ModulePropertyManager.getPropertyManager("registry").getProperty("org.jboss.soa.esb.registry.cache.validityPeriod");
    }

    @Deprecated
    public static Context getNamingContext(String contextModuleName) throws ConfigurationException {
        Properties environment = Configuration.getProperties(contextModuleName);
        try {
            return new InitialContext(environment);
        }
        catch (NamingException ne) {
            throw new ConfigurationException("Failed to create JNDI context [" + contextModuleName + "].");
        }
    }

    private static Properties getProperties(String contextModuleName) {
        String providerUrl = ModulePropertyManager.getPropertyManager(contextModuleName).getProperty("java.naming.provider.url", "localhost");
        String initialContextFactory = ModulePropertyManager.getPropertyManager(contextModuleName).getProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        String urlPackagePrefix = ModulePropertyManager.getPropertyManager(contextModuleName).getProperty("java.naming.factory.url.pkgs", "");
        Properties environment = new Properties();
        environment.setProperty("java.naming.provider.url", providerUrl);
        environment.setProperty("java.naming.factory.initial", initialContextFactory);
        environment.setProperty("java.naming.factory.url.pkgs", urlPackagePrefix);
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionFactory getJmsConnectionFactory(String jmsConnectionFactoryModuleName) throws ConfigurationException {
        ConnectionFactory connectionFactory;
        Properties environment = Configuration.getProperties(jmsConnectionFactoryModuleName);
        Context context = NamingContextPool.getNamingContext(environment);
        try {
            String connectionFactoryRuntime = ModulePropertyManager.getPropertyManager(jmsConnectionFactoryModuleName).getProperty(ConnectionFactory.class.getName(), "ConnectionFactory");
            ConnectionFactory factory = null;
            try {
                factory = (ConnectionFactory)context.lookup(connectionFactoryRuntime);
            }
            catch (NamingException e) {
                throw new ConfigurationException("JNDI lookup of JMS Connection Factory [" + connectionFactoryRuntime + "] failed.", e);
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("JNDI lookup of JMS Connection Factory failed.  Class [" + connectionFactoryRuntime + "] is not an instance of [" + ConnectionFactory.class.getName() + "].", e);
            }
            connectionFactory = factory;
        }
        catch (Throwable throwable) {
            try {
                NamingContextPool.releaseNamingContext(context);
                throw throwable;
            }
            catch (NamingContextException nce) {
                throw new ConfigurationException("Unexpected exception while accessing naming context pool", nce);
            }
        }
        NamingContextPool.releaseNamingContext(context);
        return connectionFactory;
    }

    public static String getSecurityServiceImplementationClass() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.implementationClass");
    }

    public static String getSecurityServicePublicKeystore() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.publicKeystore");
    }

    public static String getSecurityServicePublicKeyAlias() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.publicKeyAlias");
    }

    public static String getSecurityServicePublicKeyPassword() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.publicKeyPassword");
    }

    public static String getSecurityServicePublicKeyTransformation() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.publicKeyTransformation");
    }

    public static String getSecurityServicePublicKeystorePassword() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.publicKeystorePassword");
    }

    public static String getSecurityServicePublicKeystoreType() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.publicKeystoreType");
    }

    public static String getSecurityServiceCallbackHandlerImplClass() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.callbackHandler");
    }

    public static String getSecurityServiceSealAlgorithm() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.sealAlgorithm");
    }

    public static String getSecurityServiceSealKeySize() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.sealKeySize");
    }

    public static String getSecurityServiceContextTimeout() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.contextTimeout");
    }

    public static Properties getSecurityServiceProperies() {
        return ModulePropertyManager.getPropertyManager("security").getProperties();
    }

    public static String getSecurityContextPropagatorImplementationClass() {
        return ModulePropertyManager.getPropertyManager("security").getProperty("org.jboss.soa.esb.services.security.contextPropagatorImplementationClass");
    }
}

