/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.internal.soa.esb.addressing.helpers.EPRHelper;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.addressing.EPR;

public class EPRManager {
    private String _directory;
    private static Hashtable<String, EPRManager> _instances = new Hashtable();

    public static final EPRManager getInstance() {
        return EPRManager.getInstance("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EPRManager getInstance(String domain) {
        if (domain == null) {
            domain = "";
        }
        Hashtable<String, EPRManager> hashtable = _instances;
        synchronized (hashtable) {
            EPRManager theInstance = _instances.get(domain);
            if (theInstance == null) {
                theInstance = new EPRManager(domain);
                _instances.put(domain, theInstance);
            }
            return theInstance;
        }
    }

    public final String getDomain() {
        return this._directory;
    }

    public boolean equals(Object manager) {
        EPRManager comp;
        return manager instanceof EPRManager && this._directory.equals((comp = (EPRManager)manager).getDomain());
    }

    public int hashCode() {
        return this._directory.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveEPR(String name, EPR address) throws IOException {
        if (name == null || address == null) {
            throw new IllegalArgumentException();
        }
        try {
            String documentAsString = EPRHelper.toXMLString(address);
            FileOutputStream output = new FileOutputStream(this._directory + File.separator + name);
            try {
                output.write(documentAsString.getBytes());
                output.flush();
                output.getFD().sync();
            }
            finally {
                output.close();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public final void removeEPR(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        File theFile = new File(this._directory + File.separator + name);
        if (!theFile.exists()) {
            throw new FileNotFoundException();
        }
        theFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final EPR loadEPR(String name) throws IOException {
        EPR ePR;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        File theFile = new File(this._directory + File.separator + name);
        if (!theFile.exists()) throw new FileNotFoundException(theFile.toString());
        FileReader reader = new FileReader(theFile);
        try {
            XMLStreamReader in = XMLHelper.getXMLStreamReader(reader);
            StreamHelper.skipToNextStartElement(in);
            ePR = EPRHelper.fromXML(in);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (XMLStreamException xmlse) {
                IOException ioe = new IOException("Failed to parse EPR file: " + theFile.getAbsolutePath());
                ioe.initCause(xmlse);
                throw ioe;
            }
        }
        reader.close();
        return ePR;
    }

    protected EPRManager(String domain) {
        this._directory = domain;
    }
}

