/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.util.JndiUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JMSEpr
extends EPR {
    private Logger log = Logger.getLogger(JMSEpr.class);
    public static final String JMS_PROTOCOL = "jms";
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String ONE_ONE_PROTOCOL = "1.1";
    public static final String ONE_ZERO_TWO_PROTOCOL = "1.0.2b";
    public static final String SPECIFICATION_VERSION_TAG = "specification-version";
    public static final String DESTINATION_TYPE_TAG = "destination-type";
    public static final String DESTINATION_NAME_TAG = "destination-name";
    public static final String CONNECTION_FACTORY_TAG = "connection-factory";
    public static final String MAX_SESSIONS_PER_CONNECTION = "max-sessions-per-connection";
    public static final String MAX_XA_SESSIONS_PER_CONNECTION = "max-xa-sessions-per-connection";
    public static final String JNDI_PKG_PREFIX_TAG = "jndi-pkg-prefix";
    public static final String JNDI_URL_TAG = "jndi-URL";
    public static final String JNDI_CONTEXT_FACTORY_TAG = "jndi-context-factory";
    public static final String MESSAGE_SELECTOR_TAG = "message-selector";
    public static final String QUEUE_TYPE = "queue";
    public static final String TOPIC_TYPE = "topic";
    public static final String DEFAULT_REPLY_TO_DESTINATION_SUFFIX = "_reply";
    public static final String PERSISTENT_TAG = "persistent";
    public static final String TRANSACTED_TAG = "transacted";
    public static final String JNDI_PREFIXES = "jndi-prefixes";
    public static final String ACKNOWLEDGE_MODE_TAG = "acknowledge-mode";
    public static final String JMS_SECURITY_PRINCIPAL_TAG = "jms-security-principal";
    public static final String JMS_SECURITY_CREDENTIAL_TAG = "jms-security-credential";
    private static final String DEFAULT_ACKNOWLEDGE_MODE = AcknowledgeMode.AUTO_ACKNOWLEDGE.toString();
    private static URI _type;

    public JMSEpr(EPR epr) {
        super(epr);
    }

    public JMSEpr(EPR epr, Element header) {
        super(epr);
        NodeList nl = header.getChildNodes();
        String uri = null;
        String name = null;
        String jndiPrefixesValue = null;
        TreeMap<String, String> extensions = new TreeMap<String, String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            String prefix = nl.item(i).getPrefix();
            String tag = nl.item(i).getLocalName();
            if (prefix == null || !prefix.equals("jbossesb") || tag == null) continue;
            String value = nl.item(i).getTextContent();
            if (tag.startsWith("java.naming.")) {
                this.getAddr().addExtension(tag, value);
                continue;
            }
            if (tag.equals(SPECIFICATION_VERSION_TAG)) {
                this.getAddr().addExtension(SPECIFICATION_VERSION_TAG, value);
                continue;
            }
            if (tag.equals(DESTINATION_NAME_TAG)) {
                name = value;
                continue;
            }
            if (tag.equals(CONNECTION_FACTORY_TAG)) {
                this.getAddr().addExtension(CONNECTION_FACTORY_TAG, value);
                continue;
            }
            if (tag.equals(JNDI_CONTEXT_FACTORY_TAG)) {
                this.getAddr().addExtension("java.naming.factory.initial", value);
                continue;
            }
            if (tag.equals(JNDI_PKG_PREFIX_TAG)) {
                this.getAddr().addExtension("java.naming.factory.url.pkgs", value);
                continue;
            }
            if (tag.equals(JNDI_URL_TAG)) {
                uri = value;
                this.getAddr().addExtension("java.naming.provider.url", uri);
                continue;
            }
            if (tag.equals(MESSAGE_SELECTOR_TAG)) {
                this.getAddr().addExtension(MESSAGE_SELECTOR_TAG, value);
                continue;
            }
            if (tag.equals(PERSISTENT_TAG)) {
                boolean persistent = true;
                String persistentStr = value;
                if (persistentStr != null) {
                    persistent = Boolean.parseBoolean(persistentStr);
                }
                this.getAddr().addExtension(PERSISTENT_TAG, String.valueOf(persistent));
                continue;
            }
            if (tag.equals(ACKNOWLEDGE_MODE_TAG)) {
                String ackMode = value;
                this.getAddr().addExtension(ACKNOWLEDGE_MODE_TAG, String.valueOf(ackMode));
                continue;
            }
            if (tag.equals(JMS_SECURITY_PRINCIPAL_TAG)) {
                String username = value;
                this.getAddr().addExtension(JMS_SECURITY_PRINCIPAL_TAG, String.valueOf(username));
                continue;
            }
            if (tag.equals(JMS_SECURITY_CREDENTIAL_TAG)) {
                String password = value;
                this.getAddr().addExtension(JMS_SECURITY_CREDENTIAL_TAG, String.valueOf(password));
                continue;
            }
            if (tag.equals(DESTINATION_TYPE_TAG)) {
                this.getAddr().addExtension(DESTINATION_TYPE_TAG, value);
                continue;
            }
            if (tag.equals(TRANSACTED_TAG)) {
                boolean transacted = false;
                String transactedStr = value;
                if (transactedStr != null) {
                    transacted = Boolean.parseBoolean(transactedStr);
                }
                this.getAddr().addExtension(TRANSACTED_TAG, String.valueOf(transacted));
                continue;
            }
            if (tag.equals(JNDI_PREFIXES)) {
                jndiPrefixesValue = value;
                this.getAddr().addExtension(JNDI_PREFIXES, value);
                continue;
            }
            extensions.put(tag, value);
        }
        if (jndiPrefixesValue != null) {
            String[] jndiPrefixes = JndiUtil.getJndiPrefixes(jndiPrefixesValue);
            block1: for (Map.Entry entry : extensions.entrySet()) {
                for (String jndiPrefix : jndiPrefixes) {
                    String tag = (String)entry.getKey();
                    if (!tag.startsWith(jndiPrefix)) continue;
                    this.getAddr().addExtension(tag, (String)entry.getValue());
                    continue block1;
                }
            }
        }
        if (uri != null) {
            String address = this.getJmsAddress(uri, name);
            this.setAddr(new PortReference(address));
        }
    }

    public JMSEpr(String destinationType, String destinationName, String connection) {
        this(ONE_ONE_PROTOCOL, destinationType, destinationName, connection, null, null, true);
    }

    public JMSEpr(String destinationType, String destinationName, String connection, Properties environment, String messageSelector) {
        this(ONE_ONE_PROTOCOL, destinationType, destinationName, connection, environment, messageSelector, true);
    }

    public JMSEpr(String protocol, String destinationType, String destinationName, String connection, Properties environment, String messageSelector) {
        this(protocol, destinationType, destinationName, connection, environment, messageSelector, true);
    }

    public JMSEpr(String protocol, String destinationType, String destinationName, String connection, Properties environment, String messageSelector, boolean peristent) {
        this(protocol, destinationType, destinationName, connection, environment, messageSelector, peristent, DEFAULT_ACKNOWLEDGE_MODE);
    }

    public JMSEpr(String protocol, String destinationType, String destinationName, String connection, Properties environment, String messageSelector, boolean peristent, boolean transacted) {
        this(protocol, destinationType, destinationName, connection, environment, messageSelector, peristent, DEFAULT_ACKNOWLEDGE_MODE, transacted);
    }

    public JMSEpr(String protocol, String destinationType, String destinationName, String connection, Properties environment, String messageSelector, boolean peristent, String acknowledgeModeStr, boolean transacted) {
        this(protocol, destinationType, destinationName, connection, environment, messageSelector, peristent, acknowledgeModeStr, null, null, transacted);
    }

    public JMSEpr(String protocol, String destinationType, String destinationName, String connection, Properties environment, String messageSelector, boolean peristent, String acknowledgeModeStr) {
        this(protocol, destinationType, destinationName, connection, environment, messageSelector, peristent, acknowledgeModeStr, null, null, false);
    }

    public JMSEpr(String protocol, String destinationType, String destinationName, String connection, Properties environment, String messageSelector, boolean peristent, String acknowledgeModeStr, String username, String password) {
        this(protocol, destinationType, destinationName, connection, environment, messageSelector, peristent, acknowledgeModeStr, username, password, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JMSEpr(String protocol, String destinationType, String destinationName, String connection, Properties environment, String messageSelector, boolean peristent, String acknowledgeModeStr, String username, String password, boolean transacted) {
        if (protocol == null || destinationType == null || destinationName == null || connection == null) {
            throw new IllegalArgumentException();
        }
        if (!protocol.equals(ONE_ONE_PROTOCOL) && !protocol.equals(ONE_ZERO_TWO_PROTOCOL)) throw new IllegalArgumentException("Invalid specification version!");
        if (!destinationType.equals(QUEUE_TYPE) && !destinationType.equals(TOPIC_TYPE)) throw new IllegalArgumentException("Invalid destination type! " + destinationType);
        String uri = null;
        String name = null;
        PortReference addr = new PortReference();
        if (environment != null) {
            for (Object key : environment.keySet()) {
                if (key.toString().equals(JNDI_URL_TAG)) {
                    uri = environment.getProperty(key.toString());
                    continue;
                }
                if (key.toString().equals(DESTINATION_NAME_TAG)) {
                    name = environment.getProperty(key.toString());
                    if (destinationName == null || name.equals(destinationName)) continue;
                    throw new IllegalArgumentException("Destination name inconsistency: < " + name + ", " + destinationName + " >");
                }
                addr.addExtension(key.toString(), environment.getProperty(key.toString()));
            }
        }
        if (uri == null) {
            uri = addr.getExtensionValue("java.naming.provider.url");
        }
        if (uri == null) {
            uri = Configuration.getJndiServerURL();
        }
        if (name == null) {
            name = destinationName;
        }
        addr.setAddress(this.getJmsAddress(uri, name));
        addr.addExtension(DESTINATION_TYPE_TAG, destinationType);
        addr.addExtension(DESTINATION_NAME_TAG, destinationName);
        addr.addExtension(SPECIFICATION_VERSION_TAG, protocol);
        if (connection != null) {
            addr.addExtension(CONNECTION_FACTORY_TAG, connection);
        }
        if (messageSelector != null) {
            addr.addExtension(MESSAGE_SELECTOR_TAG, messageSelector);
        }
        addr.addExtension(PERSISTENT_TAG, String.valueOf(peristent));
        addr.addExtension(ACKNOWLEDGE_MODE_TAG, String.valueOf((Object)AcknowledgeMode.getAckMode(acknowledgeModeStr)));
        this.setAddr(addr);
        if (username != null) {
            addr.addExtension(JMS_SECURITY_PRINCIPAL_TAG, username);
        }
        if (password != null) {
            addr.addExtension(JMS_SECURITY_CREDENTIAL_TAG, password);
        }
        addr.addExtension(TRANSACTED_TAG, String.valueOf(transacted));
    }

    public final String getDestinationType() {
        return this.getAddr().getExtensionValue(DESTINATION_TYPE_TAG);
    }

    public final String getVersion() {
        return this.getAddr().getExtensionValue(SPECIFICATION_VERSION_TAG);
    }

    public final String getDestinationName() {
        String name = this.getAddr().getExtensionValue(DESTINATION_NAME_TAG);
        if (name != null) {
            return name;
        }
        try {
            URI uri = new URI(this.getAddr().getAddress());
            return uri.getPath().substring(1);
        }
        catch (URISyntaxException ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return null;
        }
    }

    public final String getConnectionFactory() {
        return this.getAddr().getExtensionValue(CONNECTION_FACTORY_TAG);
    }

    public final Properties getJndiEnvironment() {
        Properties properties = new Properties();
        String jndiPrefixesValue = this.getAddr().getExtensionValue(JNDI_PREFIXES);
        if (jndiPrefixesValue != null) {
            properties.put(JNDI_PREFIXES, jndiPrefixesValue);
        }
        String[] jndiPrefixes = JndiUtil.getJndiPrefixes(jndiPrefixesValue);
        Iterator<PortReference.Extension> iter = this.getAddr().getExtensions();
        block0: while (iter.hasNext()) {
            PortReference.Extension extension = iter.next();
            String tag = extension.getTag();
            if (tag.equals(MAX_SESSIONS_PER_CONNECTION) || tag.equals(MAX_XA_SESSIONS_PER_CONNECTION)) {
                properties.put(tag, extension.getValue());
                continue;
            }
            for (String jndiPrefix : jndiPrefixes) {
                if (!tag.startsWith(jndiPrefix) || extension.getValue() == null) continue;
                properties.put(tag, extension.getValue());
                continue block0;
            }
        }
        if (!properties.containsKey("java.naming.factory.initial")) {
            properties.setProperty("java.naming.factory.initial", Configuration.getJndiServerContextFactory());
        }
        if (!properties.containsKey("java.naming.provider.url")) {
            properties.setProperty("java.naming.provider.url", Configuration.getJndiServerURL());
        }
        return properties;
    }

    public static String[] getJndiPrefixes(String jndiPrefixesValue) {
        return JndiUtil.getJndiPrefixes(jndiPrefixesValue);
    }

    public final String getMessageSelector() {
        return this.getAddr().getExtensionValue(MESSAGE_SELECTOR_TAG);
    }

    public final boolean getPersistent() {
        return Boolean.parseBoolean(this.getAddr().getExtensionValue(PERSISTENT_TAG));
    }

    public final int getAcknowledgeMode() {
        AcknowledgeMode ackMode = AcknowledgeMode.getAckMode(this.getAddr().getExtensionValue(ACKNOWLEDGE_MODE_TAG));
        return ackMode.getAcknowledgeModeInt();
    }

    public final String getJMSSecurityPrincipal() {
        String username = this.getAddr().getExtensionValue(JMS_SECURITY_PRINCIPAL_TAG);
        return username == null || username.equals("null") ? null : username;
    }

    public final String getJMSSecurityCredential() {
        String password = this.getAddr().getExtensionValue(JMS_SECURITY_CREDENTIAL_TAG);
        return password == null || password.equals("null") ? null : password;
    }

    public final boolean getTransacted() {
        return Boolean.parseBoolean(this.getAddr().getExtensionValue(TRANSACTED_TAG));
    }

    public EPR copy() {
        return new JMSEpr(this);
    }

    private String getJmsAddress(String uri, String name) {
        try {
            URI result = new URI(JMS_PROTOCOL, uri, name);
            return result.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return "jms://" + uri + "/" + name;
        }
    }

    public String toString() {
        return "JMSEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    public static final URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/jms");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AcknowledgeMode {
        CLIENT_ACKNOWLEDGE(2),
        AUTO_ACKNOWLEDGE(1),
        DUPS_OK_ACKNOWLEDGE(3);

        private static Logger log;
        private int jmsAckModeInt;

        private AcknowledgeMode(int jmsAckModeInt) {
            this.jmsAckModeInt = jmsAckModeInt;
        }

        public int getAcknowledgeModeInt() {
            return this.jmsAckModeInt;
        }

        public static AcknowledgeMode getAckMode(String ackMode) {
            if (ackMode != null) {
                try {
                    return AcknowledgeMode.valueOf(ackMode);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)("' " + ackMode + "' is invalid : " + ".Will use default '" + (Object)((Object)AUTO_ACKNOWLEDGE)));
                }
            }
            return AUTO_ACKNOWLEDGE;
        }

        static {
            log = Logger.getLogger(AcknowledgeMode.class);
        }
    }
}

